/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmLayerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmPolygonTileSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.datasource.kml.KmlLineString;
import de.wideportal.maprender.datasource.osm.PostgresPolygon;
import de.wideportal.maprender.datasource.osm.PostgresPolygonElement;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.file.FileLoader;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmPolygonTileSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderPolygonTileSymbolizer(OsmPolygonTileSymbolizerAccessor polygonTileSymbolizer, RenderImageLayer renderLayer, KmlLineString kmlLineString, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule, RenderRequest renderRequest, OsmLayerAccessor layer) {
        PostgresPolygon latLonPolygon = new PostgresPolygon(kmlLineString);
        this.renderPolygonTileSymbolizer(polygonTileSymbolizer, renderLayer, latLonPolygon, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, renderRequest, layer);
    }

    public void renderPolygonTileSymbolizer(OsmPolygonTileSymbolizerAccessor polygonTileSymbolizer, RenderImageLayer renderLayer, PostgresPolygon latLonPolygon, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule, RenderRequest renderRequest, OsmLayerAccessor layer) {
        if (latLonPolygon.getPolygonElements().length == 0) {
            return;
        }
        Graphics2D canvas = renderLayer.getCanvas();
        float opacity = polygonTileSymbolizer.getOpacity().floatValue();
        Optional<String> optionalBaseFolder = polygonTileSymbolizer.getFolder();
        if (!optionalBaseFolder.isPresent()) {
            this.log.warn("renderPolygonTileSymbolizer: no base folder for the tiles is given. This is most likely a misconfiguration.");
            throw new RuntimeException("renderPolygonTileSymbolizer: no base folder for the tiles is given. This is most likely a misconfiguration.");
        }
        FileLoader fileLoader = new FileLoader();
        Optional<BufferedImage> optionalTileImage = fileLoader.loadOsmTile(renderRequest, optionalBaseFolder.get());
        if (!optionalTileImage.isPresent()) {
            this.log.warn("renderPolygonTileSymbolizer: no tile found. This is most likely a misconfiguration.");
            throw new RuntimeException("renderPolygonTileSymbolizer: no tile found. This is most likely a misconfiguration.");
        }
        AlphaComposite renderOpacity = AlphaComposite.getInstance(3, opacity);
        canvas.setComposite(renderOpacity);
        TexturePaint texture = new TexturePaint(optionalTileImage.get(), new Rectangle(0, 0, optionalTileImage.get().getWidth(), optionalTileImage.get().getHeight()));
        canvas.setPaint(texture);
        Polygon rootPolygon = this.getPolygonForMercatorElement(geoCalculator, tileOutputter, latLonPolygon.getPolygonElements()[0], zoom, xOffset, yOffset);
        Area polygonArea = new Area(rootPolygon);
        for (int i = 1; i < latLonPolygon.getPolygonElements().length; ++i) {
            Polygon subPolygon = this.getPolygonForMercatorElement(geoCalculator, tileOutputter, latLonPolygon.getPolygonElements()[i], zoom, xOffset, yOffset);
            Area subPolygonArea = new Area(subPolygon);
            polygonArea.subtract(subPolygonArea);
        }
        canvas.fill(polygonArea);
    }

    private Polygon getPolygonForMercatorElement(GeoCalculator geoCalculator, AbstractMapTileOutput tileOutputter, PostgresPolygonElement mercatorPolygonElement, double zoom, double xOffset, double yOffset) {
        Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(mercatorPolygonElement.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
        int[][] xyValues = PostgresPolygonElement.getPointsAsIntArray(xyTilePoints);
        Polygon polygon = new Polygon(xyValues[0], xyValues[1], xyValues[0].length);
        return polygon;
    }
}

