/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmMarkersSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.renderer.blocking.RenderMarkerItem;
import de.wideportal.maprender.renderer.blocking.RenderOverlapManager;
import de.wideportal.maprender.renderer.text.TextRowContainer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.symbols.SymbolsCache;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmMarkersSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderMarkersSymbolizer(OsmMarkersSymbolizerAccessor markerSymbolizer, RenderImageLayer renderLayer, Point xyTilePixel, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, SymbolsCache symbolsCache, RenderRequest renderRequest, OsmRuleAccessor rule) {
        Optional<String> optionalFile;
        Graphics2D canvas = renderLayer.getCanvas();
        boolean isWidthSet = markerSymbolizer.isWidthSet();
        boolean isHeightSet = markerSymbolizer.isHeightSet();
        boolean isFillSet = markerSymbolizer.isFillSet();
        boolean isStrokeSet = markerSymbolizer.isStrokeSet();
        double width = markerSymbolizer.getWidth();
        double height = markerSymbolizer.getHeight();
        float strokeWidth = markerSymbolizer.getStrokeWidth().floatValue();
        double diameter = -1.0;
        boolean drawEllipse = false;
        boolean forgetPlacement = markerSymbolizer.getIgnorePlacement();
        if (isWidthSet && !isHeightSet) {
            diameter = width;
            height = width;
        }
        if (!isWidthSet && isHeightSet) {
            diameter = height;
            width = height;
        }
        if (strokeWidth == 0.0f && isFillSet) {
            diameter = width;
            drawEllipse = true;
        }
        float opacityFill = markerSymbolizer.getOpacity().floatValue();
        AlphaComposite renderOpacity = AlphaComposite.getInstance(3, opacityFill);
        canvas.setComposite(renderOpacity);
        canvas.setStroke(this.getBasicStroke(markerSymbolizer));
        Color colorFill = markerSymbolizer.getFill();
        if (isFillSet) {
            canvas.setColor(colorFill);
        }
        if ((optionalFile = markerSymbolizer.getFile()).isPresent()) {
            this.renderImage(renderRequest, markerSymbolizer, symbolsCache, geoCalculator, canvas, xyTilePixel, null, false, zoom, width, height, diameter, optionalFile.get(), isWidthSet, isHeightSet, drawEllipse, forgetPlacement, isFillSet, 0.0, null);
        } else {
            this.renderEllipse(renderRequest, markerSymbolizer, canvas, xyTilePixel, zoom, width, height, diameter, drawEllipse, forgetPlacement, isFillSet, isStrokeSet, 0.0, null);
        }
    }

    public void renderMarkersSymbolizer(OsmMarkersSymbolizerAccessor markerSymbolizer, RenderImageLayer renderLayer, PostgresLineString mercatorLineString, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, SymbolsCache symbolsCache, RenderRequest renderRequest, OsmRuleAccessor rule) {
        Graphics2D canvas = renderLayer.getCanvas();
        double spacing = markerSymbolizer.getSpacing();
        double zoomScaleMultiplicator = this.getZoomScaleMultiplicatorTextLine(zoom);
        double pixelSpacing = spacing * zoomScaleMultiplicator;
        boolean isWidthSet = markerSymbolizer.isWidthSet();
        boolean isHeightSet = markerSymbolizer.isHeightSet();
        boolean isFillSet = markerSymbolizer.isFillSet();
        boolean isStrokeSet = markerSymbolizer.isStrokeSet();
        double width = markerSymbolizer.getWidth();
        double height = markerSymbolizer.getHeight();
        float strokeWidth = markerSymbolizer.getStrokeWidth().floatValue();
        double diameter = -1.0;
        boolean drawEllipse = false;
        boolean forgetPlacement = markerSymbolizer.getIgnorePlacement();
        if (isWidthSet && !isHeightSet) {
            diameter = width;
            height = width;
        }
        if (!isWidthSet && isHeightSet) {
            diameter = height;
            width = height;
        }
        if (strokeWidth == 0.0f && isFillSet) {
            diameter = width;
            drawEllipse = true;
        }
        float opacityFill = markerSymbolizer.getOpacity().floatValue();
        AlphaComposite renderOpacity = AlphaComposite.getInstance(3, opacityFill);
        canvas.setComposite(renderOpacity);
        canvas.setStroke(this.getBasicStroke(markerSymbolizer));
        Color colorFill = markerSymbolizer.getFill();
        if (isFillSet) {
            canvas.setColor(colorFill);
        }
        Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(mercatorLineString.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
        BoundingBox clipBBox = renderRequest.getBoundingBoxPixel();
        clipBBox.increaseBBox(tileOutputter.getTileSize());
        LineSequence lineSequence = new LineSequence(xyTilePoints);
        LineSequence.NextPointOnLineIterator<Point> nextRenderPointIterator = lineSequence.getIterator(pixelSpacing / 2.0 - 1.0, Math.max(width, height));
        while (nextRenderPointIterator.hasNext()) {
            Point xyTilePixel = nextRenderPointIterator.next();
            if (!clipBBox.contains(xyTilePixel) || xyTilePixel == null) continue;
            int currentLineIndex = nextRenderPointIterator.getCurrentLineIndex();
            Line currentLine = nextRenderPointIterator.getIteratorLines().get(currentLineIndex);
            Optional<String> optionalFile = markerSymbolizer.getFile();
            if (optionalFile.isPresent()) {
                this.renderImage(renderRequest, markerSymbolizer, symbolsCache, geoCalculator, canvas, xyTilePixel, currentLine, true, zoom, width, height, diameter, optionalFile.get(), isWidthSet, isHeightSet, drawEllipse, forgetPlacement, isFillSet, pixelSpacing, lineSequence);
                continue;
            }
            this.renderEllipse(renderRequest, markerSymbolizer, canvas, xyTilePixel, zoom, width, height, diameter, drawEllipse, forgetPlacement, isFillSet, isStrokeSet, pixelSpacing, lineSequence);
        }
    }

    private void renderImage(RenderRequest renderRequest, OsmMarkersSymbolizerAccessor markerSymbolizer, SymbolsCache symbolsCache, GeoCalculator geoCalculator, Graphics2D canvas, Point xyTilePixel, Line currentLine, boolean drawOnNullNull, double zoom, double width, double height, double diameter, String file, boolean isWidthSet, boolean isHeightSet, boolean drawEllipse, boolean forgetPlacement, boolean isFillSet, double pixelSpacing, LineSequence lineSequence) {
        BufferedImage symbol = symbolsCache.getSymbol(file);
        if (symbol == null) {
            this.log.error("renderImage: no symbol file available: " + file + ". Skip rendering of tile.");
            throw new RuntimeException("renderImage: no symbol file available: " + file + ". Skip rendering of tile.");
        }
        if (!isWidthSet && !isHeightSet) {
            width = symbol.getWidth();
            height = symbol.getHeight();
        }
        RectangularShape renderShape = null;
        Rectangle rectangleShape = new Rectangle((int)(xyTilePixel.getX() - width / 2.0), (int)(xyTilePixel.getY() - height / 2.0), (int)width, (int)height);
        Ellipse2D.Double ellipseShape = new Ellipse2D.Double(xyTilePixel.getX() - diameter / 2.0, xyTilePixel.getY() - diameter / 2.0, diameter, diameter);
        BoundingBox markerBBox = new BoundingBox(new Point(rectangleShape.getMinX(), rectangleShape.getMinY()), Math.max(width, height), Math.max(width, height));
        TextRowContainer dummyContainer = TextRowContainer.createDummy(markerSymbolizer.toString());
        RenderMarkerItem renderMarkerItem = new RenderMarkerItem(markerBBox, xyTilePixel, zoom, renderRequest.getTileIndex(), markerSymbolizer.toString(), lineSequence, dummyContainer);
        RenderOverlapManager allOverlapManager = renderRequest.getRenderOverlapManager();
        if (allOverlapManager.hasOverlappingItemsMarkerSpacing(renderMarkerItem, true, true, true, true, pixelSpacing, lineSequence)) {
            return;
        }
        if (!forgetPlacement) {
            allOverlapManager.addRenderMarkerItem(renderMarkerItem);
        }
        if (drawOnNullNull) {
            rectangleShape = new Rectangle((int)(0.0 - width / 2.0), (int)(0.0 - height / 2.0), (int)width, (int)height);
            ellipseShape = new Ellipse2D.Double(0.0 - diameter / 2.0, 0.0 - diameter / 2.0, diameter, diameter);
        }
        renderShape = drawEllipse ? ellipseShape : rectangleShape;
        BufferedImage maskedSymbol = symbol;
        if (isFillSet) {
            Color colorFill = markerSymbolizer.getFill();
            maskedSymbol = this.getMaskedSymbol(symbol, colorFill);
        }
        TexturePaint texture = new TexturePaint(maskedSymbol, rectangleShape);
        canvas.setPaint(texture);
        if (currentLine != null) {
            double rotation = geoCalculator.getRotation(currentLine.getStart().getX(), currentLine.getStart().getY(), currentLine.getStop().getX(), currentLine.getStop().getY());
            if (height % 2.0 == 1.0 && (rotation > 180.0 || rotation < -180.0)) {
                renderShape = new Rectangle((int)(0.0 - width / 2.0), (int)(0.0 - height / 2.0 - 1.0), (int)width, (int)height);
            }
            canvas.translate(xyTilePixel.getX(), xyTilePixel.getY());
            canvas.rotate(Math.toRadians(rotation));
            canvas.fill(renderShape);
            canvas.rotate(Math.toRadians(-rotation));
            canvas.translate(-xyTilePixel.getX(), -xyTilePixel.getY());
        } else {
            canvas.fill(renderShape);
        }
    }

    private void renderEllipse(RenderRequest renderRequest, OsmMarkersSymbolizerAccessor markerSymbolizer, Graphics2D canvas, Point xyTilePixel, double zoom, double width, double height, double diameter, boolean drawEllipse, boolean forgetPlacement, boolean isFillSet, boolean isStrokeSet, double pixelSpacing, LineSequence lineSequence) {
        RectangularShape renderShape = null;
        Rectangle rectangleShape = new Rectangle((int)(xyTilePixel.getX() - width / 2.0), (int)(xyTilePixel.y - height / 2.0), (int)width, (int)height);
        Ellipse2D.Double ellipseShape = new Ellipse2D.Double(xyTilePixel.getX() - diameter / 2.0, xyTilePixel.y - diameter / 2.0, diameter, diameter);
        BoundingBox markerBBox = new BoundingBox(rectangleShape, true);
        if (drawEllipse) {
            renderShape = ellipseShape;
        } else {
            markerBBox.increaseBBox(0.0);
            renderShape = rectangleShape;
        }
        TextRowContainer dummyContainer = TextRowContainer.createDummy(markerSymbolizer.toString());
        RenderMarkerItem renderMarkerItem = new RenderMarkerItem(markerBBox, xyTilePixel, zoom, renderRequest.getTileIndex(), markerSymbolizer.toString(), lineSequence, dummyContainer);
        RenderOverlapManager allOverlapManager = renderRequest.getRenderOverlapManager();
        if (allOverlapManager.hasOverlappingItemsMarkerSpacing(renderMarkerItem, true, true, true, true, pixelSpacing, lineSequence)) {
            return;
        }
        if (!forgetPlacement) {
            allOverlapManager.addRenderMarkerItem(renderMarkerItem);
        }
        if (isFillSet) {
            canvas.fill(renderShape);
        }
        if (isStrokeSet) {
            Color colorStroke = markerSymbolizer.getStroke();
            canvas.setColor(colorStroke);
            float opacityStroke = markerSymbolizer.getStrokeOpacity().floatValue();
            AlphaComposite renderOpacityStroke = AlphaComposite.getInstance(3, opacityStroke);
            canvas.setComposite(renderOpacityStroke);
            canvas.draw(renderShape);
        }
    }

    private BasicStroke getBasicStroke(OsmMarkersSymbolizerAccessor markerSymbolizer) {
        float width = markerSymbolizer.getStrokeWidth().floatValue();
        BasicStroke basicStroke = new BasicStroke(width, 1, 1);
        return basicStroke;
    }
}

