/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmLinePatternSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.symbols.SymbolsCache;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmLinePatternSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderLinePatternSymbolizer(OsmLinePatternSymbolizerAccessor linePatternSymbolizer, RenderImageLayer renderLayer, PostgresLineString mercatorLineString, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, SymbolsCache symbolsCache, OsmRuleAccessor rule) {
        Graphics2D canvas = renderLayer.getCanvas();
        float opacity = linePatternSymbolizer.getOpacity().floatValue();
        AlphaComposite renderOpacity = AlphaComposite.getInstance(3, opacity);
        canvas.setComposite(renderOpacity);
        if (!linePatternSymbolizer.getFile().isPresent()) {
            this.log.error("renderLinePatternSymbolizer: no symbol file given.");
            throw new RuntimeException("renderLinePatternSymbolizer: no symbol file was given. This is most likely a misconfiguration.");
        }
        Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(mercatorLineString.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
        BufferedImage symbol = symbolsCache.getSymbol(linePatternSymbolizer.getFile().get());
        if (symbol == null) {
            this.log.error("renderLinePatternSymbolizer: no symbol file available: " + linePatternSymbolizer.getFile() + ". Skip rendering of tile.");
            throw new RuntimeException("renderLinePatternSymbolizer: no symbol file available: " + linePatternSymbolizer.getFile() + ". Skip rendering of tile.");
        }
        double symbolWidth = symbol.getWidth();
        double lineLength = 0.0;
        for (int i = 0; i < xyTilePoints.length; ++i) {
            if (i >= xyTilePoints.length - 1) continue;
            Point point = xyTilePoints[i];
            Point nextPoint = xyTilePoints[i + 1];
            double rotation = geoCalculator.getRotation(point.getX(), point.getY(), nextPoint.getX(), nextPoint.getY());
            double length = geoCalculator.getNewXLengthAfterRotationToXAxis(point.getX(), point.getY(), nextPoint.getX(), nextPoint.getY());
            double currentTextureOffset = lineLength % symbolWidth;
            TexturePaint texture = new TexturePaint(symbol, new Rectangle(-((int)currentTextureOffset), -symbol.getHeight() / 2, symbol.getWidth(), symbol.getHeight()));
            canvas.setPaint(texture);
            canvas.setStroke(this.getBasicStroke(symbol.getHeight()));
            canvas.translate(point.getX(), point.getY());
            canvas.rotate(Math.toRadians(rotation));
            canvas.drawLine(0, 0, (int)length, 0);
            canvas.rotate(Math.toRadians(-rotation));
            canvas.translate(-point.getX(), -point.getY());
            lineLength += length;
        }
    }

    private BasicStroke getBasicStroke(float strokeWidth) {
        int lineCap = 0;
        int lineJoin = 1;
        BasicStroke basicStroke = new BasicStroke(strokeWidth, lineCap, lineJoin);
        return basicStroke;
    }
}

