/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmHeightSurroundReliefSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.HeightTileAccessor;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.srtm.SrtmLineHeightContainer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmHeightSurroundReliefSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderHeight(RenderRequest renderRequest, OsmHeightSurroundReliefSymbolizerAccessor heightSurroundReliefSymbolizer, RenderImageLayer renderLayer, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule) {
        BoundingBox latLonBoundingBox;
        int yTileIndex;
        int xTileIndex;
        Color color = heightSurroundReliefSymbolizer.getColor();
        boolean renderMockTiles = heightSurroundReliefSymbolizer.getRenderMockTiles();
        int flattenNoise = heightSurroundReliefSymbolizer.getFlattenNoise();
        int flattenPointNoise = heightSurroundReliefSymbolizer.getFlattenPointNoise();
        int expensiveBlur = heightSurroundReliefSymbolizer.getExpensiveBlur();
        double heightMin = heightSurroundReliefSymbolizer.getHeightMin();
        double heightMax = heightSurroundReliefSymbolizer.getHeightMax();
        ArrayList<Float> skipHeights = this.parseSkipHeights(heightSurroundReliefSymbolizer.getSkipHeights());
        double sunrayDirectionClockwise = heightSurroundReliefSymbolizer.getSunrayDirectionClockwise();
        double shadowCircumfence = heightSurroundReliefSymbolizer.getShadowCircumfence();
        double shadowCircumfenceWeight = heightSurroundReliefSymbolizer.getShadowCircumfenceWeight();
        double shadowIntensity = heightSurroundReliefSymbolizer.getShadowIntensity();
        Optional<Double> forcedAggregationRadius = heightSurroundReliefSymbolizer.getForcedAggregationRadius();
        HeightTileAccessor heightTileAccessor = renderRequest.getHeightTileAccessor();
        HeightCollectorTile heightCollectorTile = heightTileAccessor.collectValues((int)zoom, xTileIndex = (int)renderRequest.getTileIndex().getX(), yTileIndex = (int)renderRequest.getTileIndex().getY(), latLonBoundingBox = renderRequest.getBoundingBoxLatLon(), renderRequest, tileOutputter.getTileSize(), renderMockTiles, flattenNoise, flattenPointNoise, tileOutputter);
        if (heightCollectorTile == null) {
            this.log.error("renderHeight: could not render shadow because the srtmCollectorTile was null");
            return;
        }
        if (expensiveBlur > 0) {
            heightCollectorTile.blur(expensiveBlur);
        }
        RenderImageLayer reliefLayer = renderRequest.getRenderImage().createLayer("relief", tileOutputter.getTileSize());
        BufferedImage topImage = reliefLayer.getImage();
        WritableRaster topRaster = topImage.getRaster();
        double yLonStepSize = heightCollectorTile.getLatLonBBox().getHeight() / (double)heightCollectorTile.getPixelTileSize();
        double biggestSubTileSize = Math.max(heightCollectorTile.getSubTileSizeX(), heightCollectorTile.getSubTileSizeY());
        double subTileRadius = Math.max(1.0, biggestSubTileSize + 1.0);
        if (forcedAggregationRadius.isPresent()) {
            subTileRadius = forcedAggregationRadius.get();
        }
        for (int y = 0; y < heightCollectorTile.getPixelTileSize(); ++y) {
            double currentYLon = renderRequest.getBoundingBoxLatLon().getTop() - (double)y * yLonStepSize;
            float meterPerPixel = (float)tileOutputter.getMeterPerPixel(zoom, currentYLon);
            for (int x = 0; x < heightCollectorTile.getPixelTileSize(); ++x) {
                float height = heightCollectorTile.getValue(x, y);
                if ((double)height < heightMin || (double)height > heightMax) {
                    topRaster.setPixel(x, y, COLOR_TRANSPARENT);
                    continue;
                }
                double steps = shadowCircumfence / 10.0;
                double stepDegreeWidth = shadowCircumfence / steps;
                double startDegree = sunrayDirectionClockwise - shadowCircumfence / 2.0;
                double stopDegree = sunrayDirectionClockwise + shadowCircumfence / 2.0;
                double heightDiff = 0.0;
                for (double stepDegree = startDegree; stepDegree <= stopDegree; stepDegree += stepDegreeWidth) {
                    if (subTileRadius >= 50.0) continue;
                    double stepHeightDiff = this.getHeightDiffForDegreeClockwise(stepDegree, x, y, subTileRadius, heightCollectorTile);
                    double baseWeight = 1.0 - Math.abs(sunrayDirectionClockwise - stepDegree) / (shadowCircumfence / 2.0);
                    double weightScaling = shadowCircumfenceWeight * (Math.abs(sunrayDirectionClockwise - stepDegree) / (shadowCircumfence / 2.0));
                    double totalWeight = baseWeight + weightScaling;
                    double weightedHeightDiff = totalWeight * stepHeightDiff;
                    heightDiff = Math.min(heightDiff, weightedHeightDiff);
                }
                heightDiff = Math.abs(heightDiff);
                double weightedHeightDiff = heightDiff * shadowIntensity;
                float[] topRgba = new float[4];
                topRgba = topRaster.getPixel(x, y, topRgba);
                topRgba[0] = color.getRed();
                topRgba[1] = color.getGreen();
                topRgba[2] = color.getBlue();
                float slopeDegree = (float)Math.toDegrees(Math.atan(weightedHeightDiff / (double)meterPerPixel));
                float slope0to255 = 256.0f * slopeDegree / 90.0f;
                boolean skipHeightRendering = false;
                for (int i = 0; i < skipHeights.size(); ++i) {
                    if (skipHeights.get(i).floatValue() != height || slopeDegree != 0.0f) continue;
                    skipHeightRendering = true;
                    break;
                }
                if (skipHeightRendering) {
                    topRaster.setPixel(x, y, COLOR_TRANSPARENT);
                    continue;
                }
                topRgba[3] = slope0to255;
                topRaster.setPixel(x, y, topRgba);
            }
        }
        renderRequest.getRenderImage().mergeBackLayer(reliefLayer);
    }

    public double getHeightDiffForDegreeClockwise(double degreeClockwise, int x, int y, double radius, HeightCollectorTile heightCollectorTile) {
        Point startPoint = new Point(x, y);
        double startPointHeight = heightCollectorTile.getValue((int)startPoint.getX(), (int)startPoint.getY());
        Line line = new Line(startPoint, degreeClockwise, (int)radius + 1);
        Point nextPoint = new Point();
        double heightDiffTotal = 0.0;
        double additionsCounter = 0.0;
        int i = 1;
        while ((double)i <= radius) {
            nextPoint = line.getPointAfterLength(startPoint, radius, Line.Direction.FORWARD);
            double xNext = nextPoint.getX();
            double yNext = nextPoint.getY();
            double xFloor = xNext;
            xFloor = xNext < 0.0 ? Math.ceil(xNext) : Math.floor(xNext);
            double yFloor = yNext;
            yFloor = yNext < 0.0 ? Math.ceil(yNext) : Math.floor(yNext);
            double xPart = xNext - xFloor;
            double yPart = yNext - yFloor;
            double xFloorAround = xFloor;
            xFloorAround = xPart > 0.0 ? xFloor + 1.0 : xFloor - 1.0;
            double yFloorAround = yFloor;
            yFloorAround = yPart > 0.0 ? yFloor + 1.0 : yFloor - 1.0;
            double weightOne = (1.0 - Math.abs(xPart)) * (1.0 - Math.abs(yPart));
            double weightTwo = (1.0 - Math.abs(xPart)) * Math.abs(yPart);
            double weightThree = Math.abs(xPart) * (1.0 - Math.abs(yPart));
            double weightFour = Math.abs(xPart) * Math.abs(yPart);
            double heightOne = (double)heightCollectorTile.getValue((int)xFloor, (int)yFloor) * weightOne;
            double heightTwo = (double)heightCollectorTile.getValue((int)xFloor, (int)yFloorAround) * weightTwo;
            double heightThree = (double)heightCollectorTile.getValue((int)xFloorAround, (int)yFloor) * weightThree;
            double heightFour = (double)heightCollectorTile.getValue((int)xFloorAround, (int)yFloorAround) * weightFour;
            double averagedHeightDiff = heightOne + heightTwo + heightThree + heightFour;
            heightDiffTotal += averagedHeightDiff - startPointHeight;
            additionsCounter += 1.0;
            ++i;
        }
        double heightDiffAveraged = heightDiffTotal / additionsCounter;
        return heightDiffAveraged;
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, SrtmLineHeightContainer linesContainer) {
        ArrayList<LineSequence> lines = linesContainer.getHeightLines();
        ArrayList<Point> linePoints = new ArrayList<Point>();
        for (LineSequence line : lines) {
            Point[] points = line.getPoints();
            linePoints.addAll(Arrays.stream(points).collect(Collectors.toList()));
        }
        this.printPointArray(xMin, xMax, yMin, yMax, linePoints);
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, ArrayList<Point> points) {
        System.out.println("################################################# logPoints ");
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                Point currentPoint = null;
                for (int i = 0; i < points.size(); ++i) {
                    if (points.get(i).getX() != (double)x || points.get(i).getY() != (double)y) continue;
                    currentPoint = points.get(i);
                    break;
                }
                String value = "-";
                if (currentPoint != null) {
                    value = "start".equals(currentPoint.getOptionalFlag()) ? "0" : ("stop".equals(currentPoint.getOptionalFlag()) ? "1" : "#");
                }
                String lengthFilledValue = String.format("%1$1s", value);
                rowBuffy.append(lengthFilledValue);
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, ArrayList<Point> points, ArrayList<Integer> analysis) {
        System.out.println("################################################# logPoints ");
        int SAME_X = 1;
        int SAME_Y = 2;
        int BACKWARD = 3;
        int FORWARD = 4;
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                Point currentPoint = null;
                Integer currentAnalysis = null;
                for (int i = 0; i < points.size(); ++i) {
                    if (points.get(i).getX() != (double)x || points.get(i).getY() != (double)y) continue;
                    currentPoint = points.get(i);
                    currentAnalysis = analysis.get(i);
                    break;
                }
                String value = "-";
                if (currentPoint != null) {
                    if (currentAnalysis == SAME_X) {
                        value = "X";
                    } else if (currentAnalysis == SAME_Y) {
                        value = "Y";
                    } else if (currentAnalysis == BACKWARD) {
                        value = "<";
                    } else if (currentAnalysis == FORWARD) {
                        value = ">";
                    }
                }
                String lengthFilledValue = String.format("%1$1s", value);
                rowBuffy.append(lengthFilledValue);
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }
}

