/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.metrics;

import de.wideportal.maprender.metrics.PerformanceMetrics;
import java.util.LinkedHashMap;

public class StopWatch {
    private long timestampStart;
    private long timestampStop;
    private static LinkedHashMap<String, AverageMetric> metrics = new LinkedHashMap();

    private StopWatch(long timestamp) {
        this.timestampStart = timestamp;
    }

    public static StopWatch start(boolean activate) {
        if (!activate) {
            return new StopWatch(0L);
        }
        return new StopWatch(System.nanoTime());
    }

    public long stop(boolean activate) {
        if (!activate) {
            this.timestampStop = 0L;
            return 0L;
        }
        this.timestampStop = System.nanoTime();
        return this.timestampStop - this.timestampStart;
    }

    public long stop(String metricName, boolean activate) {
        if (!activate) {
            this.timestampStop = 0L;
            return 0L;
        }
        this.timestampStop = System.nanoTime();
        long duration = this.timestampStop - this.timestampStart;
        AverageMetric metric = this.getMetric(metricName);
        ++metric.counts;
        metric.totalDuration = (int)((long)metric.totalDuration + duration);
        return duration;
    }

    public AverageMetric getMetric(String metricName) {
        AverageMetric metric = metrics.get(metricName);
        if (metric == null) {
            metric = new AverageMetric(this);
            metrics.put(metricName, metric);
        }
        return metric;
    }

    public static LinkedHashMap<String, AverageMetric> getMetrics() {
        return metrics;
    }

    public long getDurationInNanos() {
        return this.timestampStop - this.timestampStart;
    }

    public String toString() {
        return "StopWatch[" + PerformanceMetrics.formatDuration(this.getDurationInNanos()) + ", " + this.getDurationInNanos() + "]";
    }

    public class AverageMetric {
        public int counts = 0;
        public int totalDuration = 0;

        public AverageMetric(StopWatch this$0) {
        }

        public long getAverageDuration() {
            return this.totalDuration / this.counts;
        }

        public String getTotalDurationFormatted() {
            return String.format("%dm %ds %dms %dns", (long)this.totalDuration / 60000000000L % 60L, (long)this.totalDuration / 1000000000L % 60L, (long)this.totalDuration % 1000000000L, (long)this.totalDuration % 1000000L);
        }

        public String getAverageDurationFormatted() {
            long averageDuration = this.getAverageDuration();
            return String.format("%dm %ds %dms %dns", averageDuration / 60000000000L % 60L, averageDuration / 1000000000L % 60L, averageDuration % 1000000000L, averageDuration % 1000000L);
        }
    }
}

