/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.metrics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricEntry {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private long totalDuration = 0L;
    private long callCount = 0L;

    public MetricEntry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public void setTotalDuration(long totalDuration) {
        this.totalDuration = totalDuration;
    }

    public long getCallCount() {
        return this.callCount;
    }

    public void setCallCount(long callCount) {
        this.callCount = callCount;
    }

    public void addMeasure(long duration) {
        this.totalDuration += duration;
        ++this.callCount;
    }

    public void add(MetricEntry other) {
        if (!this.name.equals(other.name)) {
            this.log.error("add: trying to merge metrics with different names: " + this.name + " != " + other.name);
            return;
        }
        this.totalDuration += other.totalDuration;
        this.callCount += other.callCount;
    }

    public double getAverageDuration() {
        if (this.callCount == 0L) {
            return 0.0;
        }
        return (double)this.totalDuration / (double)this.callCount;
    }

    public String toString() {
        return "MetricEntry[name=" + this.name + ", totalDuration=" + this.totalDuration + ", callCount=" + this.callCount + "]";
    }
}

