/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.math;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.srtm.SrtmLineHeightContainer;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplyfierDouglasPeucker {
    protected static Logger log = LoggerFactory.getLogger(SimplyfierDouglasPeucker.class);

    public static void simplifyAndApply(SrtmLineHeightContainer heightLineContainer, double simplifyDistanceTolerance) {
        try {
            for (LineSequence lineSequence : heightLineContainer.getHeightLines()) {
                ArrayList<Line> lines = lineSequence.getLines();
                LineString result = SimplyfierDouglasPeucker.simplify(lines, simplifyDistanceTolerance);
                ArrayList<Line> newLines = new ArrayList<Line>();
                for (int i = 0; i < result.getCoordinates().length - 1; ++i) {
                    Coordinate coordStart = result.getCoordinates()[i];
                    Coordinate coordStop = result.getCoordinates()[i + 1];
                    Line newLine = new Line(new Point(coordStart.x, coordStart.y), new Point(coordStop.x, coordStop.y));
                    newLines.add(newLine);
                }
                lineSequence.getLines().clear();
                lineSequence.getLines().addAll(newLines);
            }
        }
        catch (Exception e) {
            log.error("loess(): error while calculating loess spline", (Throwable)e);
        }
    }

    public static LineString simplify(ArrayList<Line> lines, double simplifyDistanceTolerance) {
        double[] xValues = SimplyfierDouglasPeucker.extractXValues(lines, 0, lines.size(), 1);
        double[] yValues = SimplyfierDouglasPeucker.extractYValues(lines, 0, lines.size(), 1);
        Coordinate[] coords = new Coordinate[xValues.length];
        for (int i = 0; i < xValues.length; ++i) {
            coords[i] = new Coordinate(xValues[i], yValues[i]);
        }
        CoordinateArraySequence cas = new CoordinateArraySequence(coords);
        LineString lineString = new LineString((CoordinateSequence)cas, new GeometryFactory());
        DouglasPeuckerSimplifier dpls = new DouglasPeuckerSimplifier((Geometry)lineString);
        dpls.setDistanceTolerance(simplifyDistanceTolerance);
        return (LineString)dpls.getResultGeometry();
    }

    private static double[] extractXValues(ArrayList<Line> lines, int startIndex, int stopIndex, int extractionDensity) {
        ArrayList<Double> resultList = new ArrayList<Double>();
        resultList.add(lines.get(startIndex).getStart().getX());
        for (int i = startIndex; i < stopIndex; ++i) {
            resultList.add(lines.get(i).getStop().getX());
        }
        return ArrayUtils.toPrimitive((Double[])resultList.toArray(new Double[0]));
    }

    private static double[] extractYValues(ArrayList<Line> lines, int startIndex, int stopIndex, int extractionDensity) {
        ArrayList<Double> resultList = new ArrayList<Double>();
        resultList.add(lines.get(startIndex).getStart().getY());
        for (int i = startIndex; i < stopIndex; ++i) {
            resultList.add(lines.get(i).getStop().getY());
        }
        return ArrayUtils.toPrimitive((Double[])resultList.toArray(new Double[0]));
    }
}

