/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.math;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.SimplyfierDouglasPeucker;
import de.wideportal.maprender.math.SplineCatmullRom;
import de.wideportal.maprender.resources.srtm.SrtmLineHeightContainer;
import de.wideportal.maprender.resources.srtm.algos.PointGroupAlgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineSmoother {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void simplifyDouglasPeuckerThenSplineCatmullRom(SrtmLineHeightContainer heightLineContainer, double simplifyDistanceTolerance, int splinePointsPerSegment, long tileSize) {
        try {
            for (LineSequence lineSequence : heightLineContainer.getHeightLines()) {
                ArrayList<Line> lines = lineSequence.getLines();
                double adjustedSimplifyDistanceTolerance = simplifyDistanceTolerance;
                if (lineSequence.isCyclic() && lines.size() < 40) {
                    adjustedSimplifyDistanceTolerance = 1.0;
                }
                ArrayList<ArrayList<Line>> subLineList = this.splitLinesOnBorder(lines, tileSize);
                ArrayList<Line> newLines = new ArrayList<Line>();
                for (ArrayList<Line> subLines : subLineList) {
                    LineString simplifiedLine = SimplyfierDouglasPeucker.simplify(subLines, adjustedSimplifyDistanceTolerance);
                    ArrayList<Coordinate> raw = new ArrayList<Coordinate>();
                    raw.addAll(Arrays.asList(simplifiedLine.getCoordinates()));
                    List<Coordinate> spline = SplineCatmullRom.interpolate(raw, splinePointsPerSegment);
                    for (int i = 0; i < spline.size() - 1; ++i) {
                        Coordinate coordStart = spline.get(i);
                        Coordinate coordStop = spline.get(i + 1);
                        Line newLine = new Line(new Point(coordStart.x, coordStart.y), new Point(coordStop.x, coordStop.y));
                        newLines.add(newLine);
                    }
                }
                lineSequence.getLines().clear();
                lineSequence.getLines().addAll(newLines);
            }
        }
        catch (Exception e) {
            this.log.error("loess(): error while calculating loess spline", (Throwable)e);
        }
    }

    private ArrayList<ArrayList<Line>> splitLinesOnBorder(ArrayList<Line> lines, long tileSize) {
        int nextIndex;
        ArrayList<ArrayList<Line>> result = new ArrayList<ArrayList<Line>>();
        int startIndex = 0;
        do {
            nextIndex = this.getNextBorderEntryOrLeaveIndex(lines, tileSize, startIndex);
            result.add(new ArrayList<Line>(lines.subList(startIndex, nextIndex)));
        } while ((startIndex = nextIndex) < lines.size());
        return result;
    }

    private int getNextBorderEntryOrLeaveIndex(ArrayList<Line> lines, long tileSize, int startIndex) {
        boolean lineStartsOnBorder = PointGroupAlgo.isOnTileBorder(lines.get(startIndex).getStop(), tileSize);
        for (int i = startIndex; i < lines.size(); ++i) {
            Line line = lines.get(i);
            if (i == lines.size() - 1) {
                return lines.size();
            }
            if (!(lineStartsOnBorder ? !PointGroupAlgo.isOnTileBorder(line.getStop(), tileSize) : PointGroupAlgo.isOnTileBorder(line.getStop(), tileSize))) continue;
            return i;
        }
        return startIndex;
    }
}

