/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.geom;

public class Point {
    public double x;
    public double y;
    public String optionalFlag = null;

    public Point() {
    }

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getDistance(Point other) {
        return Math.sqrt(Math.pow(this.getX() - other.getX(), 2.0) + Math.pow(this.getY() - other.getY(), 2.0));
    }

    public boolean hasCoordinates(double x, double y) {
        return this.x == x && this.y == y;
    }

    public boolean equals(Object object) {
        if (object instanceof Point) {
            Point other = (Point)object;
            if (this.x == other.x && this.y == other.y) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Point[x=" + this.x + ", y=" + this.y + "]";
    }

    public String getOptionalFlag() {
        return this.optionalFlag;
    }

    public void setOptionalFlag(String optionalFlag) {
        this.optionalFlag = optionalFlag;
    }

    public Point clone() {
        return new Point(this.x, this.y);
    }

    public boolean isInTile(long tileSize) {
        return this.x > 0.0 && this.x < (double)tileSize && this.y > 0.0 && this.y < (double)tileSize;
    }
}

