/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.geom;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import java.util.ArrayList;

public class Line {
    public Point start;
    public Point stop;
    public long optionalLineIndex = -1L;

    public Line() {
    }

    public Line(Point start, Point stop) {
        this.start = start;
        this.stop = stop;
    }

    public Line(Point start, Point stop, long optionalLineIndex) {
        this.start = start;
        this.stop = stop;
        this.optionalLineIndex = optionalLineIndex;
    }

    public Line(Point start, double degreeClockwise, int distance) {
        double x = start.getX();
        double y = start.getY();
        this.start = start;
        this.stop = new Point();
        if (degreeClockwise >= 360.0 || degreeClockwise <= -360.0) {
            degreeClockwise %= 360.0;
        }
        if (degreeClockwise < 0.0) {
            degreeClockwise = 360.0 + degreeClockwise;
        }
        if (degreeClockwise == 0.0) {
            this.stop = new Point(x, y - (double)distance);
        } else if (degreeClockwise == 90.0) {
            this.stop = new Point(x + (double)distance, y);
        } else if (degreeClockwise == 180.0) {
            this.stop = new Point(x, y + (double)distance);
        } else if (degreeClockwise == 270.0) {
            this.stop = new Point(x - (double)distance, y);
        } else if (degreeClockwise > 0.0 && degreeClockwise < 90.0) {
            double radians = Math.toRadians(degreeClockwise - 0.0);
            double xDiff = (double)distance * Math.sin(radians);
            double yDiff = (double)distance * Math.cos(radians);
            this.stop = new Point(x + xDiff, y - yDiff);
        } else if (degreeClockwise > 90.0 && degreeClockwise < 180.0) {
            double radians = Math.toRadians(degreeClockwise - 90.0);
            double xDiff = (double)distance * Math.cos(radians);
            double yDiff = (double)distance * Math.sin(radians);
            this.stop = new Point(x + xDiff, y + yDiff);
        } else if (degreeClockwise > 180.0 && degreeClockwise < 270.0) {
            double radians = Math.toRadians(degreeClockwise - 180.0);
            double xDiff = (double)distance * Math.sin(radians);
            double yDiff = (double)distance * Math.cos(radians);
            this.stop = new Point(x - xDiff, y + yDiff);
        } else if (degreeClockwise > 270.0 && degreeClockwise < 360.0) {
            double radians = Math.toRadians(degreeClockwise - 270.0);
            double xDiff = (double)distance * Math.cos(radians);
            double yDiff = (double)distance * Math.sin(radians);
            this.stop = new Point(x - xDiff, y - yDiff);
        }
    }

    public Point getStart() {
        return this.start;
    }

    public void setStart(Point start) {
        this.start = start;
    }

    public Point getStop() {
        return this.stop;
    }

    public void setStop(Point stop) {
        this.stop = stop;
    }

    public long getOptionalLineIndex() {
        return this.optionalLineIndex;
    }

    public void setOptionalLineIndex(long optionalLineIndex) {
        this.optionalLineIndex = optionalLineIndex;
    }

    public double getDistance(Point start, Point stop) {
        return start.getDistance(stop);
    }

    public double getLength() {
        return this.getDistance(this.start, this.stop);
    }

    public Line getInverse() {
        return new Line(this.stop, this.start);
    }

    public Point getCenter() {
        return new Point((this.start.getX() + this.stop.getX()) / 2.0, (this.start.getY() + this.stop.getY()) / 2.0);
    }

    public Point getPointAfterLength(Point startPoint, double length, Direction direction) {
        if (!this.isNextPointOnLine(startPoint, length)) {
            return null;
        }
        Point targetPoint = this.stop;
        double lengthSquare = Math.pow(length, 2.0);
        double xLengthSquare = Math.pow(targetPoint.getX() - startPoint.getX(), 2.0);
        double yLengthSquare = Math.pow(targetPoint.getY() - startPoint.getY(), 2.0);
        if (xLengthSquare == 0.0 && yLengthSquare == 0.0) {
            return targetPoint.clone();
        }
        double lengthMultiplicator = Math.sqrt(lengthSquare / (xLengthSquare + yLengthSquare));
        double xNew = startPoint.getX() + lengthMultiplicator * (targetPoint.getX() - startPoint.getX());
        double yNew = startPoint.getY() + lengthMultiplicator * (targetPoint.getY() - startPoint.getY());
        return new Point(xNew, yNew);
    }

    public boolean isNextPointOnLine(Point startPoint, double length) {
        double distance = this.getDistance(startPoint, this.stop);
        return distance >= length;
    }

    public static ArrayList<Line> invertLines(ArrayList<Line> lines) {
        ArrayList<Line> newLines = new ArrayList<Line>();
        for (int i = lines.size() - 1; i >= 0; --i) {
            newLines.add(new Line(lines.get(i).getStop(), lines.get(i).getStart(), lines.get(i).getOptionalLineIndex()));
        }
        return newLines;
    }

    private boolean isBetween(double value, double start, double stop) {
        if (start == stop) {
            return value == start;
        }
        if (start < stop) {
            return value >= start && value <= stop;
        }
        return value >= stop && value <= start;
    }

    public Point getIntersectionBetweenStartStop(Line other) {
        Point intersection = this.getIntersection(other);
        if (intersection != null) {
            if (this.isBetween(intersection.x, this.start.x, this.stop.x) && this.isBetween(intersection.y, this.start.y, this.stop.y) && this.isBetween(intersection.x, other.start.x, other.stop.x) && this.isBetween(intersection.y, other.start.y, other.stop.y)) {
                return intersection;
            }
            return null;
        }
        return null;
    }

    public Point getIntersection(Line other) {
        double p0_x = this.start.x;
        double p0_y = this.start.y;
        double p1_x = this.stop.x;
        double p1_y = this.stop.y;
        double p2_x = other.start.x;
        double p2_y = other.start.y;
        double p3_x = other.stop.x;
        double p3_y = other.stop.y;
        double thisM = 0.0;
        double otherM = 0.0;
        double thisA = 0.0;
        double otherA = 0.0;
        if (this.start.equals(other.start)) {
            return this.start.clone();
        }
        if (this.start.equals(other.stop)) {
            return this.start.clone();
        }
        if (this.stop.equals(other.start)) {
            return this.stop.clone();
        }
        if (this.stop.equals(other.stop)) {
            return this.stop.clone();
        }
        if (p0_x == p1_x && p2_x == p3_x) {
            if (p0_x == p2_x) {
                return this.stop.clone();
            }
            return null;
        }
        if (p0_y == p1_y && p2_y == p3_y) {
            if (p0_y == p2_y) {
                return this.stop.clone();
            }
            return null;
        }
        if (p0_x == p1_x) {
            otherM = (p3_y - p2_y) / (p3_x - p2_x);
            otherA = p2_y - otherM * p2_x;
            double xNew = p0_x;
            double yNew = otherM * xNew + otherA;
            return new Point(xNew, yNew);
        }
        if (p2_x == p3_x) {
            thisM = (p1_y - p0_y) / (p1_x - p0_x);
            thisA = p0_y - thisM * p0_x;
            double xNew = p2_x;
            double yNew = thisM * xNew + thisA;
            return new Point(xNew, yNew);
        }
        if (p0_y == p1_y) {
            otherM = (p3_y - p2_y) / (p3_x - p2_x);
            otherA = p2_y - otherM * p2_x;
            double yNew = p0_y;
            double xNew = (yNew - otherA) / otherM;
            return new Point(xNew, yNew);
        }
        if (p2_y == p3_y) {
            thisM = (p1_y - p0_y) / (p1_x - p0_x);
            thisA = p1_y - thisM * p1_x;
            double yNew = p0_y;
            double xNew = (yNew - thisA) / thisM;
            return new Point(xNew, yNew);
        }
        thisM = (p1_y - p0_y) / (p1_x - p0_x);
        otherM = (p3_y - p2_y) / (p3_x - p2_x);
        thisA = p0_y - thisM * p0_x;
        otherA = p2_y - otherM * p2_x;
        if (thisM == otherM && thisA == otherA) {
            return this.stop.clone();
        }
        if (thisM == otherM) {
            return null;
        }
        double xIntersect = -(thisA - otherA) / (thisM - otherM);
        double yIntersect = thisM * xIntersect + thisA;
        return new Point(xIntersect, yIntersect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Point getOrthogonalPoint(Point startOrStop, boolean leftOrRight, double distance) {
        double p0_x = this.start.x;
        double p0_y = this.start.y;
        double p1_x = this.stop.x;
        double p1_y = this.stop.y;
        double x_new = startOrStop.getX();
        double y_new = startOrStop.getY();
        if (p0_x == p1_x) {
            if (p0_y < p1_y) {
                x_new += leftOrRight ? distance : -distance;
                return new Point(x_new, y_new);
            } else {
                if (!(p0_y > p1_y)) return null;
                x_new += leftOrRight ? -distance : distance;
            }
            return new Point(x_new, y_new);
        } else if (p0_y == p1_y) {
            if (p0_x < p1_x) {
                y_new += leftOrRight ? -distance : distance;
                return new Point(x_new, y_new);
            } else {
                if (!(p0_x > p1_x)) return null;
                y_new += leftOrRight ? distance : -distance;
            }
            return new Point(x_new, y_new);
        } else {
            double m = (p1_y - p0_y) / (p1_x - p0_x);
            double m_ortho = -1.0 / m;
            double x_multiplicator = 1.0;
            double y_multiplicator = 1.0;
            if (p0_x < p1_x) {
                if (p0_y < p1_y) {
                    x_multiplicator = 1.0;
                    y_multiplicator = 1.0;
                } else {
                    x_multiplicator = -1.0;
                    y_multiplicator = -1.0;
                }
            } else if (p0_y < p1_y) {
                x_multiplicator = 1.0;
                y_multiplicator = 1.0;
            } else {
                x_multiplicator = -1.0;
                y_multiplicator = -1.0;
            }
            if (!leftOrRight) {
                x_multiplicator *= -1.0;
                y_multiplicator *= -1.0;
            }
            x_new += x_multiplicator * (distance * Math.sqrt(1.0 / (1.0 + Math.pow(m_ortho, 2.0))));
            y_new += y_multiplicator * (distance * m_ortho * Math.sqrt(1.0 / (1.0 + Math.pow(m_ortho, 2.0))));
        }
        return new Point(x_new, y_new);
    }

    public Point getOrthogonalCrossingPoint(Point externalPoint) {
        double p0_x = this.start.x;
        double p0_y = this.start.y;
        double p1_x = this.stop.x;
        double p1_y = this.stop.y;
        double p2_x = externalPoint.getX();
        double p2_y = externalPoint.getY();
        if (p0_x == p1_x) {
            return new Point(p0_x, p2_y);
        }
        if (p0_y == p1_y) {
            return new Point(p2_x, p0_y);
        }
        double m = (p1_y - p0_y) / (p1_x - p0_x);
        double b = p0_y - m * p0_x;
        double m_ortho = -1.0 / m;
        double b_ortho = p2_y - m_ortho * p2_x;
        double p3_x = (b_ortho - b) / (m - m_ortho);
        double p3_y = m * p3_x + b;
        return new Point(p3_x, p3_y);
    }

    public boolean crossesBoundingBox(BoundingBox bbox) {
        if (this.start.x >= bbox.left && this.start.x <= bbox.right && this.start.y <= bbox.top && this.start.y >= bbox.bottom) {
            return true;
        }
        if (this.stop.x >= bbox.left && this.stop.x <= bbox.right && this.stop.y <= bbox.top && this.stop.y >= bbox.bottom) {
            return true;
        }
        Line bbLeft = new Line(bbox.getLeftTop(), bbox.getLeftBottom());
        if (this.getIntersection(bbLeft) != null) {
            return true;
        }
        Line bbRight = new Line(bbox.getRightTop(), bbox.getRightBottom());
        if (this.getIntersection(bbRight) != null) {
            return true;
        }
        Line bbTop = new Line(bbox.getLeftTop(), bbox.getRightTop());
        if (this.getIntersection(bbTop) != null) {
            return true;
        }
        Line bbBottom = new Line(bbox.getLeftBottom(), bbox.getRightBottom());
        return this.getIntersection(bbBottom) != null;
    }

    public Line getParallelLine(double distance, boolean leftOrRight) {
        Point newStart = this.getOrthogonalPoint(this.start, leftOrRight, distance);
        Point newStop = this.getOrthogonalPoint(this.stop, leftOrRight, distance);
        if (newStart == null || newStop == null) {
            return null;
        }
        return new Line(newStart, newStop);
    }

    public boolean notFullyInBoundingBox(BoundingBox bbox) {
        return !bbox.contains(this.start) || !bbox.contains(this.stop);
    }

    public Line merge(Line other) {
        if (this.start.equals(other.start)) {
            return new Line(this.stop, other.stop);
        }
        if (this.start.equals(other.stop)) {
            return new Line(this.stop, other.start);
        }
        if (this.stop.equals(other.start)) {
            return new Line(this.start, other.stop);
        }
        if (this.stop.equals(other.stop)) {
            return new Line(this.start, other.start);
        }
        return this;
    }

    public ArrayList<Point> split(int segments) {
        ArrayList<Point> resultingPoints = new ArrayList<Point>();
        double xStep = (this.stop.getX() - this.start.getX()) / (double)segments;
        double yStep = (this.stop.getY() - this.start.getY()) / (double)segments;
        resultingPoints.add(this.start);
        for (double i = 1.0; i < (double)segments; i += 1.0) {
            double newX = this.start.getX() + i * xStep;
            double newY = this.start.getY() + i * yStep;
            resultingPoints.add(new Point(newX, newY));
        }
        resultingPoints.add(this.stop);
        return resultingPoints;
    }

    public String toString() {
        return "Line[start=" + this.start + ", stop=" + this.stop + ", optionalLineIndex=" + this.optionalLineIndex + "]";
    }

    public Line clone() {
        return new Line(this.start, this.stop, this.optionalLineIndex);
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

