/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.geom;

import de.wideportal.maprender.geom.Circle;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = 1202538245530779946L;
    public double top;
    public double bottom;
    public double right;
    public double left;

    public BoundingBox(String leftTopRightBottomCommaSeparated) {
        String[] leftTopRightBottom = leftTopRightBottomCommaSeparated.split(",");
        this.left = Double.parseDouble(leftTopRightBottom[0]);
        this.top = Double.parseDouble(leftTopRightBottom[1]);
        this.right = Double.parseDouble(leftTopRightBottom[2]);
        this.bottom = Double.parseDouble(leftTopRightBottom[3]);
        if (this.bottom > this.top) {
            double newBottom = this.top;
            this.top = this.bottom;
            this.bottom = newBottom;
        }
    }

    public BoundingBox(double left, double bottom, double right, double top) {
        this.top = top;
        this.bottom = bottom;
        this.right = right;
        this.left = left;
    }

    public BoundingBox(Point topLeft, Point bottomRight) {
        this.top = topLeft.y;
        this.right = bottomRight.x;
        this.bottom = bottomRight.y;
        this.left = topLeft.x;
    }

    public BoundingBox(Point topLeft, double width, double height) {
        this.top = topLeft.y;
        this.right = topLeft.x + width;
        this.bottom = topLeft.y + height;
        this.left = topLeft.x;
    }

    public BoundingBox(List<Point> points, boolean topIsMinY) {
        for (int i = 0; i < points.size(); ++i) {
            Point point = points.get(i);
            if (i == 0) {
                this.left = point.x;
                this.right = point.x;
                this.top = point.y;
                this.bottom = point.y;
                continue;
            }
            if (point.x < this.left) {
                this.left = point.x;
            } else if (point.x > this.right) {
                this.right = point.x;
            }
            if (topIsMinY) {
                if (point.y < this.top) {
                    this.top = point.y;
                    continue;
                }
                if (!(point.y > this.bottom)) continue;
                this.bottom = point.y;
                continue;
            }
            if (point.y > this.top) {
                this.top = point.y;
                continue;
            }
            if (!(point.y < this.bottom)) continue;
            this.bottom = point.y;
        }
    }

    public BoundingBox(Point[] points, boolean topIsMinY) {
        for (int i = 0; i < points.length; ++i) {
            Point point = points[i];
            if (i == 0) {
                this.left = point.x;
                this.right = point.x;
                this.top = point.y;
                this.bottom = point.y;
                continue;
            }
            if (point.x < this.left) {
                this.left = point.x;
            } else if (point.x > this.right) {
                this.right = point.x;
            }
            if (topIsMinY) {
                if (point.y < this.top) {
                    this.top = point.y;
                    continue;
                }
                if (!(point.y > this.bottom)) continue;
                this.bottom = point.y;
                continue;
            }
            if (point.y > this.top) {
                this.top = point.y;
                continue;
            }
            if (!(point.y < this.bottom)) continue;
            this.bottom = point.y;
        }
    }

    public BoundingBox(Rectangle rectangle, boolean topIsMinY) {
        if (topIsMinY) {
            this.top = rectangle.getMinY();
            this.bottom = rectangle.getMaxY();
        } else {
            this.top = rectangle.getMaxY();
            this.bottom = rectangle.getMinY();
        }
        this.right = rectangle.getMaxX();
        this.left = rectangle.getMinX();
    }

    public void increaseBBox(double additionalSize) {
        this.increaseBBox(additionalSize, additionalSize);
    }

    public void increaseBBox(double additionalWidth, double additionalHeight) {
        this.left -= additionalWidth;
        this.right += additionalWidth;
        if (this.top < this.bottom) {
            this.top -= additionalHeight;
            this.bottom += additionalHeight;
        } else {
            this.top += additionalHeight;
            this.bottom -= additionalHeight;
        }
    }

    public BoundingBox fitWidthToRatio(Point xyRatioValues) {
        double xyRation = xyRatioValues.getX() / xyRatioValues.getY();
        double newWidth = this.getHeight() * xyRation;
        Point center = this.getCenter();
        this.left = center.getX() - newWidth / 2.0;
        this.right = center.getX() + newWidth / 2.0;
        return this;
    }

    public BoundingBox centerTo(Point newCenter) {
        Point currentCenter = this.getCenter();
        double xDiff = newCenter.getX() - currentCenter.getX();
        double yDiff = newCenter.getY() - currentCenter.getY();
        this.left += xDiff;
        this.right += xDiff;
        this.top += yDiff;
        this.bottom += yDiff;
        return this;
    }

    public BoundingBox decreaseBBox(double minusSize) {
        return this.decreaseBBox(minusSize, minusSize);
    }

    public BoundingBox decreaseBBox(double minusWidth, double minusHeight) {
        this.left += minusWidth;
        this.right -= minusWidth;
        if (this.top < this.bottom) {
            this.top += minusHeight;
            this.bottom -= minusHeight;
        } else {
            this.top -= minusHeight;
            this.bottom += minusHeight;
        }
        return this;
    }

    public double getRadius() {
        return Math.sqrt(Math.pow(this.getWidth() / 2.0, 2.0) + Math.pow(this.getHeight() / 2.0, 2.0));
    }

    public boolean intersects(BoundingBox other) {
        boolean inX = false;
        if (other.left < this.right && other.left > this.left || other.right > this.left && other.right < this.right || other.left <= this.left && other.right >= this.right) {
            inX = true;
        }
        boolean inY = false;
        if (other.top < this.bottom && other.top > this.top || other.bottom > this.top && other.bottom < this.bottom || other.top <= this.top && other.bottom >= this.bottom) {
            inY = true;
        }
        return inX && inY;
    }

    public boolean intersects(Circle other) {
        double centerDistanceX = Math.abs(other.getCenter().getX() - this.getCenter().getX());
        double centerDistanceY = Math.abs(other.getCenter().getY() - this.getCenter().getY());
        if (centerDistanceX > this.getWidth() / 2.0 + other.getRadius()) {
            return false;
        }
        if (centerDistanceY > this.getHeight() / 2.0 + other.getRadius()) {
            return false;
        }
        if (centerDistanceX <= this.getWidth() / 2.0) {
            return true;
        }
        if (centerDistanceY <= this.getHeight() / 2.0) {
            return true;
        }
        double cornerDistance = Math.pow(centerDistanceX - this.getWidth() / 2.0, 2.0) + Math.pow(centerDistanceY - this.getHeight() / 2.0, 2.0);
        return cornerDistance <= Math.pow(other.getRadius(), 2.0);
    }

    public Rectangle getRectangle() {
        return new Rectangle((int)this.left, (int)this.top, (int)this.getWidth(), (int)this.getHeight());
    }

    public double getDistance(BoundingBox other) {
        Line line = new Line(this.getCenter(), other.getCenter());
        return line.getLength();
    }

    public boolean hasBorderCrossing(List<Point> itemPointsToCheck, long tileSize) {
        if (itemPointsToCheck.size() > 1) {
            Point lastPoint = itemPointsToCheck.get(0);
            for (int i = 1; i < itemPointsToCheck.size(); ++i) {
                Point currentPoint = itemPointsToCheck.get(i);
                if (lastPoint.getX() < 0.0 && currentPoint.getX() >= 0.0) {
                    return true;
                }
                if (lastPoint.getX() >= 0.0 && currentPoint.getX() < 0.0) {
                    return true;
                }
                if (lastPoint.getX() < (double)tileSize && currentPoint.getX() >= (double)tileSize) {
                    return true;
                }
                if (lastPoint.getX() >= (double)tileSize && currentPoint.getX() < (double)tileSize) {
                    return true;
                }
                if (lastPoint.getY() < 0.0 && currentPoint.getY() >= 0.0) {
                    return true;
                }
                if (lastPoint.getY() >= 0.0 && currentPoint.getY() < 0.0) {
                    return true;
                }
                if (lastPoint.getY() < (double)tileSize && currentPoint.getY() >= (double)tileSize) {
                    return true;
                }
                if (!(lastPoint.getY() >= (double)tileSize) || !(currentPoint.getY() < (double)tileSize)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCloseToBorder(List<Point> itemPointsToCheck, long tileSize, double minBorderDistance) {
        if (itemPointsToCheck.size() > 0) {
            for (int i = 0; i < itemPointsToCheck.size(); ++i) {
                Point currentPoint = itemPointsToCheck.get(i);
                if (currentPoint.getX() < minBorderDistance) {
                    return true;
                }
                if (currentPoint.getX() >= (double)tileSize - minBorderDistance) {
                    return true;
                }
                if (currentPoint.getY() < minBorderDistance) {
                    return true;
                }
                if (!(currentPoint.getY() >= (double)tileSize - minBorderDistance)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Point xyPoint) {
        if (xyPoint.getX() < this.left || xyPoint.getX() > this.right) {
            return false;
        }
        return !(this.top < this.bottom ? xyPoint.getY() < this.top || xyPoint.getY() > this.bottom : xyPoint.getY() > this.top || xyPoint.getY() < this.bottom);
    }

    public boolean contains(BoundingBox other) {
        return this.top < this.bottom ? other.left >= this.left && other.right <= this.right && other.top >= this.top && other.bottom <= this.bottom : other.left >= this.left && other.right <= this.right && other.top <= this.top && other.bottom >= this.bottom;
    }

    public BoundingBox expand(BoundingBox other) {
        this.left = Math.min(this.left, other.left);
        this.right = Math.max(this.right, other.right);
        if (this.top < this.bottom) {
            this.top = Math.min(this.top, other.top);
            this.bottom = Math.max(this.bottom, other.bottom);
        } else {
            this.top = Math.max(this.top, other.top);
            this.bottom = Math.min(this.bottom, other.bottom);
        }
        return this;
    }

    public double getTop() {
        return this.top;
    }

    public void setTop(double top) {
        this.top = top;
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double bottom) {
        this.bottom = bottom;
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double right) {
        this.right = right;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    public Point getLeftTop() {
        return new Point(this.left, this.top);
    }

    public Point getLeftBottom() {
        return new Point(this.left, this.bottom);
    }

    public Point getRightTop() {
        return new Point(this.right, this.top);
    }

    public Point getRightBottom() {
        return new Point(this.right, this.bottom);
    }

    public Point getCenter() {
        return new Point((this.left + this.right) / 2.0, (this.top + this.bottom) / 2.0);
    }

    public double getWidth() {
        return this.right - this.left;
    }

    public double getHeight() {
        if (this.top < this.bottom) {
            return this.bottom - this.top;
        }
        return this.top - this.bottom;
    }

    public String toString() {
        return "BoundingBox[left=" + this.left + ", top=" + this.bottom + ", right=" + this.right + ", bottom=" + this.top + ", ltrb=" + this.left + "," + this.top + "," + this.right + "," + this.bottom + "]";
    }

    public BoundingBox clone() {
        return new BoundingBox(this.left, this.bottom, this.right, this.top);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.left).append(this.right).append(this.top).append(this.bottom).toHashCode();
    }
}

