/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.deprecated;

import de.wideportal.maprender.deprecated.SrtmCollectTile;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.file.FileAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrtmCollectTileCachePersister
extends FileAccessor {
    protected static Logger log = LoggerFactory.getLogger(SrtmCollectTileCachePersister.class);
    private static final String FILETYPE = "srtmcache";
    private static final Integer DEFAULT_MAX_ZOOM = 10;
    private String baseFolder;
    private Integer fileCacheMaxZoom;

    public SrtmCollectTileCachePersister(String baseFolder, Integer fileCacheMaxZoom) {
        this.baseFolder = baseFolder;
        this.fileCacheMaxZoom = fileCacheMaxZoom;
        if (this.fileCacheMaxZoom == null) {
            this.fileCacheMaxZoom = DEFAULT_MAX_ZOOM;
        }
    }

    private synchronized Optional<SrtmCollectTile> load(RenderRequest renderRequest) {
        log.debug("load: zoom=" + renderRequest.getZoomInfo().getZoom() + " / tileIndex=" + renderRequest.getTileIndex() + " / bbox" + renderRequest.getBoundingBoxLatLon());
        int zoom = (int)renderRequest.getZoomInfo().getZoom();
        int xIndex = (int)renderRequest.getTileIndex().getX();
        int yIndex = (int)renderRequest.getTileIndex().getY();
        Optional<File> optionalYFile = this.getFile(this.baseFolder, zoom, xIndex, yIndex, FILETYPE, false);
        SrtmCollectTile result = null;
        File yFile = null;
        if (optionalYFile.isPresent()) {
            yFile = optionalYFile.get();
            if (yFile.exists()) {
                try (FileInputStream fis = new FileInputStream(yFile);
                     ZipInputStream zis = new ZipInputStream(fis);){
                    ZipEntry innerFile = zis.getNextEntry();
                    if (innerFile != null) {
                        FSTObjectInput ois = new FSTObjectInput((InputStream)zis);
                        result = (SrtmCollectTile)ois.readObject(new Class[]{SrtmCollectTile.class});
                        ois.close();
                    }
                }
                catch (Exception e) {
                    log.error("load: could not load from file: " + yFile.getAbsolutePath(), (Throwable)e);
                }
            }
        } else {
            log.debug("load: file is not accessible. Cannot load srtm cache. Base folder is: " + this.baseFolder);
        }
        return Optional.ofNullable(result);
    }

    private void persist(RenderRequest renderRequest, SrtmCollectTile srtmCollectTile) {
        log.debug("persist: zoom=" + renderRequest.getZoomInfo().getZoom() + " / tileIndex=" + renderRequest.getTileIndex() + " / bbox" + renderRequest.getBoundingBoxLatLon());
        int zoom = (int)renderRequest.getZoomInfo().getZoom();
        int xIndex = (int)renderRequest.getTileIndex().getX();
        int yIndex = (int)renderRequest.getTileIndex().getY();
        if (zoom > this.fileCacheMaxZoom) {
            log.debug("persist: zoom level was higher than the configured max zoom level, so we are not saving to cache");
            return;
        }
        Optional<File> optionalYFile = this.getFile(this.baseFolder, zoom, xIndex, yIndex, FILETYPE, true);
        File yFile = null;
        if (optionalYFile.isPresent()) {
            yFile = optionalYFile.get();
        } else {
            log.error("persist: file is not accessible. Cannot save tile. Base folder is: " + this.baseFolder);
        }
        if (yFile.exists()) {
            log.debug("persist: cache was already created");
            return;
        }
        try {
            log.debug("persist: saved srtm cache file: " + yFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("persist: could not write srtm cache file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
        try (FileOutputStream fout = new FileOutputStream(yFile);
             ZipOutputStream zos = new ZipOutputStream(fout);
             FSTObjectOutput oos = new FSTObjectOutput((OutputStream)zos);){
            ZipEntry innerFile = new ZipEntry("cache");
            zos.putNextEntry(innerFile);
            oos.writeObject((Object)srtmCollectTile, new Class[]{SrtmCollectTile.class});
        }
        catch (IOException e) {
            log.error("persist: could not write to file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

