/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource.osm;

import de.wideportal.maprender.datasource.IDatasourceGeometry;
import de.wideportal.maprender.datasource.kml.KmlLineString;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.datasource.osm.PostgresPolygonElement;
import de.wideportal.maprender.geom.BoundingBox;
import java.util.ArrayList;

public class PostgresPolygon
implements IDatasourceGeometry {
    public static final String GEOMETRY_PREFIX = "POLYGON";
    protected String source;
    protected PostgresPolygonElement[] polygonElements = null;

    protected PostgresPolygon() {
    }

    public PostgresPolygon(String geometryString) {
        this.source = geometryString;
        this.parseGeometryString(geometryString);
    }

    public PostgresPolygon(PostgresLineString closedLineString) {
        this.source = closedLineString.getSource();
        this.parseClosedLineString(closedLineString);
    }

    public PostgresPolygon(KmlLineString kmlLineString) {
        this.source = kmlLineString.getSource();
        this.initFromKmlLineString(kmlLineString);
    }

    public static boolean isFittingGeometry(String geometryString) {
        return geometryString != null && geometryString.startsWith("POLYGON(");
    }

    protected void parseClosedLineString(PostgresLineString closedLineString) {
        PostgresPolygonElement element = new PostgresPolygonElement(closedLineString);
        this.polygonElements = new PostgresPolygonElement[]{element};
    }

    protected void parseGeometryString(String geometryString) {
        int i;
        String prefixToCut = "POLYGON(";
        geometryString = geometryString.substring(prefixToCut.length(), geometryString.length() - 1);
        ArrayList<String> blocks = new ArrayList<String>();
        int indexBlockStart = -1;
        int indexBlockEnd = -1;
        for (i = 0; i < geometryString.length(); ++i) {
            if (geometryString.charAt(i) == '(') {
                indexBlockStart = i;
            }
            if (geometryString.charAt(i) == ')') {
                indexBlockEnd = i;
            }
            if (indexBlockEnd <= indexBlockStart) continue;
            blocks.add(geometryString.substring(indexBlockStart + 1, indexBlockEnd));
            indexBlockStart = -1;
            indexBlockEnd = -1;
        }
        this.polygonElements = new PostgresPolygonElement[blocks.size()];
        for (i = 0; i < blocks.size(); ++i) {
            this.polygonElements[i] = new PostgresPolygonElement((String)blocks.get(i));
        }
    }

    protected void initFromKmlLineString(KmlLineString kmlLineString) {
        this.polygonElements = new PostgresPolygonElement[1];
        this.polygonElements[0] = new PostgresPolygonElement(kmlLineString);
    }

    public String getSource() {
        return this.source;
    }

    public PostgresPolygonElement[] getPolygonElements() {
        return this.polygonElements;
    }

    public BoundingBox getBoundingBox(boolean topIsMinY) {
        if (this.polygonElements.length > 0) {
            return new BoundingBox(this.polygonElements[0].getPoints(), topIsMinY);
        }
        return null;
    }

    public PostgresPolygon clone() {
        PostgresPolygon clone = new PostgresPolygon();
        clone.source = this.source;
        clone.polygonElements = new PostgresPolygonElement[this.polygonElements.length];
        for (int i = 0; i < this.polygonElements.length; ++i) {
            clone.polygonElements[i] = this.polygonElements[i].clone();
        }
        return clone;
    }

    public String toString() {
        return "PostgresPolygon[#polygonElements=" + this.polygonElements.length + ", source=" + this.source + "]";
    }
}

