/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource.osm;

import de.wideportal.maprender.datasource.IDatasourceGeometry;
import de.wideportal.maprender.datasource.osm.PostgresPolygon;
import de.wideportal.maprender.geom.BoundingBox;
import java.util.ArrayList;

public class PostgresMultiPolygon
implements IDatasourceGeometry {
    public static final String GEOMETRY_PREFIX = "MULTIPOLYGON";
    protected String source;
    protected PostgresPolygon[] polygons = null;

    protected PostgresMultiPolygon() {
    }

    public PostgresMultiPolygon(String geometryString) {
        this.source = geometryString;
        this.parseGeometryString(geometryString);
    }

    public static boolean isFittingGeometry(String geometryString) {
        return geometryString != null && geometryString.startsWith("MULTIPOLYGON(");
    }

    protected void parseGeometryString(String geometryString) {
        int i;
        String prefixToCut = "MULTIPOLYGON(";
        geometryString = geometryString.substring(prefixToCut.length(), geometryString.length() - 1);
        ArrayList<String> polygonsList = new ArrayList<String>();
        int indexPolygonBlockStart = -1;
        int indexPolygonBlockEnd = -1;
        int bracketCounter = 0;
        for (i = 0; i < geometryString.length(); ++i) {
            if (geometryString.charAt(i) == '(') {
                if (bracketCounter == 0) {
                    indexPolygonBlockStart = i;
                }
                ++bracketCounter;
            }
            if (geometryString.charAt(i) == ')' && --bracketCounter == 0) {
                indexPolygonBlockEnd = i;
            }
            if (indexPolygonBlockEnd <= indexPolygonBlockStart) continue;
            polygonsList.add(geometryString.substring(indexPolygonBlockStart + 1, indexPolygonBlockEnd));
            indexPolygonBlockStart = -1;
            indexPolygonBlockEnd = -1;
        }
        this.polygons = new PostgresPolygon[polygonsList.size()];
        for (i = 0; i < polygonsList.size(); ++i) {
            String polygonString = "POLYGON(" + (String)polygonsList.get(i) + ")";
            this.polygons[i] = new PostgresPolygon(polygonString);
        }
    }

    public String getSource() {
        return this.source;
    }

    public PostgresPolygon[] getPolygons() {
        return this.polygons;
    }

    public BoundingBox getBoundingBox(boolean topIsMinY) {
        if (this.polygons.length > 0) {
            BoundingBox result = null;
            BoundingBox currentBoundingBox = null;
            for (int i = 0; i < this.polygons.length; ++i) {
                PostgresPolygon polygon = this.polygons[i];
                currentBoundingBox = new BoundingBox(polygon.getPolygonElements()[0].getPoints(), topIsMinY);
                if (result == null) {
                    result = currentBoundingBox;
                    continue;
                }
                result.setLeft(Math.min(result.getLeft(), currentBoundingBox.getLeft()));
                result.setRight(Math.max(result.getRight(), currentBoundingBox.getRight()));
                if (topIsMinY) {
                    result.setTop(Math.min(result.getTop(), currentBoundingBox.getTop()));
                    result.setBottom(Math.max(result.getBottom(), currentBoundingBox.getBottom()));
                    continue;
                }
                result.setTop(Math.max(result.getTop(), currentBoundingBox.getTop()));
                result.setBottom(Math.min(result.getBottom(), currentBoundingBox.getBottom()));
            }
            return result;
        }
        return null;
    }

    public PostgresMultiPolygon clone() {
        PostgresMultiPolygon clone = new PostgresMultiPolygon();
        clone.source = this.source;
        clone.polygons = new PostgresPolygon[this.polygons.length];
        for (int i = 0; i < this.polygons.length; ++i) {
            clone.polygons[i] = this.polygons[i].clone();
        }
        return clone;
    }

    public String toString() {
        return "PostgresMultiPolygon[#polygons=" + this.polygons.length + ", source=" + this.source + "]";
    }
}

