/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource.kml;

import de.wideportal.maprender.datasource.IDatasourceGeometry;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;

public class KmlLineString
implements IDatasourceGeometry {
    private String source;
    private String styleUrl;
    private Point[] points = null;

    private KmlLineString() {
    }

    public KmlLineString(String source, String styleUrl, List<String> geometryList) {
        this.source = source;
        this.styleUrl = styleUrl;
        this.parseGeometryString(geometryList);
    }

    private void parseGeometryString(List<String> geometryList) {
        this.points = new Point[geometryList.size()];
        for (int i = 0; i < geometryList.size(); ++i) {
            String[] xyz = geometryList.get(i).split(",");
            this.points[i] = new Point(Double.parseDouble(xyz[0].trim()), Double.parseDouble(xyz[1].trim()));
        }
    }

    public Point[] getPoints() {
        return this.points;
    }

    public boolean isInBoundingBoxLatLon(BoundingBox boundingBoxLatLon) {
        for (int i = 0; i < this.points.length; ++i) {
            Point lastPoint;
            Line line;
            Point point = this.points[i];
            if (point.x >= boundingBoxLatLon.left && point.x <= boundingBoxLatLon.right && point.y <= boundingBoxLatLon.top && point.y >= boundingBoxLatLon.bottom) {
                return true;
            }
            if (i <= 0 || !(line = new Line(lastPoint = this.points[i - 1], point)).crossesBoundingBox(boundingBoxLatLon)) continue;
            return true;
        }
        return false;
    }

    public String getSource() {
        return this.source;
    }

    public String getStyleUrl() {
        return this.styleUrl;
    }

    public boolean isClosedPolygon() {
        if (this.points.length >= 2) {
            Point startPoint = this.points[0];
            Point stopPoint = this.points[this.points.length - 1];
            if (startPoint.getX() == stopPoint.getX() && startPoint.getY() == stopPoint.getY()) {
                return true;
            }
        }
        return false;
    }

    public String convertToPostgresGeometry(GeoCalculator geoCalculator) {
        if (this.isClosedPolygon()) {
            Object postgresString = "";
            postgresString = (String)postgresString + "POLYGON";
            ArrayList<CallSite> mercatorPoints = new ArrayList<CallSite>();
            for (int i = 0; i < this.points.length; ++i) {
                Point mercatorPoint = geoCalculator.convertLatLonToMercator(this.points[i]);
                mercatorPoints.add((CallSite)((Object)(mercatorPoint.getX() + " " + mercatorPoint.getY())));
            }
            postgresString = (String)postgresString + "((";
            postgresString = (String)postgresString + String.join((CharSequence)",", mercatorPoints);
            postgresString = (String)postgresString + "))";
            return postgresString;
        }
        Object postgresString = "";
        postgresString = (String)postgresString + "LINESTRING";
        ArrayList<CallSite> mercatorPoints = new ArrayList<CallSite>();
        for (int i = 0; i < this.points.length; ++i) {
            Point mercatorPoint = geoCalculator.convertLatLonToMercator(this.points[i]);
            mercatorPoints.add((CallSite)((Object)(mercatorPoint.getX() + " " + mercatorPoint.getY())));
        }
        postgresString = (String)postgresString + "(";
        postgresString = (String)postgresString + String.join((CharSequence)",", mercatorPoints);
        postgresString = (String)postgresString + ")";
        return postgresString;
    }

    public KmlLineString clone() {
        KmlLineString clone = new KmlLineString();
        clone.source = this.source;
        clone.points = new Point[this.points.length];
        System.arraycopy(this.points, 0, clone.points, 0, this.points.length);
        return clone;
    }

    public String toString() {
        return "KmlLineString[#points=" + this.points.length + ", source=" + this.source + ", styleUrl=" + this.styleUrl + "]";
    }
}

