/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.filter;

import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterPart;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterResult;
import de.wideportal.maprender.datasource.RenderResultSetCache;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmRuleFilterOperator
extends OsmRuleFilterPart {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String OPERATOR_AND = "and";
    public static final String OPERATOR_OR = "or";
    public static final List<String> OPERATORS = new ArrayList<String>();

    public OsmRuleFilterOperator(String filterDescription) {
        super(filterDescription);
    }

    public OsmRuleFilterOperator(OsmRuleFilterPart part) {
        super(part.getFilterDescription());
        this.subFilters = part.getSubFilters();
    }

    @Override
    public boolean matchesResultSet(RenderResultSetCache resultSetCache, OsmRuleFilterResult filterResult) {
        Object resultString = this.filterDescription + " (";
        filterResult.addFilterPart((String)resultString);
        OsmRuleFilterPart leftCondition = (OsmRuleFilterPart)this.subFilters.get(0);
        OsmRuleFilterPart rightCondition = (OsmRuleFilterPart)this.subFilters.get(1);
        if (OPERATOR_AND.equalsIgnoreCase(this.filterDescription)) {
            boolean result = leftCondition.matchesResultSet(resultSetCache, filterResult) && rightCondition.matchesResultSet(resultSetCache, filterResult);
            this.log.debug("matchesResultSet: " + result + " / " + this);
            resultString = ") ";
            filterResult.addFilterPart((String)resultString);
            return result;
        }
        if (OPERATOR_OR.equalsIgnoreCase(this.filterDescription)) {
            boolean result = leftCondition.matchesResultSet(resultSetCache, filterResult) || rightCondition.matchesResultSet(resultSetCache, filterResult);
            this.log.debug("matchesResultSet: " + result + " / " + this);
            resultString = ") ";
            filterResult.addFilterPart((String)resultString);
            return result;
        }
        this.log.error("matchesResultSet: Unknown Operator: " + this.filterDescription);
        this.log.debug("matchesResultSet: false / " + this);
        resultString = "none) ";
        filterResult.addFilterPart((String)resultString);
        return false;
    }

    @Override
    public String toString() {
        return "OsmRuleFilterOperator[filterDescription=" + this.filterDescription + "]";
    }

    static {
        OPERATORS.add(OPERATOR_AND);
        OPERATORS.add(OPERATOR_OR);
    }
}

