/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmRule;
import de.wideportal.maprender.config.xml.osm.OsmTextSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.IOsmTextAccessor;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmTextSymbolizerAccessor
extends BaseAccessor
implements IOsmTextAccessor {
    public static final double DEFAULT_SIZE = 10.0;
    public static final double DEFAULT_WRAP_WIDTH = 0.0;
    public static final double DEFAULT_LINE_SPACING = 0.0;
    public static final double DEFAULT_MARGIN = 0.0;
    public static final Color DEFAULT_FILL = Color.BLACK;
    public static final Color DEFAULT_HALO_FILL = Color.WHITE;
    public static final float DEFAULT_HALO_RADIUS = 0.0f;
    public static final String DEFAULT_PLACEMENT = "point";
    public static final double DEFAULT_SPACING = 0.0;
    public static final boolean DEFAULT_ALLOW_OVERLAP = false;
    public static final float DEFAULT_OPACITY = 1.0f;
    public static final double DEFAULT_DX = 0.0;
    public static final double DEFAULT_DY = 0.0;
    public static final String DEFAULT_VERTICAL_ALIGNMENT = "auto";
    public static final String DEFAULT_HORIZONTAL_ALIGNMENT = "auto";
    public static final String DEFAULT_JUSTIFY_ALIGNMENT = "auto";
    public static final Point DEFAULT_DISPLACEMENT = new Point(0.0, 0.0);
    public static final double DEFAULT_CHARACTER_SPACING = 0.0;
    public static final String DEFAULT_WRAP_CHARACTER = " ";
    public static final double DEFAULT_REPEAT_DISTANCE = 0.0;
    public static final double DEFAULT_BORDER_DISTANCE = 0.0;
    public static final int DEFAULT_FACE_STYLE = 0;
    public static final boolean DEFAULT_SKIP_TEXT_DIRECTION_ADJUSTMENT = false;
    private OsmTextSymbolizer osmTextSymbolizer;
    private Double cachedSize = null;
    private Double cachedWrapWidth = null;
    private Double cachedLineSpacing = null;
    private Double cachedMargin = null;
    private Color cachedFill = null;
    private Color cachedHaloFill = null;
    private Float cachedHaloRadius = null;
    private String cachedPlacement = null;
    private Double cachedCharacterSpacing = null;
    private Double cachedSpacing = null;
    private Boolean cachedAllowOverlap = null;
    private Float cachedOpacity = null;
    private Double cachedDX = null;
    private Double cachedDY = null;
    private String cachedVerticalAlignment = null;
    private String cachedHorizontalAlignment = null;
    private String cachedJustifyAlignment = null;
    private Point cachedDisplacement = null;
    private String cachedWrapCharacter = null;
    private Double cachedRepeatDistance = null;
    private Double cachedBorderDistance = null;
    private Integer cachedFaceStyle = null;
    private Boolean cachedSkipTextDirectionAdjustment = null;

    public OsmTextSymbolizerAccessor(OsmTextSymbolizer osmTextSymbolizer) {
        this.osmTextSymbolizer = osmTextSymbolizer;
    }

    public OsmTextSymbolizer getOsmTextSymbolizer() {
        return this.osmTextSymbolizer;
    }

    @Override
    public Double getSize() {
        if (this.cachedSize == null) {
            this.cachedSize = this.getFromOptionalOrElse(this.safeParseDouble(this.osmTextSymbolizer.getSize()), 10.0);
        }
        return this.cachedSize;
    }

    @Override
    public Double getWrapWidth() {
        if (this.cachedWrapWidth == null) {
            this.cachedWrapWidth = this.getFromOptionalOrElse(this.safeParseDouble(this.osmTextSymbolizer.getWrapWidth()), 0.0);
        }
        return this.cachedWrapWidth;
    }

    @Override
    public Double getLineSpacing() {
        if (this.cachedLineSpacing == null) {
            this.cachedLineSpacing = this.getFromOptionalOrElse(this.safeParseDouble(this.osmTextSymbolizer.getLineSpacing()), 0.0);
        }
        return this.cachedLineSpacing;
    }

    @Override
    public Double getRepeatDistance() {
        if (this.cachedRepeatDistance == null) {
            this.cachedRepeatDistance = this.getFromOptionalOrElse(this.safeParseDouble(this.osmTextSymbolizer.getRepeatDistance()), 0.0);
        }
        return this.cachedRepeatDistance;
    }

    @Override
    public Double getBorderDistance() {
        if (this.cachedBorderDistance == null) {
            this.cachedBorderDistance = this.getFromOptionalOrElse(this.safeParseDouble(this.osmTextSymbolizer.getBorderDistance()), 0.0);
        }
        return this.cachedBorderDistance;
    }

    @Override
    public Double getMargin() {
        if (this.cachedMargin == null) {
            this.cachedMargin = this.getFromOptionalOrElse(this.safeParseDouble(this.osmTextSymbolizer.getMargin()), 0.0);
        }
        return this.cachedMargin;
    }

    @Override
    public Color getFill() {
        if (this.cachedFill == null) {
            Optional<String> optionalFill = this.safeGetNonEmptyString(this.osmTextSymbolizer.getFill());
            this.cachedFill = optionalFill.isPresent() ? ColorUtil.getColorFromString(optionalFill.get()) : DEFAULT_FILL;
        }
        return this.cachedFill;
    }

    @Override
    public Optional<String> getFontsetName() {
        return Optional.ofNullable(this.osmTextSymbolizer.getFontsetName());
    }

    @Override
    public Optional<String> getFaceName() {
        return Optional.ofNullable(this.osmTextSymbolizer.getFaceName());
    }

    @Override
    public int getFaceStyle() {
        if (this.cachedFaceStyle == null) {
            Optional<String> optionalFaceStyle = this.safeGetNonEmptyString(this.osmTextSymbolizer.getFaceStyle());
            if (optionalFaceStyle.isPresent()) {
                String faceStyle;
                switch (faceStyle = optionalFaceStyle.get().toUpperCase()) {
                    case "BOLD": {
                        this.cachedFaceStyle = 1;
                        break;
                    }
                    case "ITALIC": {
                        this.cachedFaceStyle = 2;
                        break;
                    }
                    case "PLAIN": {
                        this.cachedFaceStyle = 0;
                        break;
                    }
                    default: {
                        this.cachedFaceStyle = 0;
                        break;
                    }
                }
            } else {
                this.cachedFaceStyle = 0;
            }
        }
        return this.cachedFaceStyle;
    }

    public Optional<String> getPlacements() {
        return Optional.ofNullable(this.osmTextSymbolizer.getPlacements());
    }

    @Override
    public Color getHaloFill() {
        if (this.cachedHaloFill == null) {
            Optional<String> optionalHaloFill = this.safeGetNonEmptyString(this.osmTextSymbolizer.getHaloFill());
            this.cachedHaloFill = optionalHaloFill.isPresent() ? ColorUtil.getColorFromString(optionalHaloFill.get()) : DEFAULT_HALO_FILL;
        }
        return this.cachedHaloFill;
    }

    @Override
    public Float getHaloRadius() {
        if (this.cachedHaloRadius == null) {
            this.cachedHaloRadius = this.getFromOptionalOrElse(this.safeParseFloat(this.osmTextSymbolizer.getHaloRadius()), 0.0f);
        }
        return this.cachedHaloRadius;
    }

    @Override
    public String getPlacement() {
        if (this.cachedPlacement == null) {
            this.cachedPlacement = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmTextSymbolizer.getPlacement()), DEFAULT_PLACEMENT);
        }
        return this.cachedPlacement;
    }

    @Override
    public Double getCharacterSpacing() {
        if (this.cachedCharacterSpacing == null) {
            this.cachedCharacterSpacing = this.getFromOptionalOrElse(this.safeParseDouble(this.osmTextSymbolizer.getCharacterSpacing()), 0.0);
        }
        return this.cachedCharacterSpacing;
    }

    @Override
    public Optional<String> getValue() {
        return Optional.ofNullable(this.osmTextSymbolizer.getValue());
    }

    public OsmRule getParent() {
        return this.osmTextSymbolizer.getParent();
    }

    @Override
    public Double getSpacing() {
        if (this.cachedSpacing == null) {
            this.cachedSpacing = this.getFromOptionalOrElse(this.safeParseDouble(this.osmTextSymbolizer.getSpacing()), 0.0);
        }
        return this.cachedSpacing;
    }

    public Boolean getAllowOverlap() {
        if (this.cachedAllowOverlap == null) {
            this.cachedAllowOverlap = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmTextSymbolizer.getAllowOverlap()), false);
        }
        return this.cachedAllowOverlap;
    }

    @Override
    public Float getOpacity() {
        if (this.cachedOpacity == null) {
            this.cachedOpacity = this.getFromOptionalOrElse(this.safeParseFloat(this.osmTextSymbolizer.getOpacity()), 1.0f);
        }
        return this.cachedOpacity;
    }

    @Override
    public Double getDx() {
        if (this.cachedDX == null) {
            this.cachedDX = this.getFromOptionalOrElse(this.safeParseDouble(this.osmTextSymbolizer.getDx()), 0.0);
        }
        return this.cachedDX;
    }

    @Override
    public Double getDy() {
        if (this.cachedDY == null) {
            this.cachedDY = this.getFromOptionalOrElse(this.safeParseDouble(this.osmTextSymbolizer.getDy()), 0.0);
        }
        return this.cachedDY;
    }

    @Override
    public String getVerticalAlignment() {
        if (this.cachedVerticalAlignment == null) {
            this.cachedVerticalAlignment = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmTextSymbolizer.getVerticalAlignment()), "auto");
        }
        return this.cachedVerticalAlignment;
    }

    @Override
    public String getHorizontalAlignment() {
        if (this.cachedHorizontalAlignment == null) {
            this.cachedHorizontalAlignment = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmTextSymbolizer.getHorizontalAlignment()), "auto");
        }
        return this.cachedHorizontalAlignment;
    }

    @Override
    public String getJustifyAlignment() {
        if (this.cachedJustifyAlignment == null) {
            this.cachedJustifyAlignment = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmTextSymbolizer.getJustifyAlignment()), "auto");
        }
        return this.cachedJustifyAlignment;
    }

    @Override
    public Point getDisplacement() {
        if (this.cachedDisplacement == null) {
            this.cachedDisplacement = this.getFromOptionalOrElse(this.safeParsePoint(this.osmTextSymbolizer.getDisplacement()), DEFAULT_DISPLACEMENT);
        }
        return this.cachedDisplacement;
    }

    @Override
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmTextSymbolizer.getIdentifier());
    }

    @Override
    public String getWrapCharacter() {
        if (this.cachedWrapCharacter == null) {
            this.cachedWrapCharacter = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmTextSymbolizer.getWrapCharacter()), DEFAULT_WRAP_CHARACTER);
        }
        return this.cachedWrapCharacter;
    }

    public Boolean getSkipTextDirectionAdjustment() {
        if (this.cachedSkipTextDirectionAdjustment == null) {
            this.cachedSkipTextDirectionAdjustment = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmTextSymbolizer.getSkipTextDirectionAdjustment()), false);
        }
        return this.cachedSkipTextDirectionAdjustment;
    }

    public String toString() {
        return "OsmTextSymbolizerAccessor[" + this.osmTextSymbolizer + "]";
    }
}

