/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmRule;
import de.wideportal.maprender.config.xml.osm.OsmShieldSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.IOsmTextAccessor;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmShieldSymbolizerAccessor
extends BaseAccessor
implements IOsmTextAccessor {
    public static final double DEFAULT_SIZE = 10.0;
    public static final double DEFAULT_WRAP_WIDTH = 0.0;
    public static final double DEFAULT_LINE_SPACING = 0.0;
    public static final double DEFAULT_MARGIN = 0.0;
    public static final Color DEFAULT_FILL = Color.BLACK;
    public static final Color DEFAULT_HALO_FILL = Color.WHITE;
    public static final float DEFAULT_HALO_RADIUS = 0.0f;
    public static final String DEFAULT_PLACEMENT = "point";
    public static final float DEFAULT_OPACITY = 1.0f;
    public static final double DEFAULT_DX = 0.0;
    public static final double DEFAULT_DY = 0.0;
    public static final String DEFAULT_VERTICAL_ALIGNMENT = "auto";
    public static final String DEFAULT_HORIZONTAL_ALIGNMENT = "auto";
    public static final String DEFAULT_JUSTIFY_ALIGNMENT = "auto";
    public static final Point DEFAULT_DISPLACEMENT = new Point(0.0, 0.0);
    public static final double DEFAULT_SPACING = 0.0;
    public static final double DEFAULT_REPEAT_DISTANCE = 0.0;
    public static final double DEFAULT_CHARACTER_SPACING = 0.0;
    public static final String DEFAULT_WRAP_CHARACTER = " ";
    public static final double DEFAULT_BORDER_DISTANCE = 0.0;
    public static final int DEFAULT_FACE_STYLE = 0;
    public static final boolean DEFAULT_FORBID_BORDER_PLACEMENT = false;
    private OsmShieldSymbolizer osmShieldSymbolizer;
    private Double cachedSize = null;
    private Double cachedWrapWidth = null;
    private Double cachedLineSpacing = null;
    private Double cachedMargin = null;
    private Color cachedFill = null;
    private Color cachedHaloFill = null;
    private Float cachedHaloRadius = null;
    private String cachedPlacement = null;
    private Double cachedDX = null;
    private Double cachedDY = null;
    private Float cachedOpacity = null;
    private Float cachedTextOpacity = null;
    private Double cachedSpacing = null;
    private Double cachedRepeatDistance = null;
    private Boolean cachedIsFillSet = null;
    private String cachedWrapCharacter = null;
    private Double cachedCharacterSpacing = null;
    private Double cachedBorderDistance = null;
    private Integer cachedFaceStyle = null;
    private Boolean cachedForbidBorderPlacement = null;

    public OsmShieldSymbolizerAccessor(OsmShieldSymbolizer osmShieldSymbolizer) {
        this.osmShieldSymbolizer = osmShieldSymbolizer;
    }

    public OsmShieldSymbolizer getOsmShieldSymbolizer() {
        return this.osmShieldSymbolizer;
    }

    @Override
    public String getPlacement() {
        if (this.cachedPlacement == null) {
            this.cachedPlacement = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmShieldSymbolizer.getPlacement()), DEFAULT_PLACEMENT);
        }
        return this.cachedPlacement;
    }

    @Override
    public Float getOpacity() {
        if (this.cachedOpacity == null) {
            this.cachedOpacity = this.getFromOptionalOrElse(this.safeParseFloat(this.osmShieldSymbolizer.getOpacity()), 1.0f);
        }
        return this.cachedOpacity;
    }

    public Float getTextOpacity() {
        if (this.cachedTextOpacity == null) {
            this.cachedTextOpacity = this.getFromOptionalOrElse(this.safeParseFloat(this.osmShieldSymbolizer.getTextOpacity()), 1.0f);
        }
        return this.cachedTextOpacity;
    }

    public Optional<String> getFile() {
        return this.safeGetNonEmptyString(this.osmShieldSymbolizer.getFile());
    }

    @Override
    public Double getSpacing() {
        if (this.cachedSpacing == null) {
            this.cachedSpacing = this.getFromOptionalOrElse(this.safeParseDouble(this.osmShieldSymbolizer.getSpacing()), 0.0);
        }
        return this.cachedSpacing;
    }

    @Override
    public Double getRepeatDistance() {
        if (this.cachedRepeatDistance == null) {
            this.cachedRepeatDistance = this.getFromOptionalOrElse(this.safeParseDouble(this.osmShieldSymbolizer.getRepeatDistance()), 0.0);
        }
        return this.cachedRepeatDistance;
    }

    @Override
    public Double getBorderDistance() {
        if (this.cachedBorderDistance == null) {
            this.cachedBorderDistance = this.getFromOptionalOrElse(this.safeParseDouble(this.osmShieldSymbolizer.getBorderDistance()), 0.0);
        }
        return this.cachedBorderDistance;
    }

    @Override
    public Double getDx() {
        if (this.cachedDX == null) {
            this.cachedDX = this.getFromOptionalOrElse(this.safeParseDouble(this.osmShieldSymbolizer.getDx()), 0.0);
        }
        return this.cachedDX;
    }

    @Override
    public Double getDy() {
        if (this.cachedDY == null) {
            this.cachedDY = this.getFromOptionalOrElse(this.safeParseDouble(this.osmShieldSymbolizer.getDy()), 0.0);
        }
        return this.cachedDY;
    }

    @Override
    public Optional<String> getFontsetName() {
        return Optional.ofNullable(this.osmShieldSymbolizer.getFontsetName());
    }

    @Override
    public Optional<String> getFaceName() {
        return Optional.ofNullable(this.osmShieldSymbolizer.getFaceName());
    }

    @Override
    public int getFaceStyle() {
        if (this.cachedFaceStyle == null) {
            Optional<String> optionalFaceStyle = this.safeGetNonEmptyString(this.osmShieldSymbolizer.getFaceStyle());
            if (optionalFaceStyle.isPresent()) {
                String faceStyle;
                switch (faceStyle = optionalFaceStyle.get().toUpperCase()) {
                    case "BOLD": {
                        this.cachedFaceStyle = 1;
                        break;
                    }
                    case "ITALIC": {
                        this.cachedFaceStyle = 2;
                        break;
                    }
                    case "PLAIN": {
                        this.cachedFaceStyle = 0;
                        break;
                    }
                    default: {
                        this.cachedFaceStyle = 0;
                        break;
                    }
                }
            } else {
                this.cachedFaceStyle = 0;
            }
        }
        return this.cachedFaceStyle;
    }

    @Override
    public Color getFill() {
        if (this.cachedFill == null) {
            Optional<String> optionalFill = this.safeGetNonEmptyString(this.osmShieldSymbolizer.getFill());
            this.cachedFill = optionalFill.isPresent() ? ColorUtil.getColorFromString(optionalFill.get()) : DEFAULT_FILL;
        }
        return this.cachedFill;
    }

    public Optional<String> getFillCData() {
        String fill;
        Optional<String> optionalFill = this.safeGetNonEmptyString(this.osmShieldSymbolizer.getFill());
        if (optionalFill.isPresent() && (fill = optionalFill.get()).toUpperCase().contains("CDATA")) {
            return optionalFill;
        }
        return Optional.empty();
    }

    @Override
    public Double getSize() {
        if (this.cachedSize == null) {
            this.cachedSize = this.getFromOptionalOrElse(this.safeParseDouble(this.osmShieldSymbolizer.getSize()), 10.0);
        }
        return this.cachedSize;
    }

    @Override
    public Double getWrapWidth() {
        if (this.cachedWrapWidth == null) {
            this.cachedWrapWidth = this.getFromOptionalOrElse(this.safeParseDouble(this.osmShieldSymbolizer.getWrapWidth()), 0.0);
        }
        return this.cachedWrapWidth;
    }

    @Override
    public Double getLineSpacing() {
        if (this.cachedLineSpacing == null) {
            this.cachedLineSpacing = this.getFromOptionalOrElse(this.safeParseDouble(this.osmShieldSymbolizer.getLineSpacing()), 0.0);
        }
        return this.cachedLineSpacing;
    }

    @Override
    public Double getMargin() {
        if (this.cachedMargin == null) {
            this.cachedMargin = this.getFromOptionalOrElse(this.safeParseDouble(this.osmShieldSymbolizer.getMargin()), 0.0);
        }
        return this.cachedMargin;
    }

    @Override
    public Color getHaloFill() {
        if (this.cachedHaloFill == null) {
            Optional<String> optionalHaloFill = this.safeGetNonEmptyString(this.osmShieldSymbolizer.getHaloFill());
            this.cachedHaloFill = optionalHaloFill.isPresent() ? ColorUtil.getColorFromString(optionalHaloFill.get()) : DEFAULT_HALO_FILL;
        }
        return this.cachedHaloFill;
    }

    @Override
    public Float getHaloRadius() {
        if (this.cachedHaloRadius == null) {
            this.cachedHaloRadius = this.getFromOptionalOrElse(this.safeParseFloat(this.osmShieldSymbolizer.getHaloRadius()), 0.0f);
        }
        return this.cachedHaloRadius;
    }

    @Override
    public Optional<String> getValue() {
        return Optional.ofNullable(this.osmShieldSymbolizer.getValue());
    }

    public OsmRule getParent() {
        return this.osmShieldSymbolizer.getParent();
    }

    public Optional<String> getPlacements() {
        return Optional.ofNullable(this.osmShieldSymbolizer.getPlacements());
    }

    @Override
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmShieldSymbolizer.getIdentifier());
    }

    public Boolean isFillSet() {
        if (this.cachedIsFillSet == null) {
            this.cachedIsFillSet = this.isStringNotNullNotEmpty(this.osmShieldSymbolizer.getFill());
        }
        return this.cachedIsFillSet;
    }

    public Boolean isForbidBorderPlacement() {
        if (this.cachedForbidBorderPlacement == null) {
            this.cachedForbidBorderPlacement = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmShieldSymbolizer.getForbidBorderPlacement()), false);
        }
        return this.cachedForbidBorderPlacement;
    }

    @Override
    public Double getCharacterSpacing() {
        if (this.cachedCharacterSpacing == null) {
            this.cachedCharacterSpacing = this.getFromOptionalOrElse(this.safeParseDouble(this.osmShieldSymbolizer.getCharacterSpacing()), 0.0);
        }
        return this.cachedCharacterSpacing;
    }

    @Override
    public String getWrapCharacter() {
        if (this.cachedWrapCharacter == null) {
            this.cachedWrapCharacter = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmShieldSymbolizer.getWrapCharacter()), DEFAULT_WRAP_CHARACTER);
        }
        return this.cachedWrapCharacter;
    }

    @Override
    public String getVerticalAlignment() {
        return "auto";
    }

    @Override
    public String getHorizontalAlignment() {
        return "auto";
    }

    @Override
    public String getJustifyAlignment() {
        return "auto";
    }

    @Override
    public Point getDisplacement() {
        return DEFAULT_DISPLACEMENT;
    }

    public String toString() {
        return "OsmShieldSymbolizerAccessor[" + this.osmShieldSymbolizer + "]";
    }
}

