/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmPolygonSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmRule;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmPolygonSymbolizerAccessor
extends BaseAccessor {
    public static final Color DEFAULT_FILL = Color.GRAY;
    public static final float DEFAULT_OPACITY = 1.0f;
    public static final float DEFAULT_GAMMA = 1.0f;
    public static final boolean DEFAULT_USE_CLOSED_LINES = false;
    public static final boolean DEFAULT_SHADOW = false;
    public static final Color DEFAULT_SHADOW_COLOR = Color.BLACK;
    public static final int DEFAULT_SHADOW_DIRECTION = 135;
    public static final int DEFAULT_SHADOW_OFFSET = 3;
    public static final int DEFAULT_SHADOW_RADIUS = 5;
    private OsmPolygonSymbolizer osmPolygonSymbolizer;
    private Color cachedFill = null;
    private Float cachedFillOpacity = null;
    private Float cachedGamma = null;
    private Boolean cachedUseClosedLines = null;
    private Boolean cachedShadow = null;
    private Color cachedShadowColor = null;
    private Integer cachedShadowDirection = null;
    private Integer cachedShadowOffset = null;
    private Integer cachedShadowRadius = null;

    public OsmPolygonSymbolizerAccessor(OsmPolygonSymbolizer osmPolygonSymbolizer) {
        this.osmPolygonSymbolizer = osmPolygonSymbolizer;
    }

    public OsmPolygonSymbolizer getOsmPolygonSymbolizer() {
        return this.osmPolygonSymbolizer;
    }

    public Color getFill() {
        if (this.cachedFill == null) {
            Optional<String> optionalFill = this.safeGetNonEmptyString(this.osmPolygonSymbolizer.getFill());
            this.cachedFill = optionalFill.isPresent() ? ColorUtil.getColorFromString(optionalFill.get()) : DEFAULT_FILL;
        }
        return this.cachedFill;
    }

    public OsmRule getParent() {
        return this.osmPolygonSymbolizer.getParent();
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmPolygonSymbolizer.getIdentifier());
    }

    public Float getFillOpacity() {
        if (this.cachedFillOpacity == null) {
            this.cachedFillOpacity = this.getFromOptionalOrElse(this.safeParseFloat(this.osmPolygonSymbolizer.getFillOpacity()), 1.0f);
        }
        return this.cachedFillOpacity;
    }

    public Float getGamma() {
        if (this.cachedGamma == null) {
            this.cachedGamma = this.getFromOptionalOrElse(this.safeParseFloat(this.osmPolygonSymbolizer.getGamma()), 1.0f);
        }
        return this.cachedGamma;
    }

    public Boolean getUseClosedLines() {
        if (this.cachedUseClosedLines == null) {
            this.cachedUseClosedLines = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmPolygonSymbolizer.getUseClosedLines()), false);
        }
        return this.cachedUseClosedLines;
    }

    public Boolean getShadow() {
        if (this.cachedShadow == null) {
            this.cachedShadow = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmPolygonSymbolizer.getShadow()), false);
        }
        return this.cachedShadow;
    }

    public Color getShadowColor() {
        if (this.cachedShadowColor == null) {
            Optional<String> optionalColor = this.safeGetNonEmptyString(this.osmPolygonSymbolizer.getShadowColor());
            this.cachedShadowColor = optionalColor.isPresent() ? ColorUtil.getColorFromString(optionalColor.get()) : DEFAULT_SHADOW_COLOR;
        }
        return this.cachedShadowColor;
    }

    public Integer getShadowDirection() {
        if (this.cachedShadowDirection == null) {
            this.cachedShadowDirection = this.getFromOptionalOrElse(this.safeParseInteger(this.osmPolygonSymbolizer.getShadowDirection()), 135);
        }
        return this.cachedShadowDirection;
    }

    public Integer getShadowOffset() {
        if (this.cachedShadowOffset == null) {
            this.cachedShadowOffset = this.getFromOptionalOrElse(this.safeParseInteger(this.osmPolygonSymbolizer.getShadowOffset()), 3);
        }
        return this.cachedShadowOffset;
    }

    public Integer getShadowRadius() {
        if (this.cachedShadowRadius == null) {
            this.cachedShadowRadius = this.getFromOptionalOrElse(this.safeParseInteger(this.osmPolygonSymbolizer.getShadowRadius()), 5);
        }
        return this.cachedShadowRadius;
    }

    public String toString() {
        return "OsmPolygonSymbolizerAccessor[" + this.osmPolygonSymbolizer + "]";
    }
}

