/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmMarkersSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmRule;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmMarkersSymbolizerAccessor
extends BaseAccessor {
    public static final double DEFAULT_WIDTH = 14.0;
    public static final double DEFAULT_HEIGHT = 14.0;
    public static final Color DEFAULT_FILL = Color.BLUE;
    public static final Color DEFAULT_STROKE = Color.BLACK;
    public static final float DEFAULT_STROKE_WIDTH = 1.0f;
    public static final float DEFAULT_OPACITY = 1.0f;
    public static final boolean DEFAULT_ALLOW_OVERLAP = false;
    public static final boolean DEFAULT_IGNORE_PLACEMENT = false;
    public static final double DEFAULT_SPACING = 100.0;
    private OsmMarkersSymbolizer osmMarkersSymbolizer;
    private Double cachedWidth = null;
    private Double cachedHeight = null;
    private Color cachedFill = null;
    private Color cachedStroke = null;
    private Boolean cachedAllowOverlap = null;
    private Boolean cachedIgnorePlacement = null;
    private Float cachedStrokeWidth = null;
    private Float cachedOpacity = null;
    private Float cachedStrokeOpacity = null;
    private Boolean cachedIsWidthSet = null;
    private Boolean cachedIsHeightSet = null;
    private Boolean cachedIsFillSet = null;
    private Boolean cachedIsStrokeSet = null;
    private Double cachedSpacing = null;

    public OsmMarkersSymbolizerAccessor(OsmMarkersSymbolizer osmMarkersSymbolizer) {
        this.osmMarkersSymbolizer = osmMarkersSymbolizer;
    }

    public OsmMarkersSymbolizer getOsmMarkersSymbolizer() {
        return this.osmMarkersSymbolizer;
    }

    public Double getWidth() {
        if (this.cachedWidth == null) {
            this.cachedWidth = this.getFromOptionalOrElse(this.safeParseDouble(this.osmMarkersSymbolizer.getWidth()), 14.0);
        }
        return this.cachedWidth;
    }

    public Double getHeight() {
        if (this.cachedHeight == null) {
            this.cachedHeight = this.getFromOptionalOrElse(this.safeParseDouble(this.osmMarkersSymbolizer.getHeight()), 14.0);
        }
        return this.cachedHeight;
    }

    public Double getSpacing() {
        if (this.cachedSpacing == null) {
            this.cachedSpacing = this.getFromOptionalOrElse(this.safeParseDouble(this.osmMarkersSymbolizer.getSpacing()), 100.0);
        }
        return this.cachedSpacing;
    }

    public Color getFill() {
        if (this.cachedFill == null) {
            Optional<String> optionalFill = this.safeGetNonEmptyString(this.osmMarkersSymbolizer.getFill());
            this.cachedFill = optionalFill.isPresent() ? ColorUtil.getColorFromString(optionalFill.get()) : DEFAULT_FILL;
        }
        return this.cachedFill;
    }

    public Boolean getAllowOverlap() {
        if (this.cachedAllowOverlap == null) {
            this.cachedAllowOverlap = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmMarkersSymbolizer.getAllowOverlap()), false);
        }
        return this.cachedAllowOverlap;
    }

    public Boolean getIgnorePlacement() {
        if (this.cachedIgnorePlacement == null) {
            this.cachedIgnorePlacement = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmMarkersSymbolizer.getIgnorePlacement()), false);
        }
        return this.cachedIgnorePlacement;
    }

    public Float getStrokeWidth() {
        if (this.cachedStrokeWidth == null) {
            this.cachedStrokeWidth = this.getFromOptionalOrElse(this.safeParseFloat(this.osmMarkersSymbolizer.getStrokeWidth()), 1.0f);
        }
        return this.cachedStrokeWidth;
    }

    public OsmRule getParent() {
        return this.osmMarkersSymbolizer.getParent();
    }

    public Optional<String> getFile() {
        return this.safeGetNonEmptyString(this.osmMarkersSymbolizer.getFile());
    }

    public Float getOpacity() {
        if (this.cachedOpacity == null) {
            this.cachedOpacity = this.getFromOptionalOrElse(this.safeParseFloat(this.osmMarkersSymbolizer.getOpacity()), 1.0f);
        }
        return this.cachedOpacity;
    }

    public Optional<String> getMarkerType() {
        return this.safeGetNonEmptyString(this.osmMarkersSymbolizer.getMarkerType());
    }

    public Color getStroke() {
        if (this.cachedStroke == null) {
            Optional<String> optionalStroke = this.safeGetNonEmptyString(this.osmMarkersSymbolizer.getStroke());
            this.cachedStroke = optionalStroke.isPresent() ? ColorUtil.getColorFromString(optionalStroke.get()) : DEFAULT_STROKE;
        }
        return this.cachedStroke;
    }

    public Float getStrokeOpacity() {
        if (this.cachedStrokeOpacity == null) {
            this.cachedStrokeOpacity = this.getFromOptionalOrElse(this.safeParseFloat(this.osmMarkersSymbolizer.getStrokeOpacity()), 1.0f);
        }
        return this.cachedStrokeOpacity;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmMarkersSymbolizer.getIdentifier());
    }

    public Boolean isWidthSet() {
        if (this.cachedIsWidthSet == null) {
            this.cachedIsWidthSet = this.isStringNotNullNotEmpty(this.osmMarkersSymbolizer.getWidth());
        }
        return this.cachedIsWidthSet;
    }

    public Boolean isHeightSet() {
        if (this.cachedIsHeightSet == null) {
            this.cachedIsHeightSet = this.isStringNotNullNotEmpty(this.osmMarkersSymbolizer.getHeight());
        }
        return this.cachedIsHeightSet;
    }

    public Boolean isFillSet() {
        if (this.cachedIsFillSet == null) {
            this.cachedIsFillSet = this.isStringNotNullNotEmpty(this.osmMarkersSymbolizer.getFill());
        }
        return this.cachedIsFillSet;
    }

    public Boolean isStrokeSet() {
        if (this.cachedIsStrokeSet == null) {
            this.cachedIsStrokeSet = this.isStringNotNullNotEmpty(this.osmMarkersSymbolizer.getStroke());
        }
        return this.cachedIsStrokeSet;
    }

    public String toString() {
        return "OsmMarkersSymbolizerAccessor[" + this.osmMarkersSymbolizer + "]";
    }
}

