/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.RenderConfigurationJob;
import de.wideportal.maprender.config.xml.osm.OsmFontSet;
import de.wideportal.maprender.config.xml.osm.OsmLayer;
import de.wideportal.maprender.config.xml.osm.OsmMap;
import de.wideportal.maprender.config.xml.osm.OsmParameters;
import de.wideportal.maprender.config.xml.osm.OsmStyle;
import de.wideportal.maprender.config.xml.osm.OsmXmlUtil;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.List;
import java.util.Optional;

public class OsmMapAccessor
extends BaseAccessor {
    public static final Color DEFAULT_BACKGROUND_COLOR = ColorUtil.COLOR_TRANSPARENT;
    private OsmMap osmMap;
    private Color cachedBackgroundColor = null;

    public OsmMapAccessor(OsmMap osmMap) {
        this.osmMap = osmMap;
    }

    public OsmMap getOsmMap() {
        return this.osmMap;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmMap.getIdentifier());
    }

    public Optional<String> getSrs() {
        return Optional.ofNullable(this.osmMap.getSrs());
    }

    public Color getBackgroundColor() {
        if (this.cachedBackgroundColor == null) {
            Optional<String> optionalFill = this.safeGetNonEmptyString(this.osmMap.getBackgroundColor());
            this.cachedBackgroundColor = optionalFill.isPresent() ? ColorUtil.getColorFromString(optionalFill.get()) : DEFAULT_BACKGROUND_COLOR;
        }
        return this.cachedBackgroundColor;
    }

    public RenderConfigurationJob getJob() {
        return this.osmMap.getJob();
    }

    public OsmParameters getParameters() {
        return this.osmMap.getParameters();
    }

    public List<OsmFontSet> getFontSets() {
        return this.osmMap.getFontSets();
    }

    public List<OsmStyle> getStyles() {
        return this.osmMap.getStyles();
    }

    public List<OsmLayer> getLayers() {
        return this.osmMap.getLayers();
    }

    public Optional<OsmStyle> findStyle(String name) {
        return OsmXmlUtil.findStyle(this.osmMap.getStyles(), name);
    }

    public Optional<OsmFontSet> findFontSet(Optional<String> name) {
        return OsmXmlUtil.findFontSet(this.osmMap.getFontSets(), name);
    }

    public String toString() {
        return "OsmMapAccessor[" + this.osmMap.toString() + "]";
    }
}

