/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmHeightFakeDepthSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmHeightFakeDepthSymbolizerAccessor
extends BaseAccessor {
    public static final Double DEFAULT_SUNRAY_DIRECTION_CLOCKWISE = 90.0;
    public static final Double DEFAULT_SHADOW_BASE_INTENSITY = 1.0;
    public static final Integer DEFAULT_SHADOW_FUZZY_RADIUS = 5;
    public static final Float DEFAULT_SHADOW_SUN_HEIGHT_DEGREE = Float.valueOf(35.0f);
    public static final Integer DEFAULT_SUNRAY_DAMPENING = 10;
    public static final Color DEFAULT_COLOR = Color.BLACK;
    private OsmHeightFakeDepthSymbolizer osmHeightFakeDepthSymbolizer;
    private Double cachedShadowSunHeightDegree = null;
    private Double cachedSunrayDirectionClockwise = null;
    private Double cachedShadowBaseIntensity = null;
    private Integer cachedShadowFuzzyRadius = null;
    private Integer cachedSunrayDampening = null;
    private Color cachedColor = null;

    public OsmHeightFakeDepthSymbolizerAccessor(OsmHeightFakeDepthSymbolizer osmHeightFakeDepthSymbolizer) {
        this.osmHeightFakeDepthSymbolizer = osmHeightFakeDepthSymbolizer;
    }

    public OsmHeightFakeDepthSymbolizer getOsmHeightSurroundReliefSymbolizer() {
        return this.osmHeightFakeDepthSymbolizer;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmHeightFakeDepthSymbolizer.getIdentifier());
    }

    public Double getSunrayDirectionClockwise() {
        if (this.cachedSunrayDirectionClockwise == null) {
            this.cachedSunrayDirectionClockwise = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightFakeDepthSymbolizer.getSunrayDirectionClockwise()), DEFAULT_SUNRAY_DIRECTION_CLOCKWISE);
        }
        return this.cachedSunrayDirectionClockwise;
    }

    public Double getShadowBaseIntensity() {
        if (this.cachedShadowBaseIntensity == null) {
            this.cachedShadowBaseIntensity = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightFakeDepthSymbolizer.getShadowBaseIntensity()), DEFAULT_SHADOW_BASE_INTENSITY);
        }
        return this.cachedShadowBaseIntensity;
    }

    public Integer getShadowFuzzyRadius() {
        if (this.cachedShadowFuzzyRadius == null) {
            this.cachedShadowFuzzyRadius = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightFakeDepthSymbolizer.getShadowFuzzyRadius()), DEFAULT_SHADOW_FUZZY_RADIUS);
        }
        return this.cachedShadowFuzzyRadius;
    }

    public Integer getSunrayDampening() {
        if (this.cachedSunrayDampening == null) {
            this.cachedSunrayDampening = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightFakeDepthSymbolizer.getSunrayDampening()), DEFAULT_SUNRAY_DAMPENING);
        }
        return this.cachedSunrayDampening;
    }

    public Double getShadowSunHeightDegree() {
        if (this.cachedShadowSunHeightDegree == null) {
            this.cachedShadowSunHeightDegree = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightFakeDepthSymbolizer.getShadowSunHeightDegree()), (double)DEFAULT_SHADOW_SUN_HEIGHT_DEGREE.floatValue());
        }
        return this.cachedShadowSunHeightDegree;
    }

    public Color getColor() {
        if (this.cachedColor == null) {
            Optional<String> optionalColor = this.safeGetNonEmptyString(this.osmHeightFakeDepthSymbolizer.getColor());
            this.cachedColor = optionalColor.isPresent() ? ColorUtil.getColorFromString(optionalColor.get()) : DEFAULT_COLOR;
        }
        return this.cachedColor;
    }

    public String toString() {
        return "OsmHeightFakeDepthSymbolizerAccessor[" + this.osmHeightFakeDepthSymbolizer + "]";
    }
}

