/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.geom.Point;
import java.util.Optional;

public abstract class BaseAccessor {
    protected boolean isStringNotNullNotEmpty(String test) {
        return test != null && !test.isBlank();
    }

    public String getFromOptionalOrElse(Optional<String> input, String otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return otherwise;
    }

    public Boolean getFromOptionalOrElse(Optional<Boolean> input, boolean otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return otherwise;
    }

    public Double getFromOptionalOrElse(Optional<Double> input, double otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return otherwise;
    }

    public Float getFromOptionalOrElse(Optional<Float> input, float otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return Float.valueOf(otherwise);
    }

    public Integer getFromOptionalOrElse(Optional<Integer> input, int otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return otherwise;
    }

    public Point getFromOptionalOrElse(Optional<Point> input, Point otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return otherwise;
    }

    protected Optional<String> safeGetNonEmptyString(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    protected Optional<Double> safeParseDouble(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            return Optional.ofNullable(this.parseDouble(value));
        }
        return Optional.empty();
    }

    protected Optional<Float> safeParseFloat(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            return Optional.ofNullable(this.parseFloat(value));
        }
        return Optional.empty();
    }

    protected Optional<Integer> safeParseInteger(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            return Optional.ofNullable(this.parseInteger(value));
        }
        return Optional.empty();
    }

    protected Optional<Boolean> safeParseBoolean(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            return Optional.ofNullable(this.parseBoolean(value));
        }
        return Optional.empty();
    }

    protected Optional<Point> safeParsePoint(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            if (value.startsWith("(") && value.endsWith(")")) {
                value = value.substring(1, value.length() - 1);
                String[] values = value.split(",");
                return Optional.of(new Point(Double.parseDouble(values[0]), Double.parseDouble(values[1])));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    protected Double parseDouble(String value) {
        Double result = null;
        try {
            result = Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    protected Float parseFloat(String value) {
        Float result = null;
        try {
            result = Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    protected Integer parseInteger(String value) {
        Integer result = null;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    protected Boolean parseBoolean(String value) {
        Boolean result = null;
        try {
            result = Boolean.parseBoolean(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }
}

