/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm;

import de.wideportal.maprender.config.xml.osm.OsmFontSet;
import de.wideportal.maprender.config.xml.osm.OsmParameter;
import de.wideportal.maprender.config.xml.osm.OsmStyle;
import java.util.List;
import java.util.Optional;

public class OsmXmlUtil {
    public static Optional<OsmParameter> findParameter(List<OsmParameter> parameters, String name) {
        if (name == null) {
            return Optional.empty();
        }
        for (OsmParameter parameter : parameters) {
            if (!name.equalsIgnoreCase(parameter.getName())) continue;
            return Optional.of(parameter);
        }
        return Optional.empty();
    }

    public static Optional<OsmStyle> findStyle(List<OsmStyle> styles, String name) {
        if (name == null) {
            return Optional.empty();
        }
        for (OsmStyle style : styles) {
            if (!name.equalsIgnoreCase(style.getName())) continue;
            return Optional.of(style);
        }
        return Optional.empty();
    }

    public static Optional<OsmFontSet> findFontSet(List<OsmFontSet> fontSets, Optional<String> name) {
        if (!name.isPresent()) {
            return Optional.empty();
        }
        for (OsmFontSet fontSet : fontSets) {
            if (!name.get().equalsIgnoreCase(fontSet.getName())) continue;
            return Optional.of(fontSet);
        }
        return Optional.empty();
    }
}

