/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config;

import de.wideportal.maprender.config.ConfigurationException;
import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.RenderConfigurationJob;
import de.wideportal.maprender.config.xml.RenderConfigurationJobs;
import de.wideportal.maprender.config.xml.RenderConfigurationMaprender;
import de.wideportal.maprender.config.xml.osm.OsmFontSet;
import de.wideportal.maprender.config.xml.osm.OsmLayer;
import de.wideportal.maprender.config.xml.osm.OsmLinePatternSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmLineSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmMap;
import de.wideportal.maprender.config.xml.osm.OsmMarkersSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmPolygonPatternSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmPolygonSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmRule;
import de.wideportal.maprender.config.xml.osm.OsmShieldSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmStyle;
import de.wideportal.maprender.config.xml.osm.OsmStyleName;
import de.wideportal.maprender.config.xml.osm.OsmTextSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.OsmLayerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmMapAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmStyleAccessor;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLoader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public RenderConfiguration loadConfiguration(String configurationFileString) throws ConfigurationException {
        this.log.info("loadConfiguration: start loading configuration: " + configurationFileString);
        File configurationFile = new File(configurationFileString);
        if (!configurationFile.exists() || configurationFile.isDirectory()) {
            throw new ConfigurationException("Configuration file does not exist: " + configurationFile.getAbsolutePath());
        }
        this.log.info("loadConfiguration: loading configuration from : " + configurationFile.getAbsolutePath());
        RenderConfigurationMaprender maprenderConfiguration = this.unmarshallConfiguration(configurationFile);
        this.log.info("loadConfiguration: Config datasources: " + maprenderConfiguration.getDatasources());
        this.log.info("loadConfiguration: Config datatargets: " + maprenderConfiguration.getDatatargets());
        this.log.info("loadConfiguration: Config processing: " + maprenderConfiguration.getProcessing());
        this.log.info("loadConfiguration: Config server    : " + maprenderConfiguration.getServer());
        this.log.info("loadConfiguration: Config jobs      : " + maprenderConfiguration.getJobs());
        if (maprenderConfiguration.getJobs() != null) {
            for (RenderConfigurationJob job : maprenderConfiguration.getJobs().getJobs()) {
                this.log.info("loadConfiguration:     -> job=" + job);
                this.loadOsmConfiguration(job);
                OsmMap osmMap = job.getOsmMap();
                this.log.info("loadConfiguration:         -> osmMap=" + osmMap);
                this.log.debug("loadConfiguration: Config:     " + osmMap.getParameters());
                for (OsmFontSet fontSet : osmMap.getFontSets()) {
                    this.log.debug("loadConfiguration: Config:     " + fontSet);
                }
                for (OsmStyle rawStyle : osmMap.getStyles()) {
                    this.log.debug("loadConfiguration: Config:     " + rawStyle);
                    OsmStyleAccessor style = rawStyle.getAccessor();
                    for (OsmRule rule : style.getRules()) {
                        this.log.debug("loadConfiguration: Config:         " + rule);
                    }
                }
                for (OsmLayer rawLayer : osmMap.getLayers()) {
                    this.log.debug("loadConfiguration: Config:     " + rawLayer);
                    OsmLayerAccessor layer = rawLayer.getAccessor();
                    for (OsmStyleName styleName : layer.getStyleNames()) {
                        this.log.debug("loadConfiguration: Config:         " + styleName);
                    }
                }
            }
            this.internallyLinkOsmConfigurations(maprenderConfiguration.getJobs());
            this.generateRuleFilters(maprenderConfiguration.getJobs());
            this.fillParentReferences(maprenderConfiguration.getJobs());
            this.preCheckLayersForCollisionElements(maprenderConfiguration.getJobs());
        } else {
            this.log.warn("loadConfiguration: no jobs configured. Please check your configuration. No rendering will be performed!");
        }
        RenderConfiguration newConfiguration = new RenderConfiguration(maprenderConfiguration);
        this.log.info("loadConfiguration: finished loading configuration");
        return newConfiguration;
    }

    private void preCheckLayersForCollisionElements(RenderConfigurationJobs jobs) {
        this.log.info("preCheckLayersForCollisionElements: start prechecking layers");
        for (RenderConfigurationJob job : jobs.getJobs()) {
            OsmMap osmMap = job.getOsmMap();
            for (OsmLayer layer : osmMap.getLayers()) {
                boolean hasCollisionElements = false;
                block2: for (OsmStyle style : layer.getStyles()) {
                    if (hasCollisionElements) break;
                    for (OsmRule rule : style.getRules()) {
                        if (hasCollisionElements) continue block2;
                        if (rule.getTextSymbolizers().size() > 0) {
                            hasCollisionElements = true;
                            continue block2;
                        }
                        if (rule.getShieldSymbolizers().size() > 0) {
                            hasCollisionElements = true;
                            continue block2;
                        }
                        if (rule.getMarkersSymbolizers().size() <= 0) continue;
                        hasCollisionElements = true;
                        continue block2;
                    }
                }
                layer.setHasCollisionElements(hasCollisionElements);
            }
        }
        this.log.info("preCheckLayersForCollisionElements: finished prechecking layers");
    }

    private RenderConfigurationMaprender unmarshallConfiguration(File configurationFile) throws ConfigurationException {
        this.log.info("unmarshallConfiguration: " + configurationFile);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RenderConfigurationMaprender.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            RenderConfigurationMaprender renderConfigurationMaprender = (RenderConfigurationMaprender)jaxbUnmarshaller.unmarshal(configurationFile);
            this.log.info("unmarshallConfiguration: successfully unmashalled config: " + renderConfigurationMaprender);
            return renderConfigurationMaprender;
        }
        catch (Exception e) {
            this.log.error("unmarshallConfiguration: could not unmarshal configuration", (Throwable)e);
            throw new ConfigurationException("Could not read the content of the configuration file: " + e.getMessage());
        }
    }

    private void internallyLinkOsmConfigurations(RenderConfigurationJobs jobs) {
        this.log.debug("internallyLinkOsmConfigurations: start linking");
        for (RenderConfigurationJob job : jobs.getJobs()) {
            OsmMapAccessor osmMap = job.getOsmMap().getAccessor();
            for (OsmLayer osmLayer : osmMap.getLayers()) {
                ArrayList<OsmStyle> referencedStyles = new ArrayList<OsmStyle>();
                for (OsmStyleName osmStyleName : osmLayer.getStyleNames()) {
                    Optional<OsmStyle> style = osmMap.findStyle(osmStyleName.getValue());
                    if (style.isPresent()) {
                        referencedStyles.add(style.get());
                        continue;
                    }
                    this.log.warn("internallyLinkOsmConfigurations: possible inconsistency detected. Layer " + osmLayer.getName() + " points to a nonexisting style " + osmStyleName.getValue());
                }
                osmLayer.setStyles(referencedStyles);
                this.log.debug("internallyLinkOsmConfigurations: added styles to layer " + osmLayer.getName() + ": " + referencedStyles);
            }
        }
        this.log.debug("internallyLinkOsmConfigurations: finished linking");
    }

    private void generateRuleFilters(RenderConfigurationJobs jobs) {
        this.log.info("generateRuleFilters: start generating rule filters");
        int ruleFilterCounter = 0;
        for (RenderConfigurationJob job : jobs.getJobs()) {
            OsmMap osmMap = job.getOsmMap();
            for (OsmLayer osmLayer : osmMap.getLayers()) {
                for (OsmStyle osmStyle : osmLayer.getStyles()) {
                    for (OsmRule osmRule : osmStyle.getRules()) {
                        OsmRuleFilter ruleFilter = new OsmRuleFilter(osmStyle.getFilterMode(), osmRule);
                        ruleFilter.buildFilter();
                        osmRule.setRuleFilter(ruleFilter);
                        ++ruleFilterCounter;
                    }
                }
            }
        }
        this.log.info("generateRuleFilters: finished generating rule filters: #" + ruleFilterCounter);
    }

    private void loadOsmConfiguration(RenderConfigurationJob job) throws ConfigurationException {
        OsmMap osmMap = this.unmarshallOsmConfiguration(job.getConfiguration());
        osmMap.setJob(job);
        job.setOsmMap(osmMap);
    }

    private OsmMap unmarshallOsmConfiguration(String configurationFileString) throws ConfigurationException {
        this.log.info("unmarshallOsmConfiguration: start loading configuration: " + configurationFileString);
        File configurationFile = new File(configurationFileString);
        if (!configurationFile.exists() || configurationFile.isDirectory()) {
            throw new ConfigurationException("OSM Configuration file does not exist: " + configurationFileString);
        }
        this.log.info("unmarshallOsmConfiguration: loading configuration from : " + configurationFile.getAbsolutePath());
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OsmMap.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            OsmMap osmMap = (OsmMap)jaxbUnmarshaller.unmarshal(configurationFile);
            this.log.debug("unmarshallOsmConfiguration: successfully unmashalled config: " + osmMap);
            return osmMap;
        }
        catch (Exception e) {
            this.log.error("unmarshallOsmConfiguration: could not unmarshal configuration", (Throwable)e);
            throw new ConfigurationException("Could not read the content of the configuration file: " + e.getMessage());
        }
    }

    private void fillParentReferences(RenderConfigurationJobs jobs) {
        this.log.info("fillParentReferences: start linking of parent references");
        for (RenderConfigurationJob job : jobs.getJobs()) {
            OsmMap osmMap = job.getOsmMap();
            for (OsmStyle style : osmMap.getStyles()) {
                style.setParent(osmMap);
                for (OsmRule rawRule : style.getRules()) {
                    rawRule.setParent(style);
                    OsmRuleAccessor rule = rawRule.getAccessor();
                    for (OsmPolygonPatternSymbolizer osmPolygonPatternSymbolizer : rule.getPolygonPatternSymbolizers()) {
                        osmPolygonPatternSymbolizer.setParent(rawRule);
                    }
                    for (OsmPolygonSymbolizer osmPolygonSymbolizer : rule.getPolygonSymbolizers()) {
                        osmPolygonSymbolizer.setParent(rawRule);
                    }
                    for (OsmLineSymbolizer osmLineSymbolizer : rule.getLineSymbolizers()) {
                        osmLineSymbolizer.setParent(rawRule);
                    }
                    for (OsmMarkersSymbolizer osmMarkersSymbolizer : rule.getMarkersSymbolizers()) {
                        osmMarkersSymbolizer.setParent(rawRule);
                    }
                    for (OsmShieldSymbolizer osmShieldSymbolizer : rule.getShieldSymbolizers()) {
                        osmShieldSymbolizer.setParent(rawRule);
                    }
                    for (OsmTextSymbolizer osmTextSymbolizer : rule.getTextSymbolizers()) {
                        osmTextSymbolizer.setParent(rawRule);
                    }
                    for (OsmLinePatternSymbolizer osmLinePatternSymbolizer : rule.getLinePatternSymbolizers()) {
                        osmLinePatternSymbolizer.setParent(rawRule);
                    }
                }
            }
        }
        this.log.info("fillParentReferences: finished linking of parent references");
    }
}

