/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.proj;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PROJRefiner {
    private static final String REFINEMENTS_FILE = "PROJRefinements.txt";
    private Properties properties = new Properties();
    private String globalAdditions = "";
    private Map<String, List<Refinement>> epsgRefinements;
    private List<Refinement> unitRefinements;
    private List<String> projKeysOrder = new ArrayList<String>();

    public PROJRefiner() {
        this.unitRefinements = new ArrayList<Refinement>();
        this.epsgRefinements = new HashMap<String, List<Refinement>>();
        URL aliasURL = PROJRefiner.class.getResource(REFINEMENTS_FILE);
        try (InputStream input = aliasURL.openStream();){
            String order;
            this.properties.load(input);
            if (this.properties.containsKey("global.additions")) {
                this.globalAdditions = this.properties.getProperty("global.additions");
            }
            if ((order = this.properties.getProperty("proj.order")) != null) {
                this.projKeysOrder.addAll(Arrays.asList(order.split(",")));
            }
            this.loadUnitRefinements();
            this.loadRefinements();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadUnitRefinements() {
        HashMap<String, String> regexMap = new HashMap<String, String>();
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        for (String key : this.properties.stringPropertyNames()) {
            if (key.startsWith("unit.regex.")) {
                regexMap.put(key.substring(11), this.properties.getProperty(key));
                continue;
            }
            if (!key.startsWith("unit.replacement.")) continue;
            replacementMap.put(key.substring(17), this.properties.getProperty(key));
        }
        for (String id : regexMap.keySet()) {
            String regex = (String)regexMap.get(id);
            String replacement = (String)replacementMap.get(id);
            this.unitRefinements.add(new Refinement(regex, replacement));
        }
    }

    private void loadRefinements() {
        HashMap<Integer, String> regexMap = new HashMap<Integer, String>();
        HashMap<Integer, String> replacementMap = new HashMap<Integer, String>();
        HashMap<Integer, String> codesMap = new HashMap<Integer, String>();
        for (String key : this.properties.stringPropertyNames()) {
            if (key.startsWith("regex.")) {
                regexMap.put(Integer.valueOf(key.substring(6)), this.properties.getProperty(key));
                continue;
            }
            if (key.startsWith("replacement.")) {
                replacementMap.put(Integer.valueOf(key.substring(12)), this.properties.getProperty(key));
                continue;
            }
            if (!key.startsWith("codes.")) continue;
            codesMap.put(Integer.valueOf(key.substring(6)), this.properties.getProperty(key));
        }
        ArrayList sortedKeys = new ArrayList(regexMap.keySet());
        Collections.sort(sortedKeys);
        Iterator iterator = sortedKeys.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            String regex = (String)regexMap.get(id);
            String replacement = (String)replacementMap.get(id);
            String codes = (String)codesMap.get(id);
            if (regex == null || replacement == null || codes == null) continue;
            List<String> epsgCodes = this.parseCodes(codes);
            for (String code : epsgCodes) {
                this.epsgRefinements.computeIfAbsent(code, k -> new ArrayList()).add(new Refinement(regex, replacement));
            }
        }
    }

    private List<String> parseCodes(String codes) {
        String[] codeParts;
        ArrayList<String> result = new ArrayList<String>();
        for (String part : codeParts = codes.split(",")) {
            if (part.contains("-")) {
                String[] range = part.split("-");
                int start = Integer.parseInt(range[0]);
                int end = Integer.parseInt(range[1]);
                for (int i = start; i <= end; ++i) {
                    result.add(String.valueOf(i));
                }
                continue;
            }
            result.add(part);
        }
        return result;
    }

    public String refine(String projString, String epsgCode) {
        StringBuilder updatedProjString = new StringBuilder(this.sortProjString(projString));
        updatedProjString.append(" " + this.globalAdditions);
        for (Refinement refinement : this.unitRefinements) {
            Matcher matcher = refinement.pattern.matcher(updatedProjString);
            updatedProjString = new StringBuilder(matcher.replaceAll(refinement.replacement));
        }
        List<Refinement> refinements = this.epsgRefinements.get(epsgCode);
        if (refinements != null) {
            for (Refinement refinement : refinements) {
                Matcher matcher = refinement.pattern.matcher(updatedProjString);
                updatedProjString = new StringBuilder(matcher.replaceAll(refinement.replacement));
            }
        }
        return this.sortProjString(updatedProjString.toString().replaceAll("\\s+", " "));
    }

    private String sortProjString(String projString) {
        String[] components;
        LinkedHashMap<String, String> projComponents = new LinkedHashMap<String, String>();
        for (String component : components = projString.trim().split("\\s+")) {
            if (component.contains("=")) {
                String[] pair = component.split("=");
                projComponents.put(pair[0], pair[1]);
                continue;
            }
            projComponents.put(component, null);
        }
        StringBuilder sortedProjString = new StringBuilder();
        for (String key : this.projKeysOrder) {
            if (!projComponents.containsKey("+" + key)) continue;
            sortedProjString.append("+").append(key);
            String value = (String)projComponents.get("+" + key);
            if (value != null) {
                sortedProjString.append("=").append(value);
            }
            sortedProjString.append(" ");
        }
        for (String key : projComponents.keySet()) {
            if (this.projKeysOrder.contains(key.substring(1))) continue;
            sortedProjString.append(key).append("=").append((String)projComponents.get(key)).append(" ");
        }
        return sortedProjString.toString().trim();
    }

    private static class Refinement {
        String regex;
        String replacement;
        Pattern pattern;

        Refinement(String regex, String replacement) {
            this.regex = regex;
            this.replacement = replacement;
            this.pattern = Pattern.compile(regex);
        }
    }
}

