/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.ConicProjection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.projection.LambertConformal1SP;
import org.geotools.referencing.operation.projection.LambertConformal2SP;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.util.Utilities;
import si.uom.NonSI;

public class LambertConformalEsriProvider
extends MapProjection.AbstractProvider {
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL_1 = LambertConformalEsriProvider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(Citations.ESRI, "Standard_Parallel_1"), new NamedIdentifier(Citations.ESRI, "standard_parallel_1"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel1"), new NamedIdentifier(Citations.PROJ, "lat_1")}, -90.0, 90.0, NonSI.DEGREE_ANGLE);
    static final ParameterDescriptorGroup PARAMETERS = LambertConformalEsriProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Lambert_Conformal_Conic"), new NamedIdentifier(Citations.ESRI, "Lambert_Conformal_Conic_2SP")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, FALSE_EASTING, FALSE_NORTHING, SCALE_FACTOR});

    public LambertConformalEsriProvider() {
        super(PARAMETERS);
    }

    public Class<ConicProjection> getOperationType() {
        return ConicProjection.class;
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
        boolean hasStdParallel1 = LambertConformalEsriProvider.getParameter(STANDARD_PARALLEL_1, parameters) != null;
        double stdParallel1 = MathTransformProvider.doubleValue(STANDARD_PARALLEL_1, parameters);
        boolean hasStdParallel2 = LambertConformalEsriProvider.getParameter(STANDARD_PARALLEL_2, parameters) != null;
        double stdParallel2 = MathTransformProvider.doubleValue(STANDARD_PARALLEL_2, parameters);
        boolean hasLatitudeOfOrigin = LambertConformalEsriProvider.getParameter(LATITUDE_OF_ORIGIN, parameters) != null;
        double latitudeOfOrigin = MathTransformProvider.doubleValue(LATITUDE_OF_ORIGIN, parameters);
        if (!hasStdParallel1 && !hasStdParallel2 && hasLatitudeOfOrigin) {
            return new LambertConformal1SP(parameters);
        }
        if (hasStdParallel1 && hasStdParallel2 && hasLatitudeOfOrigin && Utilities.equals((double)stdParallel1, (double)stdParallel2) && Utilities.equals((double)stdParallel1, (double)latitudeOfOrigin)) {
            return new LambertConformal1SP(parameters);
        }
        if (!hasStdParallel2 && hasStdParallel1 && Utilities.equals((double)stdParallel1, (double)latitudeOfOrigin)) {
            return new LambertConformal1SP(parameters);
        }
        ParameterValue<Double> sp1 = LambertConformalEsriProvider.getParameter(STANDARD_PARALLEL_1, parameters);
        ParameterValue sp2 = LambertConformalEsriProvider.getParameter(STANDARD_PARALLEL_2, parameters);
        if (sp1 != null && sp2 != null && sp1.doubleValue() < sp2.doubleValue()) {
            double temp = sp1.doubleValue();
            sp1.setValue(sp2.doubleValue());
            sp2.setValue(temp);
        }
        return new LambertConformal2SP(parameters);
    }
}

