/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.MismatchedReferenceSystemException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.referencing.operation.builder.AffineToGeometric;
import org.geotools.referencing.operation.builder.AffineTransformBuilder;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.MathTransformBuilder;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;

public class AdvancedAffineBuilder
extends MathTransformBuilder {
    public static final String SX = "sx";
    public static final String SY = "sy";
    public static final String SXY = "sxy";
    public static final String PHIX = "phix";
    public static final String PHIY = "phiy";
    public static final String TX = "tx";
    public static final String TY = "ty";
    private double tx;
    private double ty;
    private double sx;
    private double sy;
    private double phix;
    private double phiy;
    private double dif = 1.0E-7;
    private int steps = 100;
    private Map<String, Double> valueConstrain = new HashMap<String, Double>();
    private final AffineTransform2D affineTrans;

    public AdvancedAffineBuilder(List<MappedPosition> vectors) throws IllegalArgumentException, MismatchedDimensionException, MismatchedReferenceSystemException, FactoryException {
        this(vectors, (AffineTransform2D)new AffineTransformBuilder(vectors).getMathTransform());
    }

    public AdvancedAffineBuilder(List<MappedPosition> vectors, AffineTransform2D affineTrans) throws IllegalArgumentException, MismatchedDimensionException, MismatchedReferenceSystemException, FactoryException {
        super.setMappedPositions(vectors);
        this.affineTrans = affineTrans;
        AffineToGeometric a2g = new AffineToGeometric(affineTrans);
        this.sx = a2g.getXScale();
        this.sy = a2g.getYScale();
        this.phix = a2g.getXRotation();
        this.phiy = a2g.getYRotation();
        this.tx = a2g.getXTranslate();
        this.ty = a2g.getYTranslate();
    }

    public void setConstrain(String param, double value) {
        this.valueConstrain.put(param, value);
    }

    public void clearConstrains() {
        this.valueConstrain.clear();
    }

    protected GeneralMatrix getA() {
        GeneralMatrix A = new GeneralMatrix(2 * this.getMappedPositions().size(), 6);
        double cosphix = Math.cos(this.phix);
        double sinphix = Math.sin(this.phix);
        double cosphiy = Math.cos(this.phiy);
        double sinphiy = Math.sin(this.phiy);
        for (int j = 0; j < A.getNumRow() / 2; ++j) {
            double x = this.getSourcePoints()[j].getOrdinate(0);
            double y = this.getSourcePoints()[j].getOrdinate(1);
            double dxsx = cosphix * x;
            double dxsy = -sinphiy * y;
            double dxphix = -this.sx * sinphix * x;
            double dxphiy = -this.sy * cosphiy * y;
            double dxtx = 1.0;
            double dxty = 0.0;
            double dysx = sinphix * x;
            double dysy = cosphiy * y;
            double dyphix = this.sx * cosphix * x;
            double dyphiy = -this.sy * sinphiy * y;
            double dytx = 0.0;
            double dyty = 1.0;
            A.setRow(j, dxsx, dxsy, dxphix, dxphiy, dxtx, dxty);
            A.setRow(A.getNumRow() / 2 + j, dysx, dysy, dyphix, dyphiy, dytx, dyty);
        }
        return A;
    }

    protected GeneralMatrix getL() {
        GeneralMatrix l = new GeneralMatrix(2 * this.getMappedPositions().size(), 1);
        double cosphix = Math.cos(this.phix);
        double sinphix = Math.sin(this.phix);
        double cosphiy = Math.cos(this.phiy);
        double sinphiy = Math.sin(this.phiy);
        for (int j = 0; j < l.getNumRow() / 2; ++j) {
            double x = this.getSourcePoints()[j].getOrdinate(0);
            double y = this.getSourcePoints()[j].getOrdinate(1);
            double dx = this.getTargetPoints()[j].getOrdinate(0) - (this.sx * cosphix * x - this.sy * sinphiy * y + this.tx);
            double dy = this.getTargetPoints()[j].getOrdinate(1) - (this.sx * sinphix * x + this.sy * cosphiy * y + this.ty);
            l.setElement(j, 0, dx);
            l.setElement(l.getNumRow() / 2 + j, 0, dy);
        }
        return l;
    }

    private GeneralMatrix getDxMatrix() throws FactoryException {
        return this.getDxMatrix(this.dif, this.steps);
    }

    private GeneralMatrix getDxMatrix(double tolerance, int maxSteps) throws FactoryException {
        GeneralMatrix xNew = new GeneralMatrix(6, 1);
        GeneralMatrix xOld = new GeneralMatrix(6, 1);
        GeneralMatrix dxMatrix = new GeneralMatrix(6, 1);
        GeneralMatrix zero = new GeneralMatrix(6, 1);
        zero.setZero();
        GeneralMatrix xk = new GeneralMatrix(6 + this.valueConstrain.size(), 1);
        int i = 0;
        do {
            xOld.set(new double[]{this.sx, this.sy, this.phix, this.phiy, this.tx, this.ty});
            GeneralMatrix A = this.getA();
            GeneralMatrix l = this.getL();
            GeneralMatrix AT = A.clone();
            AT.transpose();
            GeneralMatrix ATA = new GeneralMatrix(6, 6);
            GeneralMatrix ATl = new GeneralMatrix(6, 1);
            ATA.mul(AT, (Matrix)A);
            ATl.mul(AT, (Matrix)l);
            GeneralMatrix AB = this.createAB(ATA, this.getB());
            AB.invert();
            AB.negate();
            GeneralMatrix AU = this.createAU(ATl, this.getU());
            xk.mul(AB, (Matrix)AU);
            xk.copySubMatrix(0, 0, 6, xk.getNumCol(), 0, 0, dxMatrix);
            dxMatrix.negate();
            xOld.negate();
            xNew.sub(dxMatrix, (Matrix)xOld);
            this.sx = xNew.getElement(0, 0);
            this.sy = xNew.getElement(1, 0);
            this.phix = xNew.getElement(2, 0);
            this.phiy = xNew.getElement(3, 0);
            this.tx = xNew.getElement(4, 0);
            this.ty = xNew.getElement(5, 0);
            if (++i <= maxSteps) continue;
            throw new FactoryException("Calculation of transformation is divergating - try to set proper aproximate values");
        } while (!dxMatrix.equals(zero, tolerance));
        xNew.transpose();
        return xNew;
    }

    @Override
    public int getMinimumPointCount() {
        return 3;
    }

    protected GeneralMatrix getB() {
        GeneralMatrix B = new GeneralMatrix(this.valueConstrain.size(), 6);
        int i = 0;
        if (this.valueConstrain.containsKey(SX)) {
            B.setRow(i, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++i;
        }
        if (this.valueConstrain.containsKey(SY)) {
            B.setRow(i, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0);
            ++i;
        }
        if (this.valueConstrain.containsKey(PHIX)) {
            B.setRow(i, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
            ++i;
        }
        if (this.valueConstrain.containsKey(PHIY)) {
            B.setRow(i, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ++i;
        }
        if (this.valueConstrain.containsKey(TX)) {
            B.setRow(i, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            ++i;
        }
        if (this.valueConstrain.containsKey(TY)) {
            B.setRow(i, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ++i;
        }
        if (this.valueConstrain.containsKey(SXY)) {
            B.setRow(i, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0);
            ++i;
        }
        return B;
    }

    protected GeneralMatrix getU() {
        GeneralMatrix U = new GeneralMatrix(this.valueConstrain.size(), 1);
        int i = 0;
        if (this.valueConstrain.containsKey(SX)) {
            U.setRow(i, -this.sx + this.valueConstrain.get(SX));
            ++i;
        }
        if (this.valueConstrain.containsKey(SY)) {
            U.setRow(i, -this.sy + this.valueConstrain.get(SY));
            ++i;
        }
        if (this.valueConstrain.containsKey(PHIX)) {
            U.setRow(i, -this.phix + this.valueConstrain.get(PHIX));
            ++i;
        }
        if (this.valueConstrain.containsKey(PHIY)) {
            U.setRow(i, -this.phiy + this.valueConstrain.get(PHIY));
            ++i;
        }
        if (this.valueConstrain.containsKey(TX)) {
            U.setRow(i, -this.tx + this.valueConstrain.get(TX));
            ++i;
        }
        if (this.valueConstrain.containsKey(SXY)) {
            U.setRow(i, this.phix - this.phiy + this.valueConstrain.get(SXY));
            ++i;
        } else if (this.valueConstrain.containsKey(TY)) {
            U.setRow(i, -this.ty + this.valueConstrain.get(TY));
            ++i;
        }
        return U;
    }

    private GeneralMatrix createAU(GeneralMatrix ATl, GeneralMatrix U) {
        GeneralMatrix AU = new GeneralMatrix(ATl.getNumRow() + U.getNumRow(), ATl.getNumCol());
        ATl.copySubMatrix(0, 0, ATl.getNumRow(), ATl.getNumCol(), 0, 0, AU);
        U.copySubMatrix(0, 0, U.getNumRow(), U.getNumCol(), ATl.getNumRow(), 0, AU);
        return AU;
    }

    private GeneralMatrix createAB(GeneralMatrix ATA, GeneralMatrix B) {
        GeneralMatrix BT = B.clone();
        BT.transpose();
        GeneralMatrix AAB = new GeneralMatrix(ATA.getNumRow() + B.getNumRow(), ATA.getNumCol() + BT.getNumCol());
        ATA.copySubMatrix(0, 0, ATA.getNumRow(), ATA.getNumCol(), 0, 0, AAB);
        B.copySubMatrix(0, 0, B.getNumRow(), B.getNumCol(), ATA.getNumRow(), 0, AAB);
        BT.copySubMatrix(0, 0, BT.getNumRow(), BT.getNumCol(), 0, ATA.getNumCol(), AAB);
        GeneralMatrix zero = new GeneralMatrix(B.getNumRow(), B.getNumRow());
        zero.setZero();
        zero.copySubMatrix(0, 0, zero.getNumRow(), zero.getNumCol(), B.getNumCol(), B.getNumCol(), AAB);
        return AAB;
    }

    protected GeneralMatrix getProjectiveMatrix() throws FactoryException {
        GeneralMatrix M = new GeneralMatrix(3, 3);
        double[] param = this.getDxMatrix().getElements()[0];
        double a11 = this.sx * Math.cos(this.phix);
        double a12 = -this.sy * Math.sin(this.phiy);
        double a21 = this.sx * Math.sin(this.phix);
        double a22 = this.sy * Math.cos(this.phiy);
        double[] m0 = new double[]{a11, a12, param[4]};
        double[] m1 = new double[]{a21, a22, param[5]};
        double[] m2 = new double[]{0.0, 0.0, 1.0};
        M.setRow(0, m0);
        M.setRow(1, m1);
        M.setRow(2, m2);
        return M;
    }

    @Override
    protected MathTransform computeMathTransform() throws FactoryException {
        if (this.valueConstrain.isEmpty()) {
            return this.affineTrans;
        }
        return ProjectiveTransform.create(this.getProjectiveMatrix());
    }

    public double getMaxIterationDifference() {
        return this.dif;
    }

    public void setMaxIterationDifference(double dif) {
        this.dif = dif;
    }

    public int getNumberOfIterationSteps() {
        return this.steps;
    }

    public void setNumberOfIterationSteps(int steps) {
        this.steps = steps;
    }
}

