/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.gridshift;

import java.io.Serializable;
import java.util.Objects;
import org.geotools.referencing.operation.builder.LocalizationGrid;

public class NADConGridShift
extends LocalizationGrid
implements Serializable {
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private double dx;
    private double dy;

    public NADConGridShift(double xmin, double ymin, double xmax, double ymax, double dx, double dy, int width, int height) {
        super(width, height);
        this.minX = xmin;
        this.maxX = xmax;
        this.minY = ymin;
        this.maxY = ymax;
        this.dx = dx;
        this.dy = dy;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.maxX, this.maxY, this.dx, this.dy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NADConGridShift that = (NADConGridShift)o;
        return Double.compare(that.minX, this.minX) == 0 && Double.compare(that.minY, this.minY) == 0 && Double.compare(that.maxX, this.maxX) == 0 && Double.compare(that.maxY, this.maxY) == 0 && Double.compare(that.dx, this.dx) == 0 && Double.compare(that.dy, this.dy) == 0;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }
}

