/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.awt.RenderingHints;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.cs.CSAuthorityFactory;
import org.geotools.api.referencing.datum.DatumAuthorityFactory;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.AbstractEpsgMediator;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.OrderedAxisAuthorityFactory;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;

public class LongitudeFirstEpsgDecorator
extends DeferredAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
CoordinateOperationAuthorityFactory,
DatumAuthorityFactory {
    public LongitudeFirstEpsgDecorator() {
        this((Hints)null);
    }

    public LongitudeFirstEpsgDecorator(Hints userHints) {
        super(userHints, 40 + LongitudeFirstEpsgDecorator.relativePriority(userHints));
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        this.put(userHints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.put(userHints, Hints.FORCE_STANDARD_AXIS_UNITS);
    }

    private void put(Hints userHints, Hints.Key key) {
        Object value = null;
        if (userHints != null) {
            value = userHints.get((Object)key);
        }
        if (value == null) {
            value = Boolean.FALSE;
        }
        this.hints.put(key, value);
    }

    private static int relativePriority(Hints userHints) {
        try {
            if (Boolean.getBoolean("org.geotools.referencing.forceXY")) {
                return 10;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return -10;
    }

    @Override
    public Citation getAuthority() {
        return Citations.EPSG;
    }

    @Override
    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory factory;
        Hints backingStoreHints = new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, AbstractEpsgMediator.class);
        backingStoreHints.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.FALSE);
        backingStoreHints.put((Object)Hints.FORCE_STANDARD_AXIS_DIRECTIONS, (Object)Boolean.FALSE);
        backingStoreHints.put((Object)Hints.FORCE_STANDARD_AXIS_UNITS, (Object)Boolean.FALSE);
        try {
            factory = (AbstractAuthorityFactory)ReferencingFactoryFinder.getCRSAuthorityFactory("EPSG", backingStoreHints);
        }
        catch (org.geotools.util.factory.FactoryNotFoundException exception) {
            throw new FactoryNotFoundException((Exception)((Object)exception));
        }
        catch (FactoryRegistryException exception) {
            throw new FactoryException((Exception)((Object)exception));
        }
        return new OrderedAxisAuthorityFactory(factory, new Hints(this.hints), null);
    }
}

