/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.URI_Type;
import org.geotools.util.Classes;
import org.geotools.util.Version;

abstract class URI_Parser {
    private static final char AUTHORITY_CODE_SEPARATOR = ':';
    public final String uri;
    public final URI_Type type;
    public final String authority;
    public final Version version;
    public final String code;

    protected URI_Parser(String uri, URI_Type type, String authority, Version version, String code) {
        this.uri = uri;
        this.type = type;
        this.authority = authority;
        this.version = version;
        this.code = code;
    }

    public String getAuthorityCode() {
        return this.authority + ":" + this.code;
    }

    final void logWarningIfTypeMismatch(AuthorityFactory authorityFactory, Class<? extends AuthorityFactory> expected) {
        if (!expected.isAssignableFrom(this.type.type)) {
            LogRecord record = Loggings.format((Level)Level.WARNING, (int)30, (Object)this.uri);
            record.setSourceClassName(authorityFactory.getClass().getName());
            record.setSourceMethodName("get" + Classes.getShortName(expected));
            Logger logger = AbstractAuthorityFactory.LOGGER;
            record.setLoggerName(logger.getName());
            logger.log(record);
        }
    }

    public String toString() {
        return this.uri;
    }
}

