/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public abstract class DateUtil {
    private static final int MSPERMINUTE = 60000;
    private static final int MSPERHOUR = 3600000;
    private static final int MSPERDAY = 86400000;
    private static final long LMSPERDAY = 86400000L;
    private static final long MSPERYEAR = 31536000000L;
    private static final long MSPERAVGYEAR = 31557600000L;
    private static final long MSPERCENTURY = 3155695200000L;
    private static final long TIME_BASE = 62135596800000L;
    private static final int[] MONTHS_NONLEAP;
    private static final int[] MONTHS_LEAP;
    private static final long[] BIAS_MONTHMS;
    private static final char PAD_CHAR = '=';
    private static final char[] s_base64Chars;
    private static final byte[] s_base64Values;

    private static int parseDigits(String text, int offset, int length) throws IllegalArgumentException {
        int value = 0;
        if (length > 9) {
            try {
                value = Integer.parseInt(text.substring(offset, offset + length));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        } else {
            int limit = offset + length;
            while (offset < limit) {
                char chr;
                if ((chr = text.charAt(offset++)) >= '0' && chr <= '9') {
                    value = value * 10 + (chr - 48);
                    continue;
                }
                throw new IllegalArgumentException("Non-digit in number value");
            }
        }
        return value;
    }

    public static int parseInt(String text) throws IllegalArgumentException {
        text = text.trim();
        int offset = 0;
        int limit = text.length();
        if (limit == 0) {
            throw new IllegalArgumentException("Empty number value");
        }
        boolean negate = false;
        char chr = text.charAt(0);
        if (chr == '-') {
            if (limit > 9) {
                try {
                    return Integer.parseInt(text);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(ex.getMessage());
                }
            }
            negate = true;
            ++offset;
        } else if (chr == '+') {
            ++offset;
        }
        if (offset >= limit) {
            throw new IllegalArgumentException("Invalid number format");
        }
        int value = DateUtil.parseDigits(text, offset, limit - offset);
        if (negate) {
            return -value;
        }
        return value;
    }

    public static String serializeInt(int value) {
        return Integer.toString(value);
    }

    public static long parseLong(String text) throws IllegalArgumentException {
        text = text.trim();
        int offset = 0;
        int limit = text.length();
        if (limit == 0) {
            throw new IllegalArgumentException("Empty number value");
        }
        boolean negate = false;
        char chr = text.charAt(0);
        if (chr == '-') {
            negate = true;
            ++offset;
        } else if (chr == '+') {
            ++offset;
        }
        if (offset >= limit) {
            throw new IllegalArgumentException("Invalid number format");
        }
        long value = 0L;
        if (limit - offset > 18) {
            if (chr == '+') {
                text = text.substring(1);
            }
            try {
                value = Long.parseLong(text);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        } else {
            while (offset < limit) {
                if ((chr = text.charAt(offset++)) >= '0' && chr <= '9') {
                    value = value * 10L + (long)(chr - 48);
                    continue;
                }
                throw new IllegalArgumentException("Non-digit in number value");
            }
            if (negate) {
                value = -value;
            }
        }
        return value;
    }

    public static String serializeLong(long value) {
        return Long.toString(value);
    }

    public static short parseShort(String text) throws IllegalArgumentException {
        int value = DateUtil.parseInt(text);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Value out of range");
        }
        return (short)value;
    }

    public static String serializeShort(short value) {
        return Short.toString(value);
    }

    public static byte parseByte(String text) throws IllegalArgumentException {
        int value = DateUtil.parseInt(text);
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("Value out of range");
        }
        return (byte)value;
    }

    public static String serializeByte(byte value) {
        return Byte.toString(value);
    }

    public static boolean parseBoolean(String text) throws IllegalArgumentException {
        if ("true".equals(text = text.trim()) || "1".equals(text)) {
            return true;
        }
        if ("false".equals(text) || "0".equals(text)) {
            return false;
        }
        throw new IllegalArgumentException("Invalid boolean value");
    }

    public static String serializeBoolean(boolean value) {
        return value ? "true" : "false";
    }

    public static char parseChar(String text) throws IllegalArgumentException {
        int value = DateUtil.parseInt(text);
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Value out of range");
        }
        return (char)value;
    }

    public static String serializeChar(char value) {
        return Integer.toString(value);
    }

    public static char parseCharString(String text) throws IllegalArgumentException {
        if (text.length() == 1) {
            return text.charAt(0);
        }
        throw new IllegalArgumentException("Input must be a single character");
    }

    public static char deserializeCharString(String text) throws IllegalArgumentException {
        if (text == null) {
            return '\u0000';
        }
        return DateUtil.parseCharString(text);
    }

    public static String serializeCharString(char value) {
        return String.valueOf(value);
    }

    public static float parseFloat(String text) throws IllegalArgumentException {
        if ("-INF".equals(text = text.trim())) {
            return Float.NEGATIVE_INFINITY;
        }
        if ("INF".equals(text)) {
            return Float.POSITIVE_INFINITY;
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public static String serializeFloat(float value) {
        if (Float.isInfinite(value)) {
            return value < 0.0f ? "-INF" : "INF";
        }
        return Float.toString(value);
    }

    public static double parseDouble(String text) throws IllegalArgumentException {
        if ("-INF".equals(text = text.trim())) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("INF".equals(text)) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public static String serializeDouble(double value) {
        if (Double.isInfinite(value)) {
            return value < 0.0 ? "-INF" : "INF";
        }
        return Double.toString(value);
    }

    public static long parseYear(String text) throws IllegalArgumentException {
        text = text.trim();
        boolean valid = true;
        int minc = 4;
        char chr = text.charAt(0);
        if (chr == '-') {
            minc = 5;
        } else if (chr == '+') {
            valid = false;
        }
        if (text.length() < minc) {
            valid = false;
        }
        if (!valid) {
            throw new IllegalArgumentException("Invalid year format");
        }
        int year = DateUtil.parseInt(text);
        if (year == 0) {
            throw new IllegalArgumentException("Year value 0 is not allowed");
        }
        if (year > 0) {
            --year;
        }
        long day = (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400);
        return day * 86400000L - 62135596800000L;
    }

    public static long parseYearMonth(String text) throws IllegalArgumentException {
        boolean leap;
        text = text.trim();
        boolean valid = true;
        int minc = 7;
        char chr = text.charAt(0);
        if (chr == '-') {
            minc = 8;
        } else if (chr == '+') {
            valid = false;
        }
        int split = text.length() - 3;
        if (text.length() < minc) {
            valid = false;
        } else if (text.charAt(split) != '-') {
            valid = false;
        }
        if (!valid) {
            throw new IllegalArgumentException("Invalid date format");
        }
        int year = DateUtil.parseInt(text.substring(0, split));
        if (year == 0) {
            throw new IllegalArgumentException("Year value 0 is not allowed");
        }
        int month = DateUtil.parseDigits(text, split + 1, 2) - 1;
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Month value out of range");
        }
        boolean bl = leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        if (year > 0) {
            --year;
        }
        long day = (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400) + (long)(leap ? MONTHS_LEAP : MONTHS_NONLEAP)[month];
        return day * 86400000L - 62135596800000L;
    }

    public static long parseDate(String text) throws IllegalArgumentException {
        int[] starts;
        boolean valid = true;
        int minc = 10;
        char chr = text.charAt(0);
        if (chr == '-') {
            minc = 11;
        } else if (chr == '+') {
            valid = false;
        }
        int split = text.length() - 6;
        if (text.length() < minc) {
            valid = false;
        } else if (text.charAt(split) != '-' || text.charAt(split + 3) != '-') {
            valid = false;
        }
        if (!valid) {
            throw new IllegalArgumentException("Invalid date format");
        }
        int year = DateUtil.parseInt(text.substring(0, split));
        if (year == 0) {
            throw new IllegalArgumentException("Year value 0 is not allowed");
        }
        int month = DateUtil.parseDigits(text, split + 1, 2) - 1;
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Month value out of range");
        }
        long day = DateUtil.parseDigits(text, split + 4, 2) - 1;
        boolean leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        int[] nArray = starts = leap ? MONTHS_LEAP : MONTHS_NONLEAP;
        if (day < 0L || day >= (long)(starts[month + 1] - starts[month])) {
            throw new IllegalArgumentException("Day value out of range");
        }
        if (year > 0) {
            --year;
        }
        return (day += (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400) + (long)starts[month]) * 86400000L - 62135596800000L;
    }

    public static Date deserializeDate(String text) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        return new Date(DateUtil.parseDate(text));
    }

    public static java.sql.Date deserializeSqlDate(String text) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        long time = DateUtil.parseDate(text);
        return new java.sql.Date(time += (long)(TimeZone.getDefault().getRawOffset() + 0x6DDD00));
    }

    public static long parseTime(String text, int start, int length) throws IllegalArgumentException {
        boolean valid;
        long milli = 0L;
        boolean bl = valid = length > start + 7 && text.charAt(start + 2) == ':' && text.charAt(start + 5) == ':';
        if (valid) {
            int hour = DateUtil.parseDigits(text, start, 2);
            int minute = DateUtil.parseDigits(text, start + 3, 2);
            int second = DateUtil.parseDigits(text, start + 6, 2);
            if (hour > 23 || minute > 59 || second > 60) {
                valid = false;
            } else {
                milli = ((hour * 60 + minute) * 60 + second) * 1000;
                if (length > (start += 8)) {
                    if (text.charAt(length - 1) == 'Z') {
                        --length;
                    } else {
                        char chr = text.charAt(length - 6);
                        if (chr == '-' || chr == '+') {
                            hour = DateUtil.parseDigits(text, length - 5, 2);
                            minute = DateUtil.parseDigits(text, length - 2, 2);
                            if (hour > 23 || minute > 59) {
                                valid = false;
                            } else {
                                int offset = (hour * 60 + minute) * 60 * 1000;
                                milli = chr == '-' ? (milli += (long)offset) : (milli -= (long)offset);
                            }
                            length -= 6;
                        }
                    }
                    if (text.charAt(start) == '.') {
                        double fraction = Double.parseDouble(text.substring(start, length));
                        milli = (long)((double)milli + fraction * 1000.0);
                    } else if (length > start) {
                        valid = false;
                    }
                }
            }
        }
        if (valid) {
            return milli;
        }
        throw new IllegalArgumentException("Invalid dateTime format");
    }

    public static long parseDateTime(String text) throws IllegalArgumentException {
        int split = text.indexOf(84);
        if (split < 0) {
            throw new IllegalArgumentException("Missing 'T' separator in dateTime");
        }
        return DateUtil.parseDate(text.substring(0, split)) + DateUtil.parseTime(text, split + 1, text.length());
    }

    public static Date deserializeDateTime(String text) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        return new Date(DateUtil.parseDateTime(text));
    }

    public static Timestamp deserializeTimestamp(String text) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        int split = ((String)text).indexOf(46);
        int nano = 0;
        if (split > 0) {
            char chr;
            if (((String)text).indexOf(46, split) > 0) {
                throw new IllegalArgumentException("Not a valid dateTime value");
            }
            int limit = ((String)text).length();
            int scan = split;
            while (++scan < limit && (chr = ((String)text).charAt(scan)) >= '0' && chr <= '9') {
            }
            int length = scan - split - 1;
            if (length > 9) {
                length = 9;
            }
            nano = DateUtil.parseDigits((String)text, split + 1, length);
            while (length < 9) {
                nano *= 10;
                ++length;
            }
            text = scan < limit ? ((String)text).substring(0, split) + ((String)text).substring(scan) : ((String)text).substring(0, split);
        }
        Timestamp stamp = new Timestamp(DateUtil.parseDateTime((String)text));
        stamp.setNanos(nano);
        return stamp;
    }

    public static Time deserializeSqlTime(String text) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        return new Time(DateUtil.parseTime(text, 0, text.length()));
    }

    protected static void formatYearNumber(long year, StringBuffer buff) {
        if (year <= 0L) {
            buff.append('-');
            year = -(year - 1L);
        }
        if (year < 1000L) {
            buff.append('0');
            if (year < 100L) {
                buff.append('0');
                if (year < 10L) {
                    buff.append('0');
                }
            }
        }
        buff.append(year);
    }

    protected static void formatTwoDigits(int value, StringBuffer buff) {
        if (value < 10) {
            buff.append('0');
        }
        buff.append(value);
    }

    protected static void formatYear(long value, StringBuffer buff) {
        long yms;
        int yday;
        int month;
        long time = value + 26438400000L + 64800000L;
        long century = time / 3155695200000L;
        long adjusted = time + (century - century / 4L) * 86400000L;
        int year = (int)(adjusted / 31557600000L);
        if (adjusted < 0L) {
            --year;
        }
        if ((month = (5 * (yday = (int)((yms = adjusted + 21600000L - (long)(year * 365 + year / 4) * 86400000L) / 86400000L)) + 456) / 153) > 12) {
            ++year;
        }
        DateUtil.formatYearNumber(year, buff);
    }

    protected static long formatYearMonth(long value, StringBuffer buff) {
        long yms;
        int yday;
        long time = value + 26438400000L + 64800000L;
        long century = time / 3155695200000L;
        long adjusted = time + (century - century / 4L) * 86400000L;
        int year = (int)(adjusted / 31557600000L);
        if (adjusted < 0L) {
            --year;
        }
        if ((yday = (int)((yms = adjusted + 21600000L - (long)(year * 365 + year / 4) * 86400000L) / 86400000L)) == 0) {
            int dcnt;
            boolean bce;
            boolean bl = bce = year < 0;
            if (bce) {
                --year;
            }
            boolean isNormalLeapYear = year % 4 == 0;
            boolean is400LeapYear = year % 400 == 0;
            boolean is100NotLeapYear = year % 100 == 0;
            int n = dcnt = is400LeapYear || isNormalLeapYear && !is100NotLeapYear ? 366 : 365;
            if (!bce) {
                --year;
            }
            yms += (long)dcnt * 86400000L;
            yday += dcnt;
        }
        int month = (5 * yday + 456) / 153;
        long rem = yms - BIAS_MONTHMS[month] - 86400000L;
        if (month > 12) {
            ++year;
            month -= 12;
        }
        DateUtil.formatYearNumber(year, buff);
        buff.append('-');
        DateUtil.formatTwoDigits(month, buff);
        return rem;
    }

    protected static int formatYearMonthDay(long value, StringBuffer buff) {
        long extra = DateUtil.formatYearMonth(value, buff);
        int day = (int)(extra / 86400000L) + 1;
        buff.append('-');
        DateUtil.formatTwoDigits(day, buff);
        return (int)(extra % 86400000L);
    }

    public static String serializeYear(long time) throws IllegalArgumentException {
        StringBuffer buff = new StringBuffer(6);
        DateUtil.formatYear(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeYear(Date date) throws IllegalArgumentException {
        return DateUtil.serializeYear(date.getTime());
    }

    public static String serializeYearMonth(long time) throws IllegalArgumentException {
        StringBuffer buff = new StringBuffer(12);
        DateUtil.formatYearMonth(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeYearMonth(Date date) throws IllegalArgumentException {
        return DateUtil.serializeYearMonth(date.getTime());
    }

    public static String serializeDate(long time) throws IllegalArgumentException {
        StringBuffer buff = new StringBuffer(12);
        DateUtil.formatYearMonthDay(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeDate(Date date) throws IllegalArgumentException {
        long time = date.getTime();
        time += (long)TimeZone.getDefault().getOffset(time);
        return DateUtil.serializeDate(time);
    }

    public static String serializeSqlDate(java.sql.Date date) throws IllegalArgumentException {
        return DateUtil.serializeDate(date);
    }

    public static void serializeTime(int time, StringBuffer buff) throws IllegalArgumentException {
        DateUtil.formatTwoDigits(time / 3600000, buff);
        buff.append(':');
        DateUtil.formatTwoDigits((time %= 3600000) / 60000, buff);
        buff.append(':');
        DateUtil.formatTwoDigits((time %= 60000) / 1000, buff);
        if ((time %= 1000) > 0) {
            buff.append('.');
            buff.append(time / 100);
            if ((time %= 100) > 0) {
                buff.append(time / 10);
                if ((time %= 10) > 0) {
                    buff.append(time);
                }
            }
        }
    }

    public static String serializeDateTime(long time, boolean zone) throws IllegalArgumentException {
        StringBuffer buff = new StringBuffer(25);
        int extra = DateUtil.formatYearMonthDay(time + 62135596800000L, buff);
        buff.append('T');
        DateUtil.serializeTime(extra, buff);
        if (zone) {
            buff.append('Z');
        }
        return buff.toString();
    }

    public static String serializeDateTime(long time) throws IllegalArgumentException {
        return DateUtil.serializeDateTime(time, false);
    }

    public static String serializeDateTime(Date date) throws IllegalArgumentException {
        long time = date.getTime();
        time += (long)TimeZone.getDefault().getOffset(time);
        return DateUtil.serializeDateTime(time, false);
    }

    public static String serializeTimestamp(Timestamp stamp) throws IllegalArgumentException {
        int nano = stamp.getNanos();
        if (nano > 0) {
            String value = DateUtil.serializeInt(nano);
            StringBuffer digits = new StringBuffer(9);
            if (value.length() < 9) {
                int lead = 9 - value.length();
                for (int i = 0; i < lead; ++i) {
                    digits.append('0');
                }
            }
            digits.append(value);
            int last = 9;
            while (--last > 0 && digits.charAt(last) == '0') {
            }
            digits.setLength(last);
            return DateUtil.serializeDateTime(stamp.getTime(), false) + "." + digits + "Z";
        }
        return DateUtil.serializeDateTime(stamp.getTime(), true);
    }

    public static String serializeSqlTime(Time time) throws IllegalArgumentException {
        StringBuffer buff = new StringBuffer(12);
        long t = time.getTime();
        t += (long)TimeZone.getDefault().getOffset(t);
        int extra = DateUtil.formatYearMonthDay(t + 62135596800000L, buff);
        buff.delete(0, buff.length());
        DateUtil.serializeTime(extra, buff);
        return buff.toString();
    }

    public static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static int enumValue(String target, String[] enums, int[] vals) throws IllegalArgumentException {
        int base = 0;
        int limit = enums.length - 1;
        while (base <= limit) {
            int cur = base + limit >> 1;
            int diff = target.compareTo(enums[cur]);
            if (diff < 0) {
                limit = cur - 1;
                continue;
            }
            if (diff > 0) {
                base = cur + 1;
                continue;
            }
            if (vals != null) {
                return vals[cur];
            }
            return cur;
        }
        throw new IllegalArgumentException("Target value \"" + target + "\" not found in enumeration");
    }

    private static int decodeChunk(int base, char[] chrs, int fill, byte[] byts) throws IllegalArgumentException {
        int length = 3;
        if (chrs[base + 3] == '=') {
            length = 2;
            if (chrs[base + 2] == '=') {
                length = 1;
            }
        }
        byte v0 = s_base64Values[chrs[base + 0]];
        byte v1 = s_base64Values[chrs[base + 1]];
        byte v2 = s_base64Values[chrs[base + 2]];
        byte v3 = s_base64Values[chrs[base + 3]];
        switch (length) {
            case 3: {
                byts[fill + 2] = (byte)(v2 << 6 | v3);
            }
            case 2: {
                byts[fill + 1] = (byte)(v1 << 4 | v2 >> 2);
            }
            case 1: {
                byts[fill] = (byte)(v0 << 2 | v1 >> 4);
            }
        }
        return length;
    }

    public static byte[] parseBase64(String text) throws IllegalArgumentException {
        char[] chrs = new char[text.length()];
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr >= '\u0080' || s_base64Values[chr] < 0) continue;
            chrs[length++] = chr;
        }
        if (length % 4 != 0) {
            throw new IllegalArgumentException("Text length for base64 must be a multiple of 4");
        }
        if (length == 0) {
            return new byte[0];
        }
        int blength = length / 4 * 3;
        if (chrs[length - 1] == '=') {
            --blength;
            if (chrs[length - 2] == '=') {
                --blength;
            }
        }
        byte[] byts = new byte[blength];
        int fill = 0;
        for (int i = 0; i < length; i += 4) {
            fill += DateUtil.decodeChunk(i, chrs, fill, byts);
        }
        if (fill != blength) {
            throw new IllegalArgumentException("Embedded padding characters in byte64 text");
        }
        return byts;
    }

    public static byte[] deserializeBase64(String text) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        return DateUtil.parseBase64(text);
    }

    public static void encodeChunk(int base, byte[] byts, StringBuffer buff) {
        int length = 3;
        if (base + length > byts.length) {
            length = byts.length - base;
        }
        byte b0 = byts[base];
        int value = b0 >> 2 & 0x3F;
        buff.append(s_base64Chars[value]);
        if (length > 1) {
            byte b1 = byts[base + 1];
            value = ((b0 & 3) << 4) + (b1 >> 4 & 0xF);
            buff.append(s_base64Chars[value]);
            if (length > 2) {
                byte b2 = byts[base + 2];
                value = ((b1 & 0xF) << 2) + (b2 >> 6 & 3);
                buff.append(s_base64Chars[value]);
                value = b2 & 0x3F;
                buff.append(s_base64Chars[value]);
            } else {
                value = (b1 & 0xF) << 2;
                buff.append(s_base64Chars[value]);
                buff.append('=');
            }
        } else {
            value = (b0 & 3) << 4;
            buff.append(s_base64Chars[value]);
            buff.append('=');
            buff.append('=');
        }
    }

    public static String serializeBase64(byte[] byts) {
        StringBuffer buff = new StringBuffer((byts.length + 2) / 3 * 4);
        for (int i = 0; i < byts.length; i += 3) {
            DateUtil.encodeChunk(i, byts, buff);
            if (i <= 0 || i % 57 != 0 || i + 3 >= byts.length) continue;
            buff.append("\r\n");
        }
        return buff.toString();
    }

    public static List arrayListFactory() {
        return new ArrayList();
    }

    static {
        int i;
        MONTHS_NONLEAP = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        MONTHS_LEAP = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
        BIAS_MONTHMS = new long[]{0L, 0L, 0L, 0L, 2678400000L, 5270400000L, 7948800000L, 10540800000L, 13219200000L, 15897600000L, 18489600000L, 21168000000L, 23760000000L, 26438400000L, 29116800000L};
        s_base64Chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        s_base64Values = new byte[128];
        for (i = 0; i < s_base64Values.length; ++i) {
            DateUtil.s_base64Values[i] = -1;
        }
        DateUtil.s_base64Values[61] = 0;
        for (i = 0; i < s_base64Chars.length; ++i) {
            DateUtil.s_base64Values[DateUtil.s_base64Chars[i]] = (byte)i;
        }
    }
}

