/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.dialogs.properties.AbstractCopyAction;
import org.openstreetmap.josm.tools.I18n;

public class CopyKeyValueAction
extends AbstractCopyAction
implements PopupMenuListener {
    public CopyKeyValueAction(JTable tagTable, IntFunction<String> keyFn, Supplier<Collection<? extends Tagged>> objectSp) {
        super(tagTable, keyFn, objectSp);
        this.setName(0L);
        this.putValue("ShortDescription", I18n.tr("Copy the key and value of the selected tag(s) to clipboard", new Object[0]));
    }

    private void setName(long n) {
        this.putValue("Name", I18n.trn("Copy selected {0} Key/Value", "Copy selected {0} Keys/Values", n, n));
    }

    @Override
    protected Collection<String> getString(Tagged p, String key) {
        String v = p.get(key);
        return v == null ? null : Collections.singleton(new Tag(key, v).toString());
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.setName(this.valueStream().count());
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

