/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs.auxiliary.disk.AbstractDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCacheFactory;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheFactory;
import org.apache.commons.jcs.engine.CompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class JCSCacheManager {
    private static volatile CompositeCacheManager cacheManager;
    private static final long maxObjectTTL = -1L;
    private static final String PREFERENCE_PREFIX = "jcs.cache";
    public static final BooleanProperty USE_BLOCK_CACHE;
    private static final AuxiliaryCacheFactory DISK_CACHE_FACTORY;
    private static FileLock cacheDirLock;
    public static final IntegerProperty DEFAULT_MAX_OBJECTS_IN_MEMORY;
    private static final Logger jcsLog;

    private JCSCacheManager() {
    }

    private static void initialize() {
        block9: {
            File cacheDir = new File(Config.getDirs().getCacheDirectory(true), "jcs");
            try {
                if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                    Logging.warn("Cache directory " + cacheDir.toString() + " does not exists and could not create it");
                    break block9;
                }
                File cacheDirLockPath = new File(cacheDir, ".lock");
                try {
                    if (!cacheDirLockPath.exists() && !cacheDirLockPath.createNewFile()) {
                        Logging.warn("Cannot create cache dir lock file");
                    }
                    if ((cacheDirLock = FileChannel.open(cacheDirLockPath.toPath(), StandardOpenOption.WRITE).tryLock()) == null) {
                        Logging.warn("Cannot lock cache directory. Will not use disk cache");
                    }
                }
                catch (IOException e) {
                    Logging.log(Logging.LEVEL_WARN, "Cannot create cache dir \"" + cacheDirLockPath + "\" lock file:", e);
                    Logging.warn("Will not use disk cache");
                }
            }
            catch (SecurityException e) {
                Logging.log(Logging.LEVEL_WARN, "Unable to configure disk cache. Will not use it", e);
            }
        }
        Properties props = new Properties();
        props.setProperty("jcs.default.cacheattributes", CompositeCacheAttributes.class.getCanonicalName());
        props.setProperty("jcs.default.cacheattributes.MaxObjects", DEFAULT_MAX_OBJECTS_IN_MEMORY.get().toString());
        props.setProperty("jcs.default.cacheattributes.UseMemoryShrinker", "true");
        props.setProperty("jcs.default.cacheattributes.DiskUsagePatternName", "UPDATE");
        props.setProperty("jcs.default.elementattributes", CacheEntryAttributes.class.getCanonicalName());
        props.setProperty("jcs.default.elementattributes.IsEternal", "false");
        props.setProperty("jcs.default.elementattributes.MaxLife", Long.toString(-1L));
        props.setProperty("jcs.default.elementattributes.IdleTime", Long.toString(-1L));
        props.setProperty("jcs.default.elementattributes.IsSpool", "true");
        try {
            CompositeCacheManager cm = CompositeCacheManager.getUnconfiguredInstance();
            cm.configure(props);
            cacheManager = cm;
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_WARN, "Unable to initialize JCS", e);
        }
    }

    public static <K, V> CacheAccess<K, V> getCache(String cacheName) {
        return JCSCacheManager.getCache(cacheName, DEFAULT_MAX_OBJECTS_IN_MEMORY.get(), 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> CacheAccess<K, V> getCache(String cacheName, int maxMemoryObjects, int maxDiskObjects, String cachePath) {
        if (cacheManager != null) {
            return JCSCacheManager.getCacheInner(cacheName, maxMemoryObjects, maxDiskObjects, cachePath);
        }
        Class<JCSCacheManager> clazz = JCSCacheManager.class;
        synchronized (JCSCacheManager.class) {
            if (cacheManager == null) {
                JCSCacheManager.initialize();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return cacheManager != null ? JCSCacheManager.getCacheInner(cacheName, maxMemoryObjects, maxDiskObjects, cachePath) : null;
        }
    }

    private static <K, V> CacheAccess<K, V> getCacheInner(String cacheName, int maxMemoryObjects, int maxDiskObjects, String cachePath) {
        CompositeCache cc = cacheManager.getCache(cacheName, JCSCacheManager.getCacheAttributes(maxMemoryObjects));
        if (cachePath != null && cacheDirLock != null) {
            IDiskCacheAttributes diskAttributes = JCSCacheManager.getDiskCacheAttributes(maxDiskObjects, cachePath, cacheName);
            try {
                if (cc.getAuxCaches().length == 0) {
                    cc.setAuxCaches(new AuxiliaryCache[]{DISK_CACHE_FACTORY.createCache(diskAttributes, cacheManager, null, new StandardSerializer())});
                }
            }
            catch (Exception e) {
                cc.setAuxCaches(new AuxiliaryCache[0]);
                Logging.debug(e);
            }
        }
        return new CacheAccess(cc);
    }

    public static void shutdown() {
        CompositeCacheManager localCacheManager = cacheManager;
        if (localCacheManager != null) {
            localCacheManager.shutDown();
        }
    }

    private static IDiskCacheAttributes getDiskCacheAttributes(int maxDiskObjects, String cachePath, String cacheName) {
        AbstractDiskCacheAttributes ret;
        JCSCacheManager.removeStaleFiles(cachePath + File.separator + cacheName, USE_BLOCK_CACHE.get() != false ? "_INDEX_v2" : "_BLOCK_v2");
        String newCacheName = cacheName + (USE_BLOCK_CACHE.get() != false ? "_BLOCK_v2" : "_INDEX_v2");
        if (USE_BLOCK_CACHE.get().booleanValue()) {
            BlockDiskCacheAttributes blockAttr = new BlockDiskCacheAttributes();
            File diskCacheFile = new File(cachePath + File.separator + newCacheName + ".data");
            if (diskCacheFile.exists()) {
                blockAttr.setMaxKeySize((int)Math.max((long)maxDiskObjects, diskCacheFile.length() / 1024L));
            } else {
                blockAttr.setMaxKeySize(maxDiskObjects);
            }
            blockAttr.setBlockSizeBytes(4096);
            ret = blockAttr;
        } else {
            IndexedDiskCacheAttributes indexAttr = new IndexedDiskCacheAttributes();
            indexAttr.setMaxKeySize(maxDiskObjects);
            ret = indexAttr;
        }
        ret.setDiskLimitType(IDiskCacheAttributes.DiskLimitType.SIZE);
        File path = new File(cachePath);
        if (!path.exists() && !path.mkdirs()) {
            Logging.warn("Failed to create cache path: {0}", cachePath);
        } else {
            ret.setDiskPath(cachePath);
        }
        ret.setCacheName(newCacheName);
        return ret;
    }

    private static void removeStaleFiles(String basePathPart, String suffix) {
        JCSCacheManager.deleteCacheFiles(basePathPart + suffix);
    }

    private static void deleteCacheFiles(String basePathPart) {
        Utils.deleteFileIfExists(new File(basePathPart + ".key"));
        Utils.deleteFileIfExists(new File(basePathPart + ".data"));
    }

    private static CompositeCacheAttributes getCacheAttributes(int maxMemoryElements) {
        CompositeCacheAttributes ret = new CompositeCacheAttributes();
        ret.setMaxObjects(maxMemoryElements);
        ret.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
        return ret;
    }

    static {
        USE_BLOCK_CACHE = new BooleanProperty("jcs.cache.use_block_cache", true);
        DISK_CACHE_FACTORY = USE_BLOCK_CACHE.get() != false ? new BlockDiskCacheFactory() : new IndexedDiskCacheFactory();
        DEFAULT_MAX_OBJECTS_IN_MEMORY = new IntegerProperty("jcs.cache.max_objects_in_memory", 1000);
        jcsLog = Logger.getLogger("org.apache.commons.jcs");
        try {
            jcsLog.setLevel(Level.INFO);
            jcsLog.setUseParentHandlers(false);
            Arrays.stream(jcsLog.getHandlers()).forEach(jcsLog::removeHandler);
            jcsLog.addHandler(new Handler(){
                final SimpleFormatter formatter = new SimpleFormatter();

                @Override
                public void publish(LogRecord record) {
                    String msg = this.formatter.formatMessage(record);
                    if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
                        Logging.error(msg);
                    } else if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                        if (msg.equals("No configuration settings found.  Using hardcoded default values for all pools.") || msg.startsWith("Region") && msg.endsWith("Resetting cache")) {
                            Logging.debug(msg);
                        } else {
                            Logging.warn(msg);
                        }
                    } else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                        Logging.debug(msg);
                    } else {
                        Logging.trace(msg);
                    }
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            });
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to configure JCS logs", e);
        }
    }
}

