/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.util;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

final class MultiBandsIndexColorModel
extends IndexColorModel {
    final int numBands;
    private final int visibleBand;

    public MultiBandsIndexColorModel(int bits, int size, int[] cmap, int start, boolean hasAlpha, int transparent, int transferType, int numBands, int visibleBand) {
        super(bits, size, cmap, start, hasAlpha, transparent, transferType);
        this.numBands = numBands;
        this.visibleBand = visibleBand;
    }

    @Override
    public Object getDataElements(int RGB, Object pixel) {
        if (pixel == null) {
            switch (this.transferType) {
                case 1: 
                case 2: {
                    pixel = new short[this.numBands];
                    break;
                }
                case 0: {
                    pixel = new byte[this.numBands];
                    break;
                }
                case 3: {
                    pixel = new int[this.numBands];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unsupported());
                }
            }
        }
        pixel = super.getDataElements(RGB, pixel);
        switch (this.transferType) {
            case 1: 
            case 2: {
                short[] array = (short[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
            case 0: {
                byte[] array = (byte[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
            case 3: {
                int[] array = (int[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return pixel;
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        int i;
        switch (this.transferType) {
            case 1: 
            case 2: {
                i = ((short[])pixel)[this.visibleBand] & 0xFFFF;
                break;
            }
            case 0: {
                i = ((byte[])pixel)[this.visibleBand] & 0xFF;
                break;
            }
            case 3: {
                i = ((int[])pixel)[this.visibleBand];
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return this.getComponents(i, components, offset);
    }

    @Override
    public int getRed(Object inData) {
        int pixel;
        switch (this.transferType) {
            case 0: {
                pixel = ((byte[])inData)[this.visibleBand] & 0xFF;
                break;
            }
            case 1: {
                pixel = ((short[])inData)[this.visibleBand] & 0xFFFF;
                break;
            }
            case 3: {
                pixel = ((int[])inData)[this.visibleBand];
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return this.getRed(pixel);
    }

    @Override
    public int getGreen(Object inData) {
        int pixel;
        switch (this.transferType) {
            case 0: {
                pixel = ((byte[])inData)[this.visibleBand] & 0xFF;
                break;
            }
            case 1: {
                pixel = ((short[])inData)[this.visibleBand] & 0xFFFF;
                break;
            }
            case 3: {
                pixel = ((int[])inData)[this.visibleBand];
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return this.getGreen(pixel);
    }

    @Override
    public int getBlue(Object inData) {
        int pixel;
        switch (this.transferType) {
            case 0: {
                pixel = ((byte[])inData)[this.visibleBand] & 0xFF;
                break;
            }
            case 1: {
                pixel = ((short[])inData)[this.visibleBand] & 0xFFFF;
                break;
            }
            case 3: {
                pixel = ((int[])inData)[this.visibleBand];
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return this.getBlue(pixel);
    }

    @Override
    public int getAlpha(Object inData) {
        int pixel;
        switch (this.transferType) {
            case 0: {
                pixel = ((byte[])inData)[this.visibleBand] & 0xFF;
                break;
            }
            case 1: {
                pixel = ((short[])inData)[this.visibleBand] & 0xFFFF;
                break;
            }
            case 3: {
                pixel = ((int[])inData)[this.visibleBand];
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return this.getAlpha(pixel);
    }

    private String unsupported() {
        return "This method has not been implemented for transferType " + this.transferType;
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int width, int height) {
        return Raster.createBandedRaster(this.transferType, width, height, this.numBands, null);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    @Override
    public SampleModel createCompatibleSampleModel(int width, int height) {
        return new BandedSampleModel(this.transferType, width, height, this.numBands);
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        return sm instanceof ComponentSampleModel && sm.getTransferType() == this.transferType && sm.getNumBands() == this.numBands && 1 << sm.getSampleSize(this.visibleBand) >= this.getMapSize();
    }
}

