/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.text.MessageFormat;
import org.geotools.api.util.ProgressListener;

public abstract class BaseGridCoverageProgressAdapter {
    protected int lastImageIndex;
    protected final ProgressListener monitor;
    protected final int numImages;
    protected float progressStep;
    protected float progress;

    protected BaseGridCoverageProgressAdapter(ProgressListener monitor, int numImages) {
        if (numImages <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "numImages", numImages));
        }
        this.numImages = numImages;
        if (monitor == null) {
            throw new NullPointerException(MessageFormat.format("Argument \"{0}\" should not be null.", "monitor"));
        }
        this.monitor = monitor;
        this.init();
    }

    protected void init() {
        this.progressStep = 1.0f / (float)this.numImages;
    }
}

