/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.licenselib;

import de.wideportal.maprender.licenselib.LicenseContainer;
import de.wideportal.maprender.licenselib.LicensePublicKeyProvider;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class LicenseEncryption {
    public static final String UTF8 = "UTF-8";

    public LicenseContainer encryptLicense(LicenseContainer sourceLicense, PrivateKey privateKey, String privateKeyFileName) throws Exception {
        String licenseDataToEncrypt = sourceLicense.getLicenseInformationAsString();
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(128);
        SecretKey aesKey = generator.generateKey();
        byte[] symmetricKeyBytes = aesKey.getEncoded();
        Cipher rsaCipher = Cipher.getInstance("RSA");
        rsaCipher.init(1, privateKey);
        byte[] encryptedKeyBytes = rsaCipher.doFinal(symmetricKeyBytes);
        byte[] encryptedKeyBytesBase64 = Base64.getEncoder().encode(encryptedKeyBytes);
        String encryptedKey = new String(encryptedKeyBytesBase64, UTF8);
        sourceLicense.getLicense().getGenerated().setKey(encryptedKey);
        Cipher aesCipher = Cipher.getInstance("AES");
        aesCipher.init(1, aesKey);
        byte[] licenseBytes = licenseDataToEncrypt.getBytes(UTF8);
        byte[] encryptedLicenseBytes = aesCipher.doFinal(licenseBytes);
        byte[] encryptedLicenseBytesBase64 = Base64.getEncoder().encode(encryptedLicenseBytes);
        String licenseData = new String(encryptedLicenseBytesBase64, UTF8);
        sourceLicense.getLicense().getGenerated().setData(licenseData);
        String encryptedLicenseHash = this.getShaHash(encryptedLicenseBytesBase64);
        sourceLicense.getLicense().getGenerated().setHash(encryptedLicenseHash);
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
        String dateString = format.format(new Date());
        sourceLicense.getLicense().getGenerated().setIssued(dateString);
        sourceLicense.getLicense().getGenerated().setPkUsed(privateKeyFileName);
        return sourceLicense;
    }

    public String getArray(byte[] array) {
        StringBuffer buffy = new StringBuffer();
        buffy.append("byte[");
        for (int i = 0; i < array.length; ++i) {
            buffy.append(array[i]);
            buffy.append(", ");
        }
        buffy.append("]");
        return buffy.toString();
    }

    public String decryptLicense(LicenseContainer entryptedLicense, LicensePublicKeyProvider publicKeyProvider) throws Exception {
        String entryptedSymmetricKey = entryptedLicense.getLicense().getGenerated().getKey();
        String entryptedLicenseData = entryptedLicense.getLicense().getGenerated().getData();
        byte[] publicKeyBytesBase64 = publicKeyProvider.getPublicKey().getBytes(UTF8);
        byte[] publicKeyBytes = Base64.getDecoder().decode(publicKeyBytesBase64);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(spec);
        Cipher rsaCipher = Cipher.getInstance("RSA");
        rsaCipher.init(2, publicKey);
        byte[] entryptedSymmetricKeyBytesBase64 = entryptedSymmetricKey.getBytes(UTF8);
        byte[] entryptedSymmetricKeyBytes = Base64.getDecoder().decode(entryptedSymmetricKeyBytesBase64);
        byte[] decryptedSymmetricKeyBytes = rsaCipher.doFinal(entryptedSymmetricKeyBytes);
        byte[] entryptedLicenseDataBytesBase64 = entryptedLicenseData.getBytes(UTF8);
        byte[] entryptedLicenseDataBytes = Base64.getDecoder().decode(entryptedLicenseDataBytesBase64);
        Cipher aesCipher = Cipher.getInstance("AES");
        SecretKeySpec aesKey = new SecretKeySpec(decryptedSymmetricKeyBytes, "AES");
        aesCipher.init(2, aesKey);
        byte[] decryptedLicenseDataBytes = aesCipher.doFinal(entryptedLicenseDataBytes);
        return new String(decryptedLicenseDataBytes, UTF8);
    }

    private String getShaHash(byte[] input) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] encodedhash = digest.digest(input);
        byte[] encodedhashBase64 = Base64.getEncoder().encode(encodedhash);
        return new String(encodedhashBase64, UTF8);
    }
}

