(function() { 

	var lat=49;
	var lon=8.425;
	var zoom=12;

	
	var layersBase = [];
	layersBase.push(new ol.layer.Tile({
						title: 'Demo',
						type: 'base',
						visible: true,
						source: new ol.source.XYZ({
							url: '../demo/{z}/{x}/{y}.png',
							attributions: [ol.source.OSM.ATTRIBUTION, '<a href="https://www.wideportal.de">Wideportal IT Solutions GmbH</a>'],
						}),						
					}));
	
	var layersOverlay = [];
	
	var layersAll = layersBase.concat(layersOverlay);

	
	var center = ol.proj.fromLonLat([lon, lat]);
	var rotation = 0;
	var selectedLayers = [];
	
	
	if (window.location.hash !== '') {
		var hash = window.location.hash.replace('#map=', '');
		var parts = hash.split('/');
		if (parts.length >= 4) {
			zoom = parseFloat(parts[0]);
			center = [
				parseFloat(parts[1]),
				parseFloat(parts[2])
			];
			rotation = parseFloat(parts[3]);
		}
		if (parts.length >= 5) {
			var layerString = parts[4];
			var layersBase64 = layerString.split(',');
			layersBase64.forEach(function(layerBase64){
				selectedLayers.push(atob(layerBase64));
			});
		}
		
		layersAll.forEach(function(layer) {
			layer.set('visible', false);
		});
		
		layersAll.forEach(function(layer) {
			var layerTitle = layer.get('title');
			selectedLayers.forEach(function(selectedLayerTitle) {
				if(layerTitle === selectedLayerTitle) {
					layer.set('visible', true);
				}
			});
		});
		
		layersAll.forEach(function(layer) {
			var layerTitle = layer.get('title');
			selectedLayers.forEach(function(selectedLayerTitle) {
				if(layerTitle === selectedLayerTitle) {
					layer.set('visible', true);
				}
			});
		});
		
	}
	
	var attribution = new ol.control.Attribution({
		collapsible: false
	});
	
	var controls = ol.control.defaults({
		rotate: false,
		attribution: false,
	}).extend([
		attribution
	]);
	
	var interactions = ol.interaction.defaults({
		altShiftDragRotate:false, 
		pinchRotate:false,
		dragPan: false,
		mouseWheelZoom: false,
	}).extend([
		new ol.interaction.DragPan({kinetic: false}),
		new ol.interaction.MouseWheelZoom({
			duration: 0,			
		})
	]);
	
	var map = new ol.Map({
		target: 'map',
		layers: [
			new ol.layer.Group({
				'title': 'Base maps',
				layers: layersBase,
			}),
			
//			new ol.layer.Group({
//				'title': 'Overlays',
//				layers: layersOverlay,
//			}),

		],
		view: new ol.View({
			center: center,
			zoom: zoom,
			rotation: rotation,
			minZoom: 1,
			maxZoom: 17,
			constrainResolution: true,
		}),
		controls: controls,
		interactions: interactions,
	});
	
	var layerSwitcher = new ol.control.LayerSwitcher({
		tipLabel: 'Layers', 
		groupSelectStyle: 'children', // Can be 'children' [default], 'group' or 'none',
		reverse: false,
	});
	map.addControl(layerSwitcher);
	
	map.addControl(new ol.control.MousePosition({
		coordinateFormat: ol.coordinate.createStringXY(5),
		projection: 'EPSG:4326',  
	}));
	
	map.addControl(new ol.control.ScaleLine({
		units: 'metric',
	}));
	
	function checkSize() {
		var small = map.getSize()[0] < 600;
		attribution.setCollapsible(small);
		attribution.setCollapsed(small);
	}
	window.addEventListener('resize', checkSize);
	checkSize();

	var zoomslider = new ol.control.ZoomSlider();
	map.addControl(zoomslider);
	
	
	
	var shouldUpdate = true;
	var view = map.getView();
	var updatePermalink = function() {
		if (!shouldUpdate) {
			shouldUpdate = true;
			return;
		}

		var center = view.getCenter();
		
		var layerString = '';
		map.getLayers().forEach(function(layer){
			if (layer instanceof ol.layer.Group) {
				layer.getLayers().forEach(function(layer){
					if(layer.get('visible')){
						layerString = layerString + btoa(layer.get('title')) + ',';
					}
				});
			} else {
				if(layer.get('visible')){
					layerString = layerString + btoa(layer.get('title')) + ',';
				}
			}
		});
		layerString = layerString.replace(/(^,)|(,$)/g, "");
		
		var hash = '#map=' +
			view.getZoom() + '/' +
			Math.round(center[0] * 100) / 100 + '/' +
			Math.round(center[1] * 100) / 100 + '/' +
			view.getRotation() + '/' + 
			layerString;
		var state = {
			zoom: view.getZoom(),
			center: view.getCenter(),
			rotation: view.getRotation()
		};
		window.history.pushState(state, 'map', hash);
	};

	map.on('moveend', updatePermalink);

	window.addEventListener('popstate', function(event) {
		if (event.state === null) {
			return;
		}
		map.getView().setCenter(event.state.center);
		map.getView().setZoom(event.state.zoom);
		map.getView().setRotation(event.state.rotation);
		shouldUpdate = false;
	});
	
	layersAll.forEach(function(layer) {
		layer.on('change:visible', function(){
			updatePermalink();
		});
	});
})();