/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.Utils;

public final class OverpassTurboQueryWizard {
    private static OverpassTurboQueryWizard instance;
    private final ScriptEngine engine = Utils.getJavaScriptEngine();

    public static synchronized OverpassTurboQueryWizard getInstance() {
        if (instance == null) {
            instance = new OverpassTurboQueryWizard();
        }
        return instance;
    }

    private OverpassTurboQueryWizard() {
        try (CachedFile file = new CachedFile("resource://data/overpass-wizard.js");
             BufferedReader reader = file.getContentReader();){
            if (this.engine != null) {
                this.engine.eval("var console = {error: " + Logging.class.getCanonicalName() + ".warn};");
                this.engine.eval("var global = {};");
                this.engine.eval(reader);
                this.engine.eval("var overpassWizardJOSM = function(query) {  return overpassWizard(query, {    comment: false,    timeout: " + Config.getPref().getInt("overpass.wizard.timeout", 90) + ",    outputFormat: 'xml',    outputMode: 'recursive_meta'  });}");
            }
        }
        catch (IOException | ScriptException ex) {
            throw new IllegalStateException("Failed to initialize OverpassTurboQueryWizard", ex);
        }
    }

    public String constructQuery(String search) {
        if (this.engine == null) {
            throw new IllegalStateException("Failed to retrieve JavaScript engine");
        }
        try {
            Object result = ((Invocable)((Object)this.engine)).invokeFunction("overpassWizardJOSM", search);
            if (Boolean.FALSE.equals(result)) {
                throw new UncheckedParseException();
            }
            return (String)result;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (ScriptException e) {
            throw new UncheckedParseException("Failed to execute OverpassTurboQueryWizard", e);
        }
    }
}

