/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class PrimitiveRenderer
implements ListCellRenderer<IPrimitive>,
TableCellRenderer {
    private final DefaultNameFormatter formatter = DefaultNameFormatter.getInstance();
    private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
    private final DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();

    @Override
    public Component getListCellRendererComponent(JList<? extends IPrimitive> list, IPrimitive value, int index, boolean isSelected, boolean cellHasFocus) {
        Component def = this.defaultListCellRenderer.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
        return this.renderer(def, value, list.getModel().getSize() > 1000);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component def = this.defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof IPrimitive) {
            return this.renderer(def, (IPrimitive)value, table.getModel().getRowCount() > 1000);
        }
        if (value instanceof HistoryOsmPrimitive) {
            return this.renderer(def, (HistoryOsmPrimitive)value);
        }
        return def;
    }

    private Component renderer(Component def, IPrimitive value, boolean fast) {
        if (value != null && def instanceof JLabel) {
            ImageIcon icon;
            ((JLabel)def).setText(this.getComponentText(value));
            ImageIcon imageIcon = icon = fast || !(value instanceof OsmPrimitive) ? ImageProvider.get(value.getType()) : ImageProvider.getPadded((OsmPrimitive)value, ImageProvider.ImageSizes.SMALLICON.getImageDimension());
            if (icon != null) {
                ((JLabel)def).setIcon(icon);
            } else {
                Logging.warn("Null icon for " + (Object)((Object)value.getDisplayType()));
            }
            ((JLabel)def).setToolTipText(this.getComponentToolTipText(value));
        }
        return def;
    }

    private Component renderer(Component def, HistoryOsmPrimitive value) {
        if (value != null && def instanceof JLabel) {
            ((JLabel)def).setText(value.getDisplayName(DefaultNameFormatter.getInstance()));
            ((JLabel)def).setIcon(ImageProvider.get(value.getType()));
            ((JLabel)def).setToolTipText(this.formatter.buildDefaultToolTip(value));
        }
        return def;
    }

    protected String getComponentText(IPrimitive value) {
        return value.getDisplayName(DefaultNameFormatter.getInstance());
    }

    protected String getComponentToolTipText(IPrimitive value) {
        return this.formatter.buildDefaultToolTip(value);
    }
}

