/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.server;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.output.format.SlippyMapTiles;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleEarthServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet: " + request.getQueryString());
        String tileServer = request.getParameter("tileServer");
        String googleBBox = request.getParameter("BBOX");
        String color = request.getParameter("color");
        if (googleBBox != null && !googleBBox.isBlank()) {
            BoundingBox bbox = new BoundingBox(googleBBox);
            double maxDist = Math.max(bbox.getWidth(), bbox.getHeight());
            double tilesCount = 10.0;
            double tileDistance = maxDist / tilesCount;
            SlippyMapTiles slippyMapTiles = new SlippyMapTiles();
            int zoomToUse = 17;
            for (int zoom = 17; zoom >= 3; --zoom) {
                double y;
                Point xyPixel = slippyMapTiles.getLonLatToPixel(bbox.getCenter().getX(), bbox.getCenter().getY(), zoom);
                double x = xyPixel.getX();
                BoundingBox zoomBBox = slippyMapTiles.getBoundingBoxForTile(zoom, (int)x, (int)(y = xyPixel.getY()));
                double tileDistZoom = Math.max(zoomBBox.getWidth(), zoomBBox.getHeight());
                if (!(tileDistZoom >= tileDistance)) continue;
                zoomToUse = zoom;
                break;
            }
            Point minTileIndex = slippyMapTiles.getMinTileIndex(bbox.getLeft(), bbox.getTop(), zoomToUse);
            Point maxTileIndex = slippyMapTiles.getMaxTileIndex(bbox.getRight(), bbox.getBottom(), zoomToUse);
            int leftX = (int)minTileIndex.getX();
            int rightX = (int)maxTileIndex.getX();
            int topY = (int)minTileIndex.getY();
            int bottomY = (int)maxTileIndex.getY();
            response.setContentType("text/xml");
            response.setStatus(200);
            response.setCharacterEncoding("utf-8");
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            response.getWriter().println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.2\">\n    <Folder>\n        <name>OpenStreetMap</name>\n        <open>1</open>\n        <Folder>\n            <name>Data</name>\n            <open>1</open>\n            <Style>\n                <ListStyle>\n                    <listItemType>checkHideChildren</listItemType>\n                    <bgColor>00ffffff</bgColor>\n                </ListStyle>\n            </Style>\n");
            for (int x = leftX; x <= rightX; ++x) {
                for (int y = topY; y <= bottomY; ++y) {
                    BoundingBox tileBBox = slippyMapTiles.getBoundingBoxForTile(zoomToUse, x, y);
                    response.getWriter().println("<GroundOverlay>");
                    response.getWriter().println("  <color>" + color + "</color>");
                    response.getWriter().println("  <Icon>");
                    response.getWriter().println("    <href>" + tileServer + "/" + zoomToUse + "/" + x + "/" + y + ".png</href>");
                    response.getWriter().println("    <viewBoundScale>1</viewBoundScale>");
                    response.getWriter().println("  </Icon>");
                    response.getWriter().println("  <LatLonBox>");
                    response.getWriter().println("    <north>" + tileBBox.getTop() + "</north>");
                    response.getWriter().println("    <south>" + tileBBox.getBottom() + "</south>");
                    response.getWriter().println("    <east>" + tileBBox.getRight() + "</east>");
                    response.getWriter().println("    <west>" + tileBBox.getLeft() + "</west>");
                    response.getWriter().println("  </LatLonBox>");
                    response.getWriter().println("</GroundOverlay>");
                }
            }
            response.getWriter().println("        </Folder>\n    </Folder>\n</kml>\n");
        }
    }
}

