/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.server;

import de.wideportal.maprender.config.ConfigurationException;
import de.wideportal.maprender.config.ConfigurationLoader;
import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.RenderConfigurationServer;
import de.wideportal.maprender.request.RenderManager;
import de.wideportal.maprender.server.GoogleEarthServlet;
import de.wideportal.maprender.server.StatusServlet;
import java.io.File;
import java.nio.file.Path;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedJettyServer
implements Runnable {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String configurationFile;
    private Server server;
    private boolean isDaemon = false;

    public void startServer(String configurationFile, RenderManager renderManager) {
        this.log.info("startServer: starting EmbeddedJettyServer");
        this.configurationFile = configurationFile;
        Thread jettyThread = new Thread(this);
        jettyThread.start();
        this.log.info("startServer: finished starting EmbeddedJettyServer thread");
    }

    @Override
    public void run() {
        try {
            ConfigurationLoader configurationLoader = new ConfigurationLoader();
            RenderConfiguration configuration = configurationLoader.loadConfiguration(this.configurationFile);
            RenderConfigurationServer serverConfig = configuration.getMaprenderConfiguration().getServer();
            if (serverConfig == null) {
                this.log.warn("run: no server configuration found. Exit.");
                return;
            }
            boolean runServer = serverConfig.getRun();
            if (!runServer) {
                this.log.info("run: server is configured not to run. Exit.");
                return;
            }
            String portString = serverConfig.getPort();
            if (portString == null) {
                this.log.warn("run: no server port configured. Exit.");
                return;
            }
            String folder = serverConfig.getFolder();
            if (folder == null) {
                this.log.warn("init: no server folder configured. Exit.");
                return;
            }
            int port = Integer.parseInt(portString);
            File outputFile = new File(folder);
            Path outputFolder = outputFile.toPath();
            this.isDaemon = serverConfig.getDaemon();
            this.log.info("run: starting EmbeddedJettyServer should run: " + runServer);
            this.log.info("run: starting EmbeddedJettyServer as daemon: " + this.isDaemon);
            this.log.info("run: starting EmbeddedJettyServer on port: " + port);
            this.log.info("run: starting EmbeddedJettyServer with folder: " + outputFolder);
            PathResource pathResource = new PathResource(outputFolder);
            this.server = new Server(port);
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setDirectoriesListed(true);
            resourceHandler.setWelcomeFiles(new String[]{"index.html"});
            resourceHandler.setBaseResource((Resource)pathResource);
            ServletHandler servletHandler = new ServletHandler();
            servletHandler.addServletWithMapping(StatusServlet.class, "/status");
            servletHandler.addServletWithMapping(GoogleEarthServlet.class, "/googleearth");
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(new Handler[]{resourceHandler, servletHandler, new DefaultHandler()});
            this.server.setHandler((Handler)handlers);
            this.server.start();
            this.server.join();
        }
        catch (ConfigurationException ce) {
            this.log.error("EmbeddedJettyServer: could not start EmbeddedJettyServer due to a configuration problem", (Throwable)ce);
        }
        catch (Exception de) {
            this.log.error("EmbeddedJettyServer: could not start EmbeddedJettyServer because of unexpected exception", (Throwable)de);
        }
    }

    public void stopServer() {
        this.log.info("stopServer: stopping EmbeddedJettyServer");
        if (!this.isDaemon) {
            if (this.server != null) {
                try {
                    this.server.stop();
                }
                catch (Exception e) {
                    this.log.error("EmbeddedJettyServer: could not stop EmbeddedJettyServer because of unexpected exception", (Throwable)e);
                }
            }
        } else {
            this.log.info("stopServer: EmbeddedJettyServer is configured as daemon so will keep it running. Please kill the process manually to stop the server!");
        }
        this.log.info("stopServer: stopped EmbeddedJettyServer");
    }
}

