/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm.voids;

import de.wideportal.maprender.resources.srtm.voids.SrtmTileVoidCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrtmTileVoidCachePersister {
    protected static Logger log = LoggerFactory.getLogger(SrtmTileVoidCachePersister.class);
    private String baseFolder;

    public SrtmTileVoidCachePersister(String baseFolder) {
        this.baseFolder = baseFolder;
    }

    private String getFileName(String baseFolder, String fileName, boolean createMissingFolders) {
        File baseFolderFile;
        if (!((String)(baseFolder = ((String)baseFolder).replaceAll("\\\\", "/"))).endsWith("/")) {
            baseFolder = (String)baseFolder + "/";
        }
        if (!(baseFolderFile = new File((String)baseFolder)).exists()) {
            if (createMissingFolders) {
                baseFolderFile.mkdir();
            } else {
                return null;
            }
        }
        return (String)baseFolder + fileName;
    }

    public void persist(String srtmTileName, SrtmTileVoidCache voidCache) {
        String fileName = srtmTileName + ".voidcache";
        String folderFileName = this.getFileName(this.baseFolder, fileName, true);
        if (folderFileName == null) {
            log.error("persist: file is not accessible. Cannot save void cache. file is: " + folderFileName);
            return;
        }
        File file = new File(folderFileName);
        if (file.exists()) {
            file.delete();
            log.debug("persist: deleted old void cache: " + file.getAbsolutePath());
        }
        try (FileOutputStream fout = new FileOutputStream(file);
             ZipOutputStream zos = new ZipOutputStream(fout);
             FSTObjectOutput oos = new FSTObjectOutput((OutputStream)zos);){
            ZipEntry innerFile = new ZipEntry(fileName);
            zos.putNextEntry(innerFile);
            oos.writeObject((Object)voidCache, new Class[]{SrtmTileVoidCache.class});
        }
        catch (IOException e) {
            log.error("persist: could not write to file: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public SrtmTileVoidCache load(String srtmTileName) {
        String fileName = srtmTileName + ".voidcache";
        String folderFileName = this.getFileName(this.baseFolder, fileName, true);
        SrtmTileVoidCache result = null;
        if (folderFileName == null) {
            log.error("load: file is not accessible. Cannot load void cache. File is: " + folderFileName);
            return null;
        }
        File file = new File(folderFileName);
        if (!file.exists()) {
            log.info("load: file does not exist. Cannot load void cache. File is: " + folderFileName);
            return null;
        }
        try (FileInputStream fis = new FileInputStream(file);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry innerFile = zis.getNextEntry();
            if (innerFile != null) {
                FSTObjectInput ois = new FSTObjectInput((InputStream)zis);
                result = (SrtmTileVoidCache)ois.readObject(new Class[]{SrtmTileVoidCache.class});
                ois.close();
            }
        }
        catch (Exception e) {
            log.error("load: could not load from file: " + file.getAbsolutePath(), (Throwable)e);
        }
        return result;
    }
}

