/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm.algos;

import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.renderer.buffer.BooleanArrayBuffer;
import de.wideportal.maprender.resources.srtm.SrtmLinePointsContainer;
import de.wideportal.maprender.resources.srtm.algos.PointGroupAlgo;

public class PointGroupRemoveUnneccessaryPointsAlgo
extends PointGroupAlgo {
    public static void removeUnneccessaryPoints(BooleanArrayBuffer cellOnLineBuffer, SrtmLinePointsContainer linePointsContainer, int z) {
        for (int i = linePointsContainer.getPoints().size() - 1; i >= 0; --i) {
            boolean hasUnconnectedSurroundingPoints;
            Point currentPoint = linePointsContainer.getPoints().get(i);
            int surroundingPoints = PointGroupRemoveUnneccessaryPointsAlgo.getSurroundingPointsCount(cellOnLineBuffer, currentPoint, z);
            if (surroundingPoints == 0) {
                linePointsContainer.removePoint(currentPoint);
                cellOnLineBuffer.setValue((int)currentPoint.getX(), (int)currentPoint.getY(), z, false);
                continue;
            }
            if (surroundingPoints == 1) continue;
            if (surroundingPoints == 2) {
                boolean hasDirectlyTouchingSurroundingPoints;
                hasUnconnectedSurroundingPoints = PointGroupRemoveUnneccessaryPointsAlgo.hasUnconnectedSurroundingPoints(currentPoint, z, cellOnLineBuffer);
                if (hasUnconnectedSurroundingPoints || (hasDirectlyTouchingSurroundingPoints = PointGroupRemoveUnneccessaryPointsAlgo.hasDirectlyTouchingSurroundingPoints(currentPoint, z, cellOnLineBuffer))) continue;
                linePointsContainer.removePoint(currentPoint);
                cellOnLineBuffer.setValue((int)currentPoint.getX(), (int)currentPoint.getY(), z, false);
                continue;
            }
            if (surroundingPoints <= 2 || (hasUnconnectedSurroundingPoints = PointGroupRemoveUnneccessaryPointsAlgo.hasUnconnectedSurroundingPoints(currentPoint, z, cellOnLineBuffer))) continue;
            linePointsContainer.removePoint(currentPoint);
            cellOnLineBuffer.setValue((int)currentPoint.getX(), (int)currentPoint.getY(), z, false);
        }
    }

    public static boolean hasUnconnectedSurroundingPoints(Point center, int z, BooleanArrayBuffer cellOnLineBuffer) {
        boolean hasUnconnectedSurroundingPoints = false;
        boolean[] clockwiseSurroundingPointsRing = PointGroupRemoveUnneccessaryPointsAlgo.getClockwiseSurroundingPointsRing(center, z, cellOnLineBuffer);
        int valueFlicks = 0;
        for (int i = 0; i < 8; ++i) {
            if (i == 0 && clockwiseSurroundingPointsRing[i]) {
                if (!clockwiseSurroundingPointsRing[1]) {
                    ++valueFlicks;
                }
                if (clockwiseSurroundingPointsRing[7]) continue;
                ++valueFlicks;
                continue;
            }
            if (i == 2 && clockwiseSurroundingPointsRing[i]) {
                if (!clockwiseSurroundingPointsRing[1]) {
                    ++valueFlicks;
                }
                if (clockwiseSurroundingPointsRing[3]) continue;
                ++valueFlicks;
                continue;
            }
            if (i == 4 && clockwiseSurroundingPointsRing[i]) {
                if (!clockwiseSurroundingPointsRing[3]) {
                    ++valueFlicks;
                }
                if (clockwiseSurroundingPointsRing[5]) continue;
                ++valueFlicks;
                continue;
            }
            if (i == 6 && clockwiseSurroundingPointsRing[i]) {
                if (!clockwiseSurroundingPointsRing[5]) {
                    ++valueFlicks;
                }
                if (clockwiseSurroundingPointsRing[7]) continue;
                ++valueFlicks;
                continue;
            }
            if (i == 1 && clockwiseSurroundingPointsRing[i]) {
                if (!clockwiseSurroundingPointsRing[0] && !clockwiseSurroundingPointsRing[7]) {
                    ++valueFlicks;
                }
                if (clockwiseSurroundingPointsRing[2] || clockwiseSurroundingPointsRing[3]) continue;
                ++valueFlicks;
                continue;
            }
            if (i == 3 && clockwiseSurroundingPointsRing[i]) {
                if (!clockwiseSurroundingPointsRing[1] && !clockwiseSurroundingPointsRing[2]) {
                    ++valueFlicks;
                }
                if (clockwiseSurroundingPointsRing[4] || clockwiseSurroundingPointsRing[5]) continue;
                ++valueFlicks;
                continue;
            }
            if (i == 5 && clockwiseSurroundingPointsRing[i]) {
                if (!clockwiseSurroundingPointsRing[3] && !clockwiseSurroundingPointsRing[4]) {
                    ++valueFlicks;
                }
                if (clockwiseSurroundingPointsRing[6] || clockwiseSurroundingPointsRing[7]) continue;
                ++valueFlicks;
                continue;
            }
            if (i != 7 || !clockwiseSurroundingPointsRing[i]) continue;
            if (!clockwiseSurroundingPointsRing[0] && !clockwiseSurroundingPointsRing[1]) {
                ++valueFlicks;
            }
            if (clockwiseSurroundingPointsRing[5] || clockwiseSurroundingPointsRing[6]) continue;
            ++valueFlicks;
        }
        if (valueFlicks >= 4) {
            hasUnconnectedSurroundingPoints = true;
        }
        return hasUnconnectedSurroundingPoints;
    }

    public static boolean[] getClockwiseSurroundingPointsRing(Point center, int z, BooleanArrayBuffer cellOnLineBuffer) {
        boolean[] clockwiseSurroundingPointsRing = new boolean[9];
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                int x = (int)(center.getX() + (double)i);
                int y = (int)(center.getY() + (double)j);
                if (x < 0 || y < 0 || x >= cellOnLineBuffer.getXSize() || y >= cellOnLineBuffer.getYSize() || !cellOnLineBuffer.getValue(x, y, z)) continue;
                if (i == -1 && j == -1) {
                    clockwiseSurroundingPointsRing[0] = true;
                    clockwiseSurroundingPointsRing[8] = true;
                    continue;
                }
                if (i == 0 && j == -1) {
                    clockwiseSurroundingPointsRing[1] = true;
                    continue;
                }
                if (i == 1 && j == -1) {
                    clockwiseSurroundingPointsRing[2] = true;
                    continue;
                }
                if (i == 1 && j == 0) {
                    clockwiseSurroundingPointsRing[3] = true;
                    continue;
                }
                if (i == 1 && j == 1) {
                    clockwiseSurroundingPointsRing[4] = true;
                    continue;
                }
                if (i == 0 && j == 1) {
                    clockwiseSurroundingPointsRing[5] = true;
                    continue;
                }
                if (i == -1 && j == 1) {
                    clockwiseSurroundingPointsRing[6] = true;
                    continue;
                }
                if (i != -1 || j != 0) continue;
                clockwiseSurroundingPointsRing[7] = true;
            }
        }
        return clockwiseSurroundingPointsRing;
    }

    public static boolean hasDirectlyTouchingSurroundingPoints(Point center, int z, BooleanArrayBuffer cellOnLineBuffer) {
        boolean[] clockwiseSurroundingPointsRing = PointGroupRemoveUnneccessaryPointsAlgo.getClockwiseSurroundingPointsRing(center, z, cellOnLineBuffer);
        for (int i = 1; i < 9; ++i) {
            if (!clockwiseSurroundingPointsRing[i] || !clockwiseSurroundingPointsRing[i - 1]) continue;
            return true;
        }
        return false;
    }
}

