/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm.algos;

import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.renderer.buffer.BooleanArrayBuffer;
import de.wideportal.maprender.resources.srtm.SrtmLinePointsContainer;
import de.wideportal.maprender.resources.srtm.algos.PointGroupAlgo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointGroupDeadendRemoverAlgo
extends PointGroupAlgo {
    protected static Logger log = LoggerFactory.getLogger(PointGroupDeadendRemoverAlgo.class);

    public static void removeDeadendLines(BooleanArrayBuffer cellOnLineBuffer, SrtmLinePointsContainer linePointsContainer, int z, long tileSize) {
        int groupCounter = 0;
        for (int i = linePointsContainer.getGroups().size() - 1; i >= 0; --i) {
            ArrayList<Point> group = linePointsContainer.getGroups().get(i);
            ArrayList<Point> endpoints = PointGroupDeadendRemoverAlgo.getAllPointsWithOnlyOneNeighbor(group, linePointsContainer);
            while (endpoints.size() > 0) {
                Point currentPoint = endpoints.get(0);
                ArrayList<Point> pointsToDelete = new ArrayList<Point>();
                if (!PointGroupDeadendRemoverAlgo.isOnTileBorder(currentPoint, tileSize)) {
                    block9: {
                        ArrayList<Point> surroundingPoints;
                        while ((surroundingPoints = PointGroupDeadendRemoverAlgo.getSurroundingPoints(linePointsContainer.getPointMap(), currentPoint)).size() > 0 && surroundingPoints.size() < 3) {
                            boolean removedPoint = false;
                            for (int k = 0; k < surroundingPoints.size(); ++k) {
                                if (!PointGroupDeadendRemoverAlgo.isOnTileBorder(surroundingPoints.get(k), tileSize)) {
                                    if (pointsToDelete.contains(surroundingPoints.get(k))) continue;
                                    pointsToDelete.add(currentPoint);
                                    currentPoint = surroundingPoints.get(k);
                                    removedPoint = true;
                                    continue;
                                }
                                pointsToDelete.add(currentPoint);
                            }
                            if (removedPoint) continue;
                            break block9;
                        }
                        if (pointsToDelete.size() == 0) {
                            pointsToDelete.add(currentPoint);
                        }
                    }
                    for (Point point : pointsToDelete) {
                        endpoints.remove(point);
                        linePointsContainer.removePoint(point);
                        cellOnLineBuffer.setValue((int)point.getX(), (int)point.getY(), z, false);
                    }
                    continue;
                }
                endpoints.remove(currentPoint);
            }
            for (int k = group.size() - 1; k >= 0; --k) {
                Point currentPoint = group.get(k);
                if (PointGroupDeadendRemoverAlgo.isOnTileBorder(currentPoint, tileSize) || !linePointsContainer.isStubble(currentPoint)) continue;
                linePointsContainer.removePoint(currentPoint);
                cellOnLineBuffer.setValue((int)currentPoint.getX(), (int)currentPoint.getY(), z, false);
            }
            ++groupCounter;
            if (group.size() != 0) continue;
            linePointsContainer.getGroups().remove(i);
        }
    }

    public static ArrayList<Point> getAllPointsWithOnlyOneNeighbor(ArrayList<Point> group, SrtmLinePointsContainer linePointsContainer) {
        ArrayList<Point> result = new ArrayList<Point>();
        for (int i = 0; i < group.size(); ++i) {
            Point currentPoint = group.get(i);
            ArrayList<Point> surroundingPoints = PointGroupDeadendRemoverAlgo.getSurroundingPoints(linePointsContainer.getPointMap(), currentPoint);
            if (surroundingPoints.size() != 1) continue;
            result.add(currentPoint);
        }
        return result;
    }
}

