/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.height.ITileCache;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.srtm.SrtmTileCache;
import de.wideportal.maprender.resources.srtm.cache.SrtmFlattenedTileCachePersister;
import de.wideportal.maprender.resources.srtm.voids.SrtmTileCell;
import de.wideportal.maprender.resources.srtm.voids.SrtmTileVoid;
import de.wideportal.maprender.resources.srtm.voids.SrtmTileVoidCache;
import de.wideportal.maprender.resources.srtm.voids.SrtmTileVoidCachePersister;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrtmTile
implements ITile {
    private static final long serialVersionUID = 9191573451940662843L;
    public static final float VOID_VALUE = -32768.0f;
    public static final int NW = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int W = 3;
    public static final int C = 4;
    public static final int E = 5;
    public static final int SW = 6;
    public static final int S = 7;
    public static final int SE = 8;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private float[][] rawBuffer;
    private float[][] voidlessBuffer;
    private float[][] flattenedBuffer;
    private int lat;
    private int lon;
    private int srtmTileSize;
    private int srtmBufferSize;
    private int heightDiffThreshold;
    private int heightPointDiffThreshold;
    private boolean loaded = false;
    private boolean voidless = false;
    private boolean flattened = false;
    private boolean mocked = false;
    private String fileName = null;
    private SrtmTileVoidCache voidCache = new SrtmTileVoidCache();

    public SrtmTile(int lat, int lon, int heightDiffThreshold, int heightPointDiffThreshold, SrtmTileCache srtmTileCache) {
        this.lat = lat;
        this.lon = lon;
        this.heightDiffThreshold = heightDiffThreshold;
        this.heightPointDiffThreshold = heightPointDiffThreshold;
    }

    private float[][] convertToArray(ShortBuffer shortBuffer) {
        int size = (int)Math.sqrt(shortBuffer.capacity());
        float[][] result = new float[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int index = size * i + j;
                result[i][j] = shortBuffer.get(index);
            }
        }
        return result;
    }

    @Override
    public boolean containsCell(double lon, double lat) {
        return (double)this.lat <= lat && (double)(this.lat + 1) > lat && (double)this.lon <= lon && (double)(this.lon + 1) > lon;
    }

    @Override
    public float[][] getRawBuffer() {
        return this.rawBuffer;
    }

    public float[][] getVoidlessBuffer() {
        return this.voidlessBuffer;
    }

    @Override
    public float[][] getFlattenedBuffer() {
        return this.flattenedBuffer;
    }

    public void setVoidless(boolean voidless) {
        this.voidless = voidless;
    }

    @Override
    public void setMockedRawBuffer(int tileSizeForMock, String fileName) {
        this.rawBuffer = new float[tileSizeForMock][tileSizeForMock];
        this.flattenedBuffer = new float[tileSizeForMock][tileSizeForMock];
        this.srtmTileSize = tileSizeForMock - 1;
        this.srtmBufferSize = tileSizeForMock;
        this.loaded = true;
        this.fileName = fileName;
        this.flattened = true;
        this.voidless = true;
        this.mocked = true;
    }

    @Override
    public void setRawBuffer(float[][] rawBuffer, String fileName) {
        this.rawBuffer = rawBuffer;
        this.srtmTileSize = rawBuffer.length - 1;
        this.srtmBufferSize = rawBuffer.length;
        this.loaded = true;
        this.fileName = fileName;
    }

    public void setRawBuffer(ShortBuffer shortBuffer, String fileName) {
        this.rawBuffer = this.convertToArray(shortBuffer);
        this.srtmTileSize = this.rawBuffer.length - 1;
        this.srtmBufferSize = this.rawBuffer.length;
        this.loaded = true;
        this.fileName = fileName;
    }

    public void testSetFlattenedBufferToSinus() {
        for (int y = 0; y < this.flattenedBuffer.length; ++y) {
            for (int x = 0; x < this.flattenedBuffer[y].length; ++x) {
                double sinY = (Math.sin((double)y / 1000.0) + 1.0) * 1000.0;
                double sinX = (Math.sin((double)x / 1000.0) + 1.0) * 1000.0;
                this.flattenedBuffer[y][x] = (float)(sinX + sinY);
            }
        }
        this.flattened = true;
    }

    @Override
    public int getLat() {
        return this.lat;
    }

    @Override
    public void setLat(int lat) {
        this.lat = lat;
    }

    @Override
    public int getLon() {
        return this.lon;
    }

    @Override
    public void setLon(int lon) {
        this.lon = lon;
    }

    @Override
    public int getTileSize() {
        return this.srtmTileSize;
    }

    public int getSrtmBufferSize() {
        return this.srtmBufferSize;
    }

    @Override
    public boolean isMocked() {
        return this.mocked;
    }

    @Override
    public void setMocked(boolean mocked) {
        this.mocked = mocked;
    }

    public boolean isVoidless() {
        return this.voidless;
    }

    @Override
    public boolean isFlattened() {
        return this.flattened;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return new BoundingBox(this.lon, this.lat, this.lon + 1, this.lat + 1);
    }

    @Override
    public int getHeightDiffThreshold() {
        return this.heightDiffThreshold;
    }

    @Override
    public void setHeightDiffThreshold(int heightDiffThreshold) {
        this.heightDiffThreshold = heightDiffThreshold;
    }

    @Override
    public int getHeightPointDiffThreshold() {
        return this.heightPointDiffThreshold;
    }

    @Override
    public void setHeightPointDiffThreshold(int heightPointDiffThreshold) {
        this.heightPointDiffThreshold = heightPointDiffThreshold;
    }

    @Override
    public ITile[] getSurroundingTiles(ITileCache srtmTileCache) {
        ITile[] tiles = new ITile[9];
        int counter = 0;
        for (int latShift = 1; latShift >= -1; --latShift) {
            for (int lonShift = -1; lonShift <= 1; ++lonShift) {
                ITile currentTile;
                tiles[counter] = currentTile = this.getSurroundingTile(srtmTileCache, lonShift, latShift);
                ++counter;
            }
        }
        return tiles;
    }

    @Override
    public ITile getSurroundingTile(ITileCache srtmTileCache, int lonShift, int latShift) {
        ITile currentTile = srtmTileCache.getCachedTile(this.lon + lonShift, this.lat + latShift, this.heightDiffThreshold, this.heightPointDiffThreshold);
        if (!currentTile.isLoaded()) {
            srtmTileCache.loadTile(currentTile, this.heightDiffThreshold);
        }
        return currentTile;
    }

    @Override
    public HeightCollectorTile renderIntoCollector(int zoom, int xTileIndex, int yTileIndex, RenderRequest renderRequest, HeightCollectorTile collector, AbstractMapTileOutput tileOutputter, ITileCache tileCache) {
        this.log.debug("renderIntoCollector: start rendering srtm tile " + this.fileName + " into collector tile");
        if (this.loaded) {
            if (!this.flattened) {
                this.log.debug("renderIntoCollector: start flattening srtm tile " + this.fileName);
                this.flatten(zoom, xTileIndex, yTileIndex, renderRequest);
                this.log.debug("renderIntoCollector: finished flattening srtm tile " + this.fileName);
            }
            BoundingBox collectorBBox = collector.getLatLonCollectFromBox();
            double cellSize = 1.0 / (double)this.srtmTileSize;
            double minRelevantLon = collectorBBox.getLeft();
            double maxRelevantLon = collectorBBox.getRight();
            double minRelevantLat = collectorBBox.getBottom();
            double maxRelevantLat = collectorBBox.getTop();
            int leftIndex = (int)Math.floor((minRelevantLon - (double)this.lon) / cellSize);
            int topIndex = (int)Math.floor(((double)this.lat + 1.0 - maxRelevantLat) / cellSize);
            int rightIndex = (int)Math.ceil((maxRelevantLon - (double)this.lon) / cellSize);
            int bottomIndex = (int)Math.ceil(((double)this.lat + 1.0 - minRelevantLat) / cellSize);
            boolean isWholeSrtmTileInCollectTile = false;
            if (leftIndex < 0 && topIndex < 0 && rightIndex > this.srtmBufferSize && bottomIndex > this.srtmBufferSize) {
                isWholeSrtmTileInCollectTile = true;
            }
            if (leftIndex < 0) {
                leftIndex = 0;
            }
            if (topIndex < 0) {
                topIndex = 0;
            }
            if (rightIndex > this.srtmBufferSize) {
                rightIndex = this.srtmBufferSize;
            }
            if (bottomIndex > this.srtmBufferSize) {
                bottomIndex = this.srtmBufferSize;
            }
            ITile[] surroundingTiles = null;
            if (!isWholeSrtmTileInCollectTile) {
                for (ITile surroundingTile : surroundingTiles = this.getSurroundingTiles(tileCache)) {
                    if (surroundingTile.isFlattened()) continue;
                    surroundingTile.flatten(zoom, xTileIndex, yTileIndex, renderRequest);
                }
            }
            for (int y = topIndex; y < bottomIndex; ++y) {
                for (int x = leftIndex; x < rightIndex; ++x) {
                    double cellShift = cellSize / 2.0;
                    double cellLeft = (double)this.lon + (double)x * cellSize - cellShift;
                    double cellRight = cellLeft + cellSize;
                    double cellTop = (double)(this.lat + 1) - (double)y * cellSize + cellShift;
                    double cellBottom = cellTop - cellSize;
                    float value = this.flattenedBuffer[y][x];
                    float[] srtmSurroundingCellHeights = new float[9];
                    srtmSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                    if (isWholeSrtmTileInCollectTile) {
                        collector.addValueSimple(cellLeft, cellTop, cellRight, cellBottom, zoom, value, tileOutputter);
                        continue;
                    }
                    if (x == 0 && y == 0) {
                        srtmSurroundingCellHeights[0] = surroundingTiles[0].getFlattenedBuffer()[this.srtmBufferSize - 2][this.srtmBufferSize - 2];
                        srtmSurroundingCellHeights[1] = surroundingTiles[1].getFlattenedBuffer()[this.srtmBufferSize - 2][x];
                        srtmSurroundingCellHeights[2] = surroundingTiles[1].getFlattenedBuffer()[this.srtmBufferSize - 2][x + 1];
                        srtmSurroundingCellHeights[3] = surroundingTiles[3].getFlattenedBuffer()[y][this.srtmBufferSize - 2];
                        srtmSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                        srtmSurroundingCellHeights[6] = surroundingTiles[3].getFlattenedBuffer()[y + 1][this.srtmBufferSize - 2];
                        srtmSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                        srtmSurroundingCellHeights[8] = this.flattenedBuffer[y + 1][x + 1];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, srtmSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (x == this.srtmBufferSize - 1 && y == 0) {
                        srtmSurroundingCellHeights[0] = surroundingTiles[1].getFlattenedBuffer()[this.srtmBufferSize - 2][x - 1];
                        srtmSurroundingCellHeights[1] = surroundingTiles[1].getFlattenedBuffer()[this.srtmBufferSize - 2][x];
                        srtmSurroundingCellHeights[2] = surroundingTiles[2].getFlattenedBuffer()[this.srtmBufferSize - 2][0];
                        srtmSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                        srtmSurroundingCellHeights[5] = surroundingTiles[5].getFlattenedBuffer()[y][0];
                        srtmSurroundingCellHeights[6] = this.flattenedBuffer[y + 1][x - 1];
                        srtmSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                        srtmSurroundingCellHeights[8] = surroundingTiles[5].getFlattenedBuffer()[y + 1][0];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, srtmSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (x == this.srtmBufferSize - 1 && y == this.srtmBufferSize - 1) {
                        srtmSurroundingCellHeights[0] = this.flattenedBuffer[y - 1][x - 1];
                        srtmSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                        srtmSurroundingCellHeights[2] = surroundingTiles[5].getFlattenedBuffer()[y - 1][0];
                        srtmSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                        srtmSurroundingCellHeights[5] = surroundingTiles[5].getFlattenedBuffer()[y][0];
                        srtmSurroundingCellHeights[6] = surroundingTiles[7].getFlattenedBuffer()[0][x - 1];
                        srtmSurroundingCellHeights[7] = surroundingTiles[7].getFlattenedBuffer()[0][x];
                        srtmSurroundingCellHeights[8] = surroundingTiles[8].getFlattenedBuffer()[0][0];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, srtmSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (x == 0 && y == this.srtmBufferSize - 1) {
                        srtmSurroundingCellHeights[0] = surroundingTiles[3].getFlattenedBuffer()[y - 1][this.srtmBufferSize - 2];
                        srtmSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                        srtmSurroundingCellHeights[2] = this.flattenedBuffer[y - 1][x + 1];
                        srtmSurroundingCellHeights[3] = surroundingTiles[3].getFlattenedBuffer()[y][this.srtmBufferSize - 2];
                        srtmSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                        srtmSurroundingCellHeights[6] = surroundingTiles[6].getFlattenedBuffer()[0][this.srtmBufferSize - 2];
                        srtmSurroundingCellHeights[7] = surroundingTiles[7].getFlattenedBuffer()[0][x];
                        srtmSurroundingCellHeights[8] = surroundingTiles[7].getFlattenedBuffer()[0][x + 1];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, srtmSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (x == 0) {
                        srtmSurroundingCellHeights[0] = surroundingTiles[3].getFlattenedBuffer()[y - 1][this.srtmBufferSize - 2];
                        srtmSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                        srtmSurroundingCellHeights[2] = this.flattenedBuffer[y - 1][x + 1];
                        srtmSurroundingCellHeights[3] = surroundingTiles[3].getFlattenedBuffer()[y][this.srtmBufferSize - 2];
                        srtmSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                        srtmSurroundingCellHeights[6] = surroundingTiles[3].getFlattenedBuffer()[y + 1][this.srtmBufferSize - 2];
                        srtmSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                        srtmSurroundingCellHeights[8] = this.flattenedBuffer[y + 1][x + 1];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, srtmSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (x == this.srtmBufferSize - 1) {
                        srtmSurroundingCellHeights[0] = this.flattenedBuffer[y - 1][x - 1];
                        srtmSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                        srtmSurroundingCellHeights[2] = surroundingTiles[5].getFlattenedBuffer()[y - 1][0];
                        srtmSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                        srtmSurroundingCellHeights[5] = surroundingTiles[5].getFlattenedBuffer()[y][0];
                        srtmSurroundingCellHeights[6] = this.flattenedBuffer[y + 1][x - 1];
                        srtmSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                        srtmSurroundingCellHeights[8] = surroundingTiles[5].getFlattenedBuffer()[y + 1][0];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, srtmSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (y == 0) {
                        srtmSurroundingCellHeights[0] = surroundingTiles[1].getFlattenedBuffer()[this.srtmBufferSize - 2][x - 1];
                        srtmSurroundingCellHeights[1] = surroundingTiles[1].getFlattenedBuffer()[this.srtmBufferSize - 2][x];
                        srtmSurroundingCellHeights[2] = surroundingTiles[1].getFlattenedBuffer()[this.srtmBufferSize - 2][x + 1];
                        srtmSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                        srtmSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                        srtmSurroundingCellHeights[6] = this.flattenedBuffer[y + 1][x - 1];
                        srtmSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                        srtmSurroundingCellHeights[8] = this.flattenedBuffer[y + 1][x + 1];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, srtmSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (y == this.srtmBufferSize - 1) {
                        srtmSurroundingCellHeights[0] = this.flattenedBuffer[y - 1][x - 1];
                        srtmSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                        srtmSurroundingCellHeights[2] = this.flattenedBuffer[y - 1][x + 1];
                        srtmSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                        srtmSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                        srtmSurroundingCellHeights[6] = surroundingTiles[7].getFlattenedBuffer()[0][x - 1];
                        srtmSurroundingCellHeights[7] = surroundingTiles[7].getFlattenedBuffer()[0][x];
                        srtmSurroundingCellHeights[8] = surroundingTiles[7].getFlattenedBuffer()[0][x + 1];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, srtmSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    srtmSurroundingCellHeights[0] = this.flattenedBuffer[y - 1][x - 1];
                    srtmSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                    srtmSurroundingCellHeights[2] = this.flattenedBuffer[y - 1][x + 1];
                    srtmSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                    srtmSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                    srtmSurroundingCellHeights[6] = this.flattenedBuffer[y + 1][x - 1];
                    srtmSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                    srtmSurroundingCellHeights[8] = this.flattenedBuffer[y + 1][x + 1];
                    collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, srtmSurroundingCellHeights, tileOutputter);
                }
            }
        }
        this.log.debug("renderIntoCollector: finished renderering srtm tile " + this.fileName + " into collector tile");
        return collector;
    }

    private float getRawHeightIncludingSurroundingTiles(SrtmTileCache srtmTileCache, int x, int y) {
        if (x >= 0 && x < this.srtmBufferSize && y >= 0 && y < this.srtmBufferSize) {
            return this.rawBuffer[y][x];
        }
        if (x < -this.srtmBufferSize || x >= 2 * this.srtmBufferSize || y < -this.srtmBufferSize && y >= 2 * this.srtmBufferSize) {
            return 0.0f;
        }
        if (x < 0 && y >= 0 && y < this.srtmBufferSize) {
            SrtmTile tile = (SrtmTile)this.getSurroundingTile(srtmTileCache, -1, 0);
            return tile.getRawHeightIncludingSurroundingTiles(srtmTileCache, x + this.srtmBufferSize - 1, y);
        }
        if (x >= this.srtmBufferSize && y >= 0 && y < this.srtmBufferSize) {
            SrtmTile tile = (SrtmTile)this.getSurroundingTile(srtmTileCache, 1, 0);
            return tile.getRawHeightIncludingSurroundingTiles(srtmTileCache, x - this.srtmBufferSize, y);
        }
        if (x >= 0 && x < this.srtmBufferSize && y < 0) {
            SrtmTile tile = (SrtmTile)this.getSurroundingTile(srtmTileCache, 0, 1);
            return tile.getRawHeightIncludingSurroundingTiles(srtmTileCache, x, y + this.srtmBufferSize - 1);
        }
        if (x >= 0 && x < this.srtmBufferSize && y >= this.srtmBufferSize) {
            SrtmTile tile = (SrtmTile)this.getSurroundingTile(srtmTileCache, 0, -1);
            return tile.getRawHeightIncludingSurroundingTiles(srtmTileCache, x, y - this.srtmBufferSize);
        }
        if (x < 0 && y < 0) {
            SrtmTile tile = (SrtmTile)this.getSurroundingTile(srtmTileCache, -1, -1);
            return tile.getRawHeightIncludingSurroundingTiles(srtmTileCache, x + this.srtmBufferSize - 1, y + this.srtmBufferSize - 1);
        }
        if (x >= this.srtmBufferSize && y < 0) {
            SrtmTile tile = (SrtmTile)this.getSurroundingTile(srtmTileCache, 1, 1);
            return tile.getRawHeightIncludingSurroundingTiles(srtmTileCache, x - this.srtmBufferSize, y + this.srtmBufferSize - 1);
        }
        if (x >= this.srtmBufferSize && y >= this.srtmBufferSize) {
            SrtmTile tile = (SrtmTile)this.getSurroundingTile(srtmTileCache, 1, -1);
            return tile.getRawHeightIncludingSurroundingTiles(srtmTileCache, x - this.srtmBufferSize, y - this.srtmBufferSize);
        }
        if (x < 0 && y >= this.srtmBufferSize) {
            SrtmTile tile = (SrtmTile)this.getSurroundingTile(srtmTileCache, -1, -1);
            return tile.getRawHeightIncludingSurroundingTiles(srtmTileCache, x + this.srtmBufferSize - 1, y - this.srtmBufferSize);
        }
        return -32768.0f;
    }

    private ArrayList<SrtmTileCell> findNonVoidSurroundingCells(SrtmTileCache srtmTileCache, int x, int y) {
        ArrayList<SrtmTileCell> result = new ArrayList<SrtmTileCell>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float height;
                if (i == 0 && j == 0 || !((height = this.getRawHeightIncludingSurroundingTiles(srtmTileCache, x + i, y + j)) > -32768.0f)) continue;
                result.add(new SrtmTileCell(x + i, y + j, height));
            }
        }
        return result;
    }

    private ArrayList<SrtmTileCell> findVoidSurroundingCells(SrtmTileCache srtmTileCache, int x, int y) {
        ArrayList<SrtmTileCell> result = new ArrayList<SrtmTileCell>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float height;
                if (i == 0 && j == 0 || (height = this.getRawHeightIncludingSurroundingTiles(srtmTileCache, x + i, y + j)) != -32768.0f) continue;
                result.add(new SrtmTileCell(x + i, y + j, height));
            }
        }
        return result;
    }

    private SrtmTileVoid findOutlines(SrtmTileCache srtmTileCache, int x, int y) {
        float height = this.rawBuffer[y][x];
        if (height == -32768.0f) {
            SrtmTileVoid knownVoid = this.voidCache.getVoid(x, y);
            if (knownVoid != null) {
                return knownVoid;
            }
            SrtmTileVoid srtmTileVoid = new SrtmTileVoid();
            ArrayList<SrtmTileCell> voidCellsToCheck = new ArrayList<SrtmTileCell>();
            voidCellsToCheck.add(new SrtmTileCell(x, y, height));
            while (voidCellsToCheck.size() > 0) {
                ArrayList<SrtmTileCell> newCellsToCheck = new ArrayList<SrtmTileCell>();
                for (int i = voidCellsToCheck.size() - 1; i >= 0; --i) {
                    int currentX = ((SrtmTileCell)voidCellsToCheck.get(i)).getX();
                    int currentY = ((SrtmTileCell)voidCellsToCheck.get(i)).getY();
                    ArrayList<SrtmTileCell> surroundingVoidCells = this.findVoidSurroundingCells(srtmTileCache, currentX, currentY);
                    for (int j = 0; j < surroundingVoidCells.size(); ++j) {
                        SrtmTileCell currentCell = surroundingVoidCells.get(j);
                        if (voidCellsToCheck.contains(currentCell) || srtmTileVoid.containsVoidCell(currentCell) || newCellsToCheck.contains(currentCell)) continue;
                        newCellsToCheck.add(currentCell);
                    }
                    ArrayList<SrtmTileCell> surroundingNonVoidCells = this.findNonVoidSurroundingCells(srtmTileCache, currentX, currentY);
                    for (int j = 0; j < surroundingNonVoidCells.size(); ++j) {
                        SrtmTileCell currentCell = surroundingNonVoidCells.get(j);
                        if (srtmTileVoid.containsOutlineCell(currentCell)) continue;
                        srtmTileVoid.addOutline(currentCell);
                    }
                    srtmTileVoid.addVoid((SrtmTileCell)voidCellsToCheck.get(i));
                    voidCellsToCheck.remove(i);
                }
                voidCellsToCheck.addAll(newCellsToCheck);
            }
            this.voidCache.addVoidReference(srtmTileVoid);
            return srtmTileVoid;
        }
        return null;
    }

    public void removeVoids(SrtmTileCache srtmTileCache) {
        SrtmTileVoidCache loadedVoidCache;
        this.log.info("removeVoids: removing voids in tile " + this.fileName);
        this.voidlessBuffer = new float[this.srtmBufferSize][this.srtmBufferSize];
        SrtmTileVoidCachePersister voidCachePersister = srtmTileCache.getVoidCachePersister();
        boolean voidWasLoadedFromFile = false;
        if (voidCachePersister != null && (loadedVoidCache = voidCachePersister.load(this.fileName)) != null) {
            this.log.info("removeVoids: loaded void cache from file: " + this.fileName + ".voidcache");
            voidWasLoadedFromFile = true;
            this.voidCache = loadedVoidCache;
        }
        for (int y = 0; y < this.srtmBufferSize; ++y) {
            for (int x = 0; x < this.srtmBufferSize; ++x) {
                float height = this.rawBuffer[y][x];
                if (height > -32768.0f) {
                    this.voidlessBuffer[y][x] = height;
                    continue;
                }
                SrtmTileVoid cachedVoid = this.voidCache.getVoid(x, y);
                SrtmTileCell correctedCell = null;
                if (cachedVoid != null) {
                    correctedCell = cachedVoid.getCorrectedVoid(x, y);
                }
                if (correctedCell != null) {
                    this.voidlessBuffer[y][x] = correctedCell.getValue();
                    continue;
                }
                SrtmTileVoid srtmTileVoid = this.findOutlines(srtmTileCache, x, y);
                ArrayList<SrtmTileCell> voidOutlines = srtmTileVoid.getDistanceSortedOutline(x, y);
                int indexMaxEight = Math.min(8, voidOutlines.size() - 1);
                float maxNearestEightDistance = voidOutlines.get(indexMaxEight).getDistance(x, y);
                int indexMaxDistance = voidOutlines.size() - 1;
                for (int i = 0; i < voidOutlines.size(); ++i) {
                    float distance = voidOutlines.get(i).getDistance(x, y);
                    if (!(distance > maxNearestEightDistance * 2.0f)) continue;
                    indexMaxDistance = i - 1;
                    break;
                }
                float totalDistanceMultiplicators = 0.0f;
                for (int i = 0; i < indexMaxDistance; ++i) {
                    float distance = voidOutlines.get(i).getDistance(x, y);
                    totalDistanceMultiplicators = (float)((double)totalDistanceMultiplicators + 1.0 / Math.pow(distance, 3.0));
                }
                float totalDistanceWeight = 1.0f / totalDistanceMultiplicators;
                float newHeight = 0.0f;
                for (int i = 0; i < indexMaxDistance; ++i) {
                    float distance = voidOutlines.get(i).getDistance(x, y);
                    newHeight = (float)((double)newHeight + (double)voidOutlines.get(i).getValue() * (1.0 / Math.pow(distance, 3.0)) * (double)totalDistanceWeight);
                }
                this.voidlessBuffer[y][x] = newHeight;
                srtmTileVoid.addCorrectedVoid(new SrtmTileCell(x, y, newHeight));
            }
        }
        if (!voidWasLoadedFromFile && voidCachePersister != null) {
            this.log.info("removeVoids: saving void cache to file: " + this.fileName);
            voidCachePersister.persist(this.fileName, this.voidCache);
        }
        this.voidless = true;
    }

    @Override
    public void flatten(int zoom, int xTileIndex, int yTileIndex, RenderRequest renderRequest) {
        if (!this.voidless) {
            this.removeVoids((SrtmTileCache)renderRequest.getHeightTileAccessor().getTileCache());
        } else {
            this.voidlessBuffer = this.rawBuffer;
        }
        if (this.heightDiffThreshold <= 0) {
            this.flattenedBuffer = this.voidlessBuffer;
            return;
        }
        this.log.info("flatten: flatten tile " + this.fileName);
        this.flattenedBuffer = new float[this.srtmBufferSize][this.srtmBufferSize];
        int miniLevelRadius = 1;
        for (int y = 0; y < this.srtmBufferSize; ++y) {
            for (int x = 0; x < this.srtmBufferSize; ++x) {
                float averageSurroundingHeight;
                float diff;
                float height = this.voidlessBuffer[y][x];
                if (y == 0 || x == 0 || y == this.srtmBufferSize - 1 || x == this.srtmBufferSize - 1) {
                    this.flattenedBuffer[y][x] = height;
                    continue;
                }
                int leftLevelIndex = x - miniLevelRadius;
                int rightLevelIndex = x + miniLevelRadius;
                int topLevelIndex = y - miniLevelRadius;
                int bottomLevelIndex = y + miniLevelRadius;
                float surroundingHeights = 0.0f;
                float surroundingHeightPoints = 0.0f;
                for (int i = leftLevelIndex; i <= rightLevelIndex; ++i) {
                    for (int j = topLevelIndex; j <= bottomLevelIndex; ++j) {
                        if (i == x && j == y) continue;
                        surroundingHeights += this.voidlessBuffer[j][i];
                        surroundingHeightPoints += 1.0f;
                    }
                }
                if (surroundingHeightPoints == 0.0f) {
                    surroundingHeights = height;
                    surroundingHeightPoints = 1.0f;
                }
                this.flattenedBuffer[y][x] = (diff = Math.abs((averageSurroundingHeight = surroundingHeights / surroundingHeightPoints) - height)) < (float)this.heightPointDiffThreshold ? averageSurroundingHeight : height;
            }
        }
        float[][] newValues = new float[this.srtmBufferSize][this.srtmBufferSize];
        int levelRadius = 5;
        for (int y = 0; y < this.srtmBufferSize; ++y) {
            for (int x = 0; x < this.srtmBufferSize; ++x) {
                int currentX;
                int xI;
                int currentY;
                int yI;
                int bottomLevelIndex;
                int topLevelIndex;
                int rightLevelIndex;
                float height = this.flattenedBuffer[y][x];
                int leftLevelIndex = x - levelRadius;
                if (leftLevelIndex < 0) {
                    leftLevelIndex = 0;
                }
                if ((rightLevelIndex = x + levelRadius) > this.srtmBufferSize) {
                    rightLevelIndex = this.srtmBufferSize;
                }
                if (rightLevelIndex == leftLevelIndex) {
                    rightLevelIndex = leftLevelIndex + 1;
                }
                if ((topLevelIndex = y - levelRadius) < 0) {
                    topLevelIndex = 0;
                }
                if ((bottomLevelIndex = y + levelRadius) > this.srtmBufferSize) {
                    bottomLevelIndex = this.srtmBufferSize;
                }
                if (bottomLevelIndex == topLevelIndex) {
                    bottomLevelIndex = topLevelIndex + 1;
                }
                float totalValues = 0.0f;
                float counter = 0.0f;
                boolean[][] isOverThresholdArray = new boolean[2 * levelRadius + 1][2 * levelRadius + 1];
                for (yI = 0; yI < 2 * levelRadius + 1; ++yI) {
                    for (int xI2 = 0; xI2 < 2 * levelRadius + 1; ++xI2) {
                        isOverThresholdArray[yI][xI2] = false;
                    }
                }
                for (yI = 0; yI < 2 * levelRadius + 1; ++yI) {
                    currentY = y - levelRadius + yI;
                    if (currentY < topLevelIndex || currentY >= bottomLevelIndex) continue;
                    for (xI = 0; xI < 2 * levelRadius + 1; ++xI) {
                        float currentHeight;
                        float heightDelta;
                        currentX = x - levelRadius + xI;
                        if (currentX < leftLevelIndex || currentX >= rightLevelIndex || !((heightDelta = Math.abs((currentHeight = this.flattenedBuffer[currentY][currentX]) - height)) > (float)this.heightDiffThreshold)) continue;
                        this.safeSetBooleanArray(isOverThresholdArray, xI - 1, yI - 1, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI, yI - 1, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI + 1, yI - 1, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI - 1, yI, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI, yI, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI + 1, yI, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI - 1, yI + 1, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI, yI + 1, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI + 1, yI + 1, true);
                    }
                }
                for (yI = 0; yI < 2 * levelRadius + 1; ++yI) {
                    currentY = y - levelRadius + yI;
                    if (currentY < topLevelIndex || currentY >= bottomLevelIndex) continue;
                    for (xI = 0; xI < 2 * levelRadius + 1; ++xI) {
                        currentX = x - levelRadius + xI;
                        if (currentX < leftLevelIndex || currentX >= rightLevelIndex || isOverThresholdArray[yI][xI] || !this.IsArrayAccessible(this.flattenedBuffer, currentX, currentY)) continue;
                        totalValues += this.flattenedBuffer[currentY][currentX];
                        counter += 1.0f;
                    }
                }
                newValues[y][x] = counter == 0.0f ? height : totalValues / counter;
            }
        }
        this.flattenedBuffer = newValues;
        this.flattened = true;
        String flattenedCacheBaseFolder = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getDatasources().getSrtm().getFlattenedCache();
        if (flattenedCacheBaseFolder != null) {
            SrtmFlattenedTileCachePersister flattenedTileCachePersister = new SrtmFlattenedTileCachePersister(flattenedCacheBaseFolder);
            flattenedTileCachePersister.persist(zoom, xTileIndex, yTileIndex, this, this.heightDiffThreshold);
        }
    }

    private void safeSetBooleanArray(boolean[][] array, int x, int y, boolean value) {
        if (this.IsArrayAccessible(array, x, y)) {
            array[y][x] = value;
        }
    }

    private boolean IsArrayAccessible(boolean[][] array, int x, int y) {
        int arraySize = array.length;
        return x >= 0 && x < arraySize && y >= 0 && y < arraySize;
    }

    private boolean IsArrayAccessible(float[][] array, int x, int y) {
        int arraySize = array.length;
        return x >= 0 && x <= arraySize && y >= 0 && y <= arraySize;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SrtmTile)) {
            return false;
        }
        SrtmTile otherTile = (SrtmTile)other;
        return this.lat == otherTile.lat && this.lon == otherTile.lon && this.heightDiffThreshold == otherTile.heightDiffThreshold;
    }

    @Override
    public void logBufferFlattened() {
        for (int y = 0; y < this.flattenedBuffer.length; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = 0; x < this.flattenedBuffer[y].length; ++x) {
                float value = this.flattenedBuffer[y][x];
                if (value != 0.0f) {
                    rowBuffy.append("1");
                    continue;
                }
                rowBuffy.append("0");
            }
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String toString() {
        return "SrtmTile[lon=" + this.lon + ", lat=" + this.lat + ", loaded=" + this.loaded + ", heightDiffThreshold=" + this.heightDiffThreshold + ", size=[" + this.rawBuffer.length + "][" + this.rawBuffer[0].length + "]]";
    }
}

