/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm;

import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.srtm.algos.PointGroupAlgo;
import java.util.ArrayList;

public class SrtmLineHeightContainer {
    private int height = 0;
    private int zIndex = 0;
    private ArrayList<LineSequence> heightLines = new ArrayList();

    public SrtmLineHeightContainer(int height, int zIndex) {
        this.height = height;
        this.zIndex = zIndex;
    }

    public int getHeight() {
        return this.height;
    }

    public int getzIndex() {
        return this.zIndex;
    }

    public ArrayList<LineSequence> getHeightLines() {
        return this.heightLines;
    }

    public void addLineSequence(LineSequence lineSequence) {
        if (lineSequence.getLines().size() > 0) {
            this.heightLines.add(lineSequence);
        }
    }

    public void flagStartStopPoints() {
        for (LineSequence lineSequence : this.heightLines) {
            lineSequence.flagStartStopPoints();
        }
    }

    public void removeSmallLines(int minLength, long tileSize) {
        for (int k = this.heightLines.size() - 1; k >= 0; --k) {
            if (!(this.heightLines.get(k).getLength() < (double)minLength)) continue;
            boolean isAnyPointOnBorder = false;
            for (Point point : this.heightLines.get(k).getPoints()) {
                if (!PointGroupAlgo.isOnTileBorder(point, tileSize)) continue;
                isAnyPointOnBorder = true;
                break;
            }
            if (isAnyPointOnBorder) continue;
            this.heightLines.remove(k);
        }
    }

    public void removeSmallCyclicLines(int minLength) {
        for (int k = this.heightLines.size() - 1; k >= 0; --k) {
            if (!this.heightLines.get(k).isCyclic() || !(this.heightLines.get(k).getLength() < (double)minLength)) continue;
            this.heightLines.remove(k);
        }
    }

    public boolean hasLines() {
        return this.heightLines.size() > 0;
    }

    public void logBuffer(long tileSize) {
        System.out.println("################################################# logBuffer SrtmLineHeightContainer z=" + this.zIndex);
        int y = 0;
        while ((long)y < tileSize) {
            StringBuffer rowBuffy = new StringBuffer();
            int x = 0;
            while ((long)x < tileSize) {
                boolean found = false;
                block2: for (LineSequence lineSequence : this.heightLines) {
                    if (found) continue;
                    for (Line line : lineSequence.getLines()) {
                        if ((line.getStart().getX() != (double)x || line.getStart().getY() != (double)y) && (line.getStop().getX() != (double)x || line.getStop().getY() != (double)y)) continue;
                        found = true;
                        continue block2;
                    }
                }
                if (found) {
                    rowBuffy.append("x");
                } else {
                    rowBuffy.append(" ");
                }
                ++x;
            }
            System.out.println("######################### " + y + ": " + rowBuffy.toString());
            ++y;
        }
    }
}

