/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.output.format;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.output.format.AbstractSlippyMapTileOutput;
import org.openstreetmap.gui.jmapviewer.OsmMercator;

public class SlippyMapTiles
extends AbstractSlippyMapTileOutput {
    public static final double MM_PER_PIXEL_FACTOR = 0.155;
    public static final String NAME = "slippymap";
    private OsmMercator mercatorProjection = new OsmMercator(256);

    @Override
    public String getMapTileOutputName() {
        return NAME;
    }

    @Override
    public double getMeterPerTile(double zoom, double latDegree) {
        return 4.007501668557849E7 * Math.cos(Math.toRadians(latDegree)) / Math.pow(2.0, zoom);
    }

    @Override
    public double getMeterPerPixel(double zoom, double latDegree) {
        return this.getMeterPerTile(zoom, latDegree) / 256.0;
    }

    @Override
    public Point getMinTileIndex(double leftLonDegree, double topLatDegree, double zoom) {
        double xTileIndex = (int)Math.floor((leftLonDegree + 180.0) / 360.0 * (double)(1 << (int)zoom));
        double yValue = (1.0 - Math.log(Math.tan(Math.toRadians(topLatDegree)) + 1.0 / Math.cos(Math.toRadians(topLatDegree))) / Math.PI) / 2.0 * (double)(1 << (int)zoom);
        int yTileIndex = (int)Math.floor(yValue);
        if (yTileIndex < 0) {
            yTileIndex = 0;
        }
        return new Point(xTileIndex, yTileIndex);
    }

    @Override
    public Point getMaxTileIndex(double rightLonDegree, double bottomLatDegree, double zoom) {
        double xValue = (rightLonDegree + 180.0) / 360.0 * (double)((1 << (int)zoom) - 1);
        double xTileIndex = (int)Math.ceil(xValue);
        double yValue = (1.0 - Math.log(Math.tan(Math.toRadians(bottomLatDegree)) + 1.0 / Math.cos(Math.toRadians(bottomLatDegree))) / Math.PI) / 2.0 * (double)(1 << (int)zoom);
        int yTileIndex = (int)Math.floor(yValue);
        if (yTileIndex < 0) {
            yTileIndex = 0;
        }
        if (yTileIndex >= 1 << (int)zoom) {
            yTileIndex = (1 << (int)zoom) - 1;
        }
        return new Point(xTileIndex, yTileIndex);
    }

    @Override
    public BoundingBox getMinMaxTileBoundingBox(BoundingBox latLonBoundingBox, double zoom) {
        Point minTileIndex = this.getMinTileIndex(latLonBoundingBox.getLeft(), latLonBoundingBox.getTop(), zoom);
        Point maxTileIndex = this.getMaxTileIndex(latLonBoundingBox.getRight(), latLonBoundingBox.getBottom(), zoom);
        return new BoundingBox(minTileIndex, maxTileIndex);
    }

    @Override
    public BoundingBox getBoundingBoxForTile(int zoom, int x, int y) {
        BoundingBox bb = new BoundingBox(this.getLonForTile(x, zoom), this.getLatForTile(y + 1, zoom), this.getLonForTile(x + 1, zoom), this.getLatForTile(y, zoom));
        return bb;
    }

    private double getLonForTile(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    private double getLatForTile(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    @Override
    public Point getLonLatToPixel(double lon, double lat, double zoom) {
        double x = this.mercatorProjection.lonToX(lon, (int)zoom);
        double y = this.mercatorProjection.latToY(lat, (int)zoom);
        return new Point(x, y);
    }

    @Override
    public Point getPixelToLonLat(double x, double y, double zoom) {
        double lat = this.mercatorProjection.yToLat((long)y, (int)zoom);
        double lon = this.mercatorProjection.xToLon((long)x, (int)zoom);
        return new Point(lon, lat);
    }

    public String toString() {
        return "SlippyMapTiles[]";
    }
}

