/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.jaxa;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxaZipExtractor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static int totalFileCount = 0;
    private static int currentFileCount = 0;

    public static void main(String[] args) {
        String inputFolder = "/home/hola/Entwicklung/Projects/Maprender/data/input/jaxa/download";
        String outputFolder = "/home/hola/Entwicklung/Projects/Maprender/data/input/jaxa/extracted2";
        JaxaZipExtractor instance = new JaxaZipExtractor();
        instance.extractFolder(inputFolder, outputFolder);
    }

    public void extractFolder(String inputFolderString, String outputFolderString) {
        try {
            File outputFolder = new File(outputFolderString);
            if (!outputFolder.exists()) {
                outputFolder.mkdirs();
            }
            Path dir = Paths.get(inputFolderString, new String[0]);
            Files.walk(dir, new FileVisitOption[0]).forEach(path -> ++totalFileCount);
            Files.walk(dir, new FileVisitOption[0]).forEach(path -> this.extractFile(path.toFile(), outputFolder));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.log.info("Done");
    }

    public void extractFile(File inputFile, File outputFolder) {
        if (inputFile.exists() && inputFile.getAbsolutePath().endsWith(".zip")) {
            ++currentFileCount;
            try (FileInputStream fis = new FileInputStream(inputFile);
                 BufferedInputStream bis = new BufferedInputStream(fis);
                 ZipInputStream stream = new ZipInputStream(bis);){
                ZipEntry entry = null;
                while ((entry = stream.getNextEntry()) != null) {
                    String fileEndingLowercase;
                    String entryLowercase = entry.getName().toLowerCase();
                    if (!entryLowercase.endsWith(fileEndingLowercase = "_dsm.tif")) continue;
                    byte[] allBytes = stream.readAllBytes();
                    String fileName = entry.getName();
                    fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                    String filenamePrefixToIgnore = "ALPSMLC30_";
                    String filenameSuffixToIgnore = "_DSM.tif";
                    String latLonPart = fileName.substring(filenamePrefixToIgnore.length());
                    latLonPart = latLonPart.substring(0, latLonPart.indexOf(filenameSuffixToIgnore));
                    String newZipFilePath = outputFolder.getAbsolutePath() + File.separator + latLonPart + ".zip";
                    try (FileOutputStream fout = new FileOutputStream(newZipFilePath);
                         ZipOutputStream zos = new ZipOutputStream(fout);){
                        ZipEntry innerFile = new ZipEntry(latLonPart + "/" + latLonPart + filenameSuffixToIgnore);
                        zos.putNextEntry(innerFile);
                        zos.write(allBytes, 0, allBytes.length);
                    }
                    catch (IOException e) {
                        this.log.error("persist: could not write to file: " + newZipFilePath, (Throwable)e);
                    }
                    this.log.info("extractFile: extracted file " + currentFileCount + "/" + totalFileCount + " : " + inputFile.getName() + "[" + entry.getName() + "] -> " + newZipFilePath);
                }
            }
            catch (Exception e) {
                this.log.error("extractFile: could not extract file: " + inputFile, (Throwable)e);
            }
        }
    }
}

