/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.jaxa;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.height.ITileCache;
import de.wideportal.maprender.resources.jaxa.JaxaTileCache;
import de.wideportal.maprender.resources.jaxa.cache.JaxaFlattenedTileCachePersister;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxaTile
implements ITile {
    private static final long serialVersionUID = -9178130789447658084L;
    public static final float VOID_VALUE = -32768.0f;
    public static final int NW = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int W = 3;
    public static final int C = 4;
    public static final int E = 5;
    public static final int SW = 6;
    public static final int S = 7;
    public static final int SE = 8;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private float[][] rawBuffer;
    private float[][] flattenedBuffer;
    private int lat;
    private int lon;
    private int jaxaTileSize;
    private int heightDiffThreshold;
    private int heightPointDiffThreshold;
    private boolean loaded = false;
    private boolean flattened = false;
    private boolean mocked = false;
    private String fileName = null;

    public JaxaTile(int lat, int lon, int heightDiffThreshold, int heightPointDiffThreshold) {
        this.lat = lat;
        this.lon = lon;
        this.heightDiffThreshold = heightDiffThreshold;
        this.heightPointDiffThreshold = heightPointDiffThreshold;
    }

    @Override
    public boolean containsCell(double lon, double lat) {
        return (double)this.lat <= lat && (double)(this.lat + 1) > lat && (double)this.lon <= lon && (double)(this.lon + 1) > lon;
    }

    @Override
    public float[][] getRawBuffer() {
        return this.rawBuffer;
    }

    @Override
    public float[][] getFlattenedBuffer() {
        return this.flattenedBuffer;
    }

    @Override
    public void setMockedRawBuffer(int tileSizeForMock, String fileName) {
        this.fileName = fileName;
        this.rawBuffer = new float[tileSizeForMock][tileSizeForMock];
        this.flattenedBuffer = new float[tileSizeForMock][tileSizeForMock];
        this.jaxaTileSize = tileSizeForMock;
        this.loaded = true;
        this.flattened = true;
        this.mocked = true;
    }

    @Override
    public void setRawBuffer(float[][] rawBuffer, String fileName) {
        this.fileName = fileName;
        this.rawBuffer = rawBuffer;
        this.jaxaTileSize = rawBuffer.length;
        this.loaded = true;
    }

    public void setRawBuffer(BufferedImage bufferedImage, String fileName) {
        this.fileName = fileName;
        this.rawBuffer = this.convertToArray(bufferedImage);
        this.jaxaTileSize = this.rawBuffer.length;
        this.loaded = true;
    }

    private float[][] convertToArray(BufferedImage bufferedImage) {
        Raster raster = bufferedImage.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int size = Math.max(width, height);
        float[][] result = new float[size][size];
        double ratioX = (double)width / (double)size;
        double ratioY = (double)height / (double)size;
        float[] valuePixel = new float[5];
        float[][] stretched = new float[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int x = (int)((double)i * ratioX);
                int y = (int)((double)j * ratioY);
                valuePixel = raster.getPixel(x, y, valuePixel);
                stretched[j][i] = valuePixel[0];
            }
        }
        result = stretched;
        return result;
    }

    @Override
    public int getLat() {
        return this.lat;
    }

    @Override
    public void setLat(int lat) {
        this.lat = lat;
    }

    @Override
    public int getLon() {
        return this.lon;
    }

    @Override
    public void setLon(int lon) {
        this.lon = lon;
    }

    @Override
    public int getTileSize() {
        return this.jaxaTileSize;
    }

    @Override
    public boolean isMocked() {
        return this.mocked;
    }

    @Override
    public void setMocked(boolean mocked) {
        this.mocked = mocked;
    }

    @Override
    public boolean isFlattened() {
        return this.flattened;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return new BoundingBox(this.lon, this.lat, this.lon + 1, this.lat + 1);
    }

    @Override
    public int getHeightDiffThreshold() {
        return this.heightDiffThreshold;
    }

    @Override
    public void setHeightDiffThreshold(int heightDiffThreshold) {
        this.heightDiffThreshold = heightDiffThreshold;
    }

    @Override
    public int getHeightPointDiffThreshold() {
        return this.heightPointDiffThreshold;
    }

    @Override
    public void setHeightPointDiffThreshold(int heightPointDiffThreshold) {
        this.heightPointDiffThreshold = heightPointDiffThreshold;
    }

    @Override
    public ITile[] getSurroundingTiles(ITileCache jaxaTileCache) {
        ITile[] tiles = new JaxaTile[9];
        int counter = 0;
        for (int latShift = 1; latShift >= -1; --latShift) {
            for (int lonShift = -1; lonShift <= 1; ++lonShift) {
                JaxaTile currentTile = (JaxaTile)this.getSurroundingTile(jaxaTileCache, lonShift, latShift);
                tiles[counter] = currentTile;
                ++counter;
            }
        }
        return tiles;
    }

    @Override
    public ITile getSurroundingTile(ITileCache jaxaTileCache, int lonShift, int latShift) {
        ITile currentTile = jaxaTileCache.getCachedTile(this.lon + lonShift, this.lat + latShift, this.heightDiffThreshold, this.heightPointDiffThreshold);
        if (!currentTile.isLoaded()) {
            jaxaTileCache.loadTile(currentTile, this.heightDiffThreshold);
        }
        return currentTile;
    }

    @Override
    public HeightCollectorTile renderIntoCollector(int zoom, int xTileIndex, int yTileIndex, RenderRequest renderRequest, HeightCollectorTile collector, AbstractMapTileOutput tileOutputter, ITileCache tileCache) {
        this.log.debug("renderIntoCollector: start rendering jaxa tile " + this.fileName + " into collector tile");
        if (this.loaded) {
            if (!this.flattened) {
                this.log.debug("renderIntoCollector: start flattening jaxa tile " + this.fileName);
                this.flatten(zoom, xTileIndex, yTileIndex, renderRequest);
                this.log.debug("renderIntoCollector: finished flattening jaxa tile " + this.fileName);
            }
            BoundingBox collectorBBox = collector.getLatLonCollectFromBox();
            double cellSize = 1.0 / (double)this.jaxaTileSize;
            double minRelevantLon = collectorBBox.getLeft();
            double maxRelevantLon = collectorBBox.getRight();
            double minRelevantLat = collectorBBox.getBottom();
            double maxRelevantLat = collectorBBox.getTop();
            int leftIndex = (int)Math.floor((minRelevantLon - (double)this.lon) / cellSize);
            int topIndex = (int)Math.floor(((double)this.lat + 1.0 - maxRelevantLat) / cellSize);
            int rightIndex = (int)Math.ceil((maxRelevantLon - (double)this.lon) / cellSize);
            int bottomIndex = (int)Math.ceil(((double)this.lat + 1.0 - minRelevantLat) / cellSize);
            boolean isWholeJaxaTileInCollectTile = false;
            if (leftIndex < 0 && topIndex < 0 && rightIndex > this.jaxaTileSize && bottomIndex > this.jaxaTileSize) {
                isWholeJaxaTileInCollectTile = true;
            }
            if (leftIndex < 0) {
                leftIndex = 0;
            }
            if (topIndex < 0) {
                topIndex = 0;
            }
            if (rightIndex > this.jaxaTileSize) {
                rightIndex = this.jaxaTileSize;
            }
            if (bottomIndex > this.jaxaTileSize) {
                bottomIndex = this.jaxaTileSize;
            }
            boolean isJaxaTileOnBorder = false;
            if (leftIndex == 0 || topIndex == 0 || rightIndex == this.jaxaTileSize || bottomIndex == this.jaxaTileSize) {
                isJaxaTileOnBorder = true;
            }
            ITile[] surroundingTiles = null;
            if (!isWholeJaxaTileInCollectTile) {
                for (ITile surroundingTile : surroundingTiles = this.getSurroundingTiles(tileCache)) {
                    if (surroundingTile.isFlattened()) continue;
                    surroundingTile.flatten(zoom, xTileIndex, yTileIndex, renderRequest);
                }
            }
            for (int y = topIndex; y < bottomIndex; ++y) {
                for (int x = leftIndex; x < rightIndex; ++x) {
                    double cellShift = cellSize / 2.0;
                    double cellLeft = (double)this.lon + (double)x * cellSize - cellShift;
                    double cellRight = cellLeft + cellSize;
                    double cellTop = (double)(this.lat + 1) - (double)y * cellSize + cellShift;
                    double cellBottom = cellTop - cellSize;
                    float value = this.flattenedBuffer[y][x];
                    float[] jaxaSurroundingCellHeights = new float[9];
                    jaxaSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                    if (isWholeJaxaTileInCollectTile) {
                        collector.addValueSimple(cellLeft, cellTop, cellRight, cellBottom, zoom, value, tileOutputter);
                        continue;
                    }
                    if (x == 0 && y == 0) {
                        jaxaSurroundingCellHeights[0] = surroundingTiles[0].getFlattenedBuffer()[this.jaxaTileSize - 1][this.jaxaTileSize - 1];
                        jaxaSurroundingCellHeights[1] = surroundingTiles[1].getFlattenedBuffer()[this.jaxaTileSize - 1][x];
                        jaxaSurroundingCellHeights[2] = surroundingTiles[1].getFlattenedBuffer()[this.jaxaTileSize - 1][x + 1];
                        jaxaSurroundingCellHeights[3] = surroundingTiles[3].getFlattenedBuffer()[y][this.jaxaTileSize - 1];
                        jaxaSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                        jaxaSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                        jaxaSurroundingCellHeights[6] = surroundingTiles[3].getFlattenedBuffer()[y + 1][this.jaxaTileSize - 1];
                        jaxaSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                        jaxaSurroundingCellHeights[8] = this.flattenedBuffer[y + 1][x + 1];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, jaxaSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (x == this.jaxaTileSize - 1 && y == 0) {
                        jaxaSurroundingCellHeights[0] = surroundingTiles[1].getFlattenedBuffer()[this.jaxaTileSize - 1][x - 1];
                        jaxaSurroundingCellHeights[1] = surroundingTiles[1].getFlattenedBuffer()[this.jaxaTileSize - 1][x];
                        jaxaSurroundingCellHeights[2] = surroundingTiles[2].getFlattenedBuffer()[this.jaxaTileSize - 1][0];
                        jaxaSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                        jaxaSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                        jaxaSurroundingCellHeights[5] = surroundingTiles[5].getFlattenedBuffer()[y][0];
                        jaxaSurroundingCellHeights[6] = this.flattenedBuffer[y + 1][x - 1];
                        jaxaSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                        jaxaSurroundingCellHeights[8] = surroundingTiles[5].getFlattenedBuffer()[y + 1][0];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, jaxaSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (x == this.jaxaTileSize - 1 && y == this.jaxaTileSize - 1) {
                        jaxaSurroundingCellHeights[0] = this.flattenedBuffer[y - 1][x - 1];
                        jaxaSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                        jaxaSurroundingCellHeights[2] = surroundingTiles[5].getFlattenedBuffer()[y - 1][0];
                        jaxaSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                        jaxaSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                        jaxaSurroundingCellHeights[5] = surroundingTiles[5].getFlattenedBuffer()[y][0];
                        jaxaSurroundingCellHeights[6] = surroundingTiles[7].getFlattenedBuffer()[0][x - 1];
                        jaxaSurroundingCellHeights[7] = surroundingTiles[7].getFlattenedBuffer()[0][x];
                        jaxaSurroundingCellHeights[8] = surroundingTiles[8].getFlattenedBuffer()[0][0];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, jaxaSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (x == 0 && y == this.jaxaTileSize - 1) {
                        jaxaSurroundingCellHeights[0] = surroundingTiles[3].getFlattenedBuffer()[y - 1][this.jaxaTileSize - 1];
                        jaxaSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                        jaxaSurroundingCellHeights[2] = this.flattenedBuffer[y - 1][x + 1];
                        jaxaSurroundingCellHeights[3] = surroundingTiles[3].getFlattenedBuffer()[y][this.jaxaTileSize - 1];
                        jaxaSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                        jaxaSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                        jaxaSurroundingCellHeights[6] = surroundingTiles[6].getFlattenedBuffer()[0][this.jaxaTileSize - 1];
                        jaxaSurroundingCellHeights[7] = surroundingTiles[7].getFlattenedBuffer()[0][x];
                        jaxaSurroundingCellHeights[8] = surroundingTiles[7].getFlattenedBuffer()[0][x + 1];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, jaxaSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (x == 0) {
                        jaxaSurroundingCellHeights[0] = surroundingTiles[3].getFlattenedBuffer()[y - 1][this.jaxaTileSize - 1];
                        jaxaSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                        jaxaSurroundingCellHeights[2] = this.flattenedBuffer[y - 1][x + 1];
                        jaxaSurroundingCellHeights[3] = surroundingTiles[3].getFlattenedBuffer()[y][this.jaxaTileSize - 1];
                        jaxaSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                        jaxaSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                        jaxaSurroundingCellHeights[6] = surroundingTiles[3].getFlattenedBuffer()[y + 1][this.jaxaTileSize - 1];
                        jaxaSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                        jaxaSurroundingCellHeights[8] = this.flattenedBuffer[y + 1][x + 1];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, jaxaSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (x == this.jaxaTileSize - 1) {
                        jaxaSurroundingCellHeights[0] = this.flattenedBuffer[y - 1][x - 1];
                        jaxaSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                        jaxaSurroundingCellHeights[2] = surroundingTiles[5].getFlattenedBuffer()[y - 1][0];
                        jaxaSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                        jaxaSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                        jaxaSurroundingCellHeights[5] = surroundingTiles[5].getFlattenedBuffer()[y][0];
                        jaxaSurroundingCellHeights[6] = this.flattenedBuffer[y + 1][x - 1];
                        jaxaSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                        jaxaSurroundingCellHeights[8] = surroundingTiles[5].getFlattenedBuffer()[y + 1][0];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, jaxaSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (y == 0) {
                        jaxaSurroundingCellHeights[0] = surroundingTiles[1].getFlattenedBuffer()[this.jaxaTileSize - 1][x - 1];
                        jaxaSurroundingCellHeights[1] = surroundingTiles[1].getFlattenedBuffer()[this.jaxaTileSize - 1][x];
                        jaxaSurroundingCellHeights[2] = surroundingTiles[1].getFlattenedBuffer()[this.jaxaTileSize - 1][x + 1];
                        jaxaSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                        jaxaSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                        jaxaSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                        jaxaSurroundingCellHeights[6] = this.flattenedBuffer[y + 1][x - 1];
                        jaxaSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                        jaxaSurroundingCellHeights[8] = this.flattenedBuffer[y + 1][x + 1];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, jaxaSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    if (y == this.jaxaTileSize - 1) {
                        jaxaSurroundingCellHeights[0] = this.flattenedBuffer[y - 1][x - 1];
                        jaxaSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                        jaxaSurroundingCellHeights[2] = this.flattenedBuffer[y - 1][x + 1];
                        jaxaSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                        jaxaSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                        jaxaSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                        jaxaSurroundingCellHeights[6] = surroundingTiles[7].getFlattenedBuffer()[0][x - 1];
                        jaxaSurroundingCellHeights[7] = surroundingTiles[7].getFlattenedBuffer()[0][x];
                        jaxaSurroundingCellHeights[8] = surroundingTiles[7].getFlattenedBuffer()[0][x + 1];
                        collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, jaxaSurroundingCellHeights, tileOutputter);
                        continue;
                    }
                    jaxaSurroundingCellHeights[0] = this.flattenedBuffer[y - 1][x - 1];
                    jaxaSurroundingCellHeights[1] = this.flattenedBuffer[y - 1][x];
                    jaxaSurroundingCellHeights[2] = this.flattenedBuffer[y - 1][x + 1];
                    jaxaSurroundingCellHeights[3] = this.flattenedBuffer[y][x - 1];
                    jaxaSurroundingCellHeights[4] = this.flattenedBuffer[y][x];
                    jaxaSurroundingCellHeights[5] = this.flattenedBuffer[y][x + 1];
                    jaxaSurroundingCellHeights[6] = this.flattenedBuffer[y + 1][x - 1];
                    jaxaSurroundingCellHeights[7] = this.flattenedBuffer[y + 1][x];
                    jaxaSurroundingCellHeights[8] = this.flattenedBuffer[y + 1][x + 1];
                    collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, jaxaSurroundingCellHeights, tileOutputter);
                }
            }
        }
        this.log.debug("renderIntoCollector: finished renderering jaxa tile " + this.fileName + " into collector tile");
        return collector;
    }

    private float getRawHeightIncludingSurroundingTiles(JaxaTileCache jaxaTileCache, int x, int y) {
        if (x >= 0 && x < this.jaxaTileSize && y >= 0 && y < this.jaxaTileSize) {
            return this.rawBuffer[y][x];
        }
        if (x < -this.jaxaTileSize || x >= 2 * this.jaxaTileSize || y < -this.jaxaTileSize && y >= 2 * this.jaxaTileSize) {
            return 0.0f;
        }
        if (x < 0 && y >= 0 && y < this.jaxaTileSize) {
            JaxaTile tile = (JaxaTile)this.getSurroundingTile(jaxaTileCache, -1, 0);
            return tile.getRawHeightIncludingSurroundingTiles(jaxaTileCache, x + this.jaxaTileSize - 1, y);
        }
        if (x >= this.jaxaTileSize && y >= 0 && y < this.jaxaTileSize) {
            JaxaTile tile = (JaxaTile)this.getSurroundingTile(jaxaTileCache, 1, 0);
            return tile.getRawHeightIncludingSurroundingTiles(jaxaTileCache, x - this.jaxaTileSize, y);
        }
        if (x >= 0 && x < this.jaxaTileSize && y < 0) {
            JaxaTile tile = (JaxaTile)this.getSurroundingTile(jaxaTileCache, 0, 1);
            return tile.getRawHeightIncludingSurroundingTiles(jaxaTileCache, x, y + this.jaxaTileSize - 1);
        }
        if (x >= 0 && x < this.jaxaTileSize && y >= this.jaxaTileSize) {
            JaxaTile tile = (JaxaTile)this.getSurroundingTile(jaxaTileCache, 0, -1);
            return tile.getRawHeightIncludingSurroundingTiles(jaxaTileCache, x, y - this.jaxaTileSize);
        }
        if (x < 0 && y < 0) {
            JaxaTile tile = (JaxaTile)this.getSurroundingTile(jaxaTileCache, -1, -1);
            return tile.getRawHeightIncludingSurroundingTiles(jaxaTileCache, x + this.jaxaTileSize - 1, y + this.jaxaTileSize - 1);
        }
        if (x >= this.jaxaTileSize && y < 0) {
            JaxaTile tile = (JaxaTile)this.getSurroundingTile(jaxaTileCache, 1, 1);
            return tile.getRawHeightIncludingSurroundingTiles(jaxaTileCache, x - this.jaxaTileSize, y + this.jaxaTileSize - 1);
        }
        if (x >= this.jaxaTileSize && y >= this.jaxaTileSize) {
            JaxaTile tile = (JaxaTile)this.getSurroundingTile(jaxaTileCache, 1, -1);
            return tile.getRawHeightIncludingSurroundingTiles(jaxaTileCache, x - this.jaxaTileSize, y - this.jaxaTileSize);
        }
        if (x < 0 && y >= this.jaxaTileSize) {
            JaxaTile tile = (JaxaTile)this.getSurroundingTile(jaxaTileCache, -1, -1);
            return tile.getRawHeightIncludingSurroundingTiles(jaxaTileCache, x + this.jaxaTileSize - 1, y - this.jaxaTileSize);
        }
        return -32768.0f;
    }

    @Override
    public synchronized void flatten(int zoom, int xTileIndex, int yTileIndex, RenderRequest renderRequest) {
        if (this.flattened) {
            return;
        }
        if (this.heightDiffThreshold <= 0) {
            this.flattenedBuffer = this.rawBuffer;
            return;
        }
        this.log.info("flatten: flatten tile " + this.fileName);
        this.flattenedBuffer = new float[this.jaxaTileSize][this.jaxaTileSize];
        int miniLevelRadius = 1;
        for (int y = 0; y < this.jaxaTileSize; ++y) {
            for (int x = 0; x < this.jaxaTileSize; ++x) {
                float averageSurroundingHeight;
                float diff;
                float height = this.rawBuffer[y][x];
                if (y == 0 || x == 0 || y == this.jaxaTileSize - 1 || x == this.jaxaTileSize - 1) {
                    this.flattenedBuffer[y][x] = height;
                    continue;
                }
                int leftLevelIndex = x - miniLevelRadius;
                int rightLevelIndex = x + miniLevelRadius;
                int topLevelIndex = y - miniLevelRadius;
                int bottomLevelIndex = y + miniLevelRadius;
                float surroundingHeights = 0.0f;
                float surroundingHeightPoints = 0.0f;
                for (int i = leftLevelIndex; i <= rightLevelIndex; ++i) {
                    for (int j = topLevelIndex; j <= bottomLevelIndex; ++j) {
                        if (i == x && j == y) continue;
                        surroundingHeights += this.rawBuffer[j][i];
                        surroundingHeightPoints += 1.0f;
                    }
                }
                if (surroundingHeightPoints == 0.0f) {
                    surroundingHeights = height;
                    surroundingHeightPoints = 1.0f;
                }
                this.flattenedBuffer[y][x] = (diff = Math.abs((averageSurroundingHeight = surroundingHeights / surroundingHeightPoints) - height)) < (float)this.heightPointDiffThreshold ? averageSurroundingHeight : height;
            }
        }
        float[][] newValues = new float[this.jaxaTileSize][this.jaxaTileSize];
        int levelRadius = 5;
        for (int y = 0; y < this.jaxaTileSize; ++y) {
            for (int x = 0; x < this.jaxaTileSize; ++x) {
                int currentX;
                int xI;
                int currentY;
                int yI;
                int bottomLevelIndex;
                int topLevelIndex;
                int rightLevelIndex;
                float height = this.flattenedBuffer[y][x];
                int leftLevelIndex = x - levelRadius;
                if (leftLevelIndex < 0) {
                    leftLevelIndex = 0;
                }
                if ((rightLevelIndex = x + levelRadius) > this.jaxaTileSize) {
                    rightLevelIndex = this.jaxaTileSize;
                }
                if (rightLevelIndex == leftLevelIndex) {
                    rightLevelIndex = leftLevelIndex + 1;
                }
                if ((topLevelIndex = y - levelRadius) < 0) {
                    topLevelIndex = 0;
                }
                if ((bottomLevelIndex = y + levelRadius) > this.jaxaTileSize) {
                    bottomLevelIndex = this.jaxaTileSize;
                }
                if (bottomLevelIndex == topLevelIndex) {
                    bottomLevelIndex = topLevelIndex + 1;
                }
                float totalValues = 0.0f;
                float counter = 0.0f;
                boolean[][] isOverThresholdArray = new boolean[2 * levelRadius + 1][2 * levelRadius + 1];
                for (yI = 0; yI < 2 * levelRadius + 1; ++yI) {
                    for (int xI2 = 0; xI2 < 2 * levelRadius + 1; ++xI2) {
                        isOverThresholdArray[yI][xI2] = false;
                    }
                }
                for (yI = 0; yI < 2 * levelRadius + 1; ++yI) {
                    currentY = y - levelRadius + yI;
                    if (currentY < topLevelIndex || currentY >= bottomLevelIndex) continue;
                    for (xI = 0; xI < 2 * levelRadius + 1; ++xI) {
                        float currentHeight;
                        float heightDelta;
                        currentX = x - levelRadius + xI;
                        if (currentX < leftLevelIndex || currentX >= rightLevelIndex || !((heightDelta = Math.abs((currentHeight = this.flattenedBuffer[currentY][currentX]) - height)) > (float)this.heightDiffThreshold)) continue;
                        this.safeSetBooleanArray(isOverThresholdArray, xI - 1, yI - 1, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI, yI - 1, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI + 1, yI - 1, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI - 1, yI, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI, yI, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI + 1, yI, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI - 1, yI + 1, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI, yI + 1, true);
                        this.safeSetBooleanArray(isOverThresholdArray, xI + 1, yI + 1, true);
                    }
                }
                for (yI = 0; yI < 2 * levelRadius + 1; ++yI) {
                    currentY = y - levelRadius + yI;
                    if (currentY < topLevelIndex || currentY >= bottomLevelIndex) continue;
                    for (xI = 0; xI < 2 * levelRadius + 1; ++xI) {
                        currentX = x - levelRadius + xI;
                        if (currentX < leftLevelIndex || currentX >= rightLevelIndex || isOverThresholdArray[yI][xI] || !this.IsArrayAccessible(this.flattenedBuffer, currentX, currentY)) continue;
                        totalValues += this.flattenedBuffer[currentY][currentX];
                        counter += 1.0f;
                    }
                }
                newValues[y][x] = counter == 0.0f ? height : totalValues / counter;
            }
        }
        this.flattenedBuffer = newValues;
        String flattenedCacheBaseFolder = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getDatasources().getJaxa().getFlattenedCache();
        if (flattenedCacheBaseFolder != null) {
            JaxaFlattenedTileCachePersister flattenedTileCachePersister = new JaxaFlattenedTileCachePersister(flattenedCacheBaseFolder);
            flattenedTileCachePersister.persist(zoom, xTileIndex, yTileIndex, this, this.heightDiffThreshold);
        }
        this.flattened = true;
    }

    private void safeSetBooleanArray(boolean[][] array, int x, int y, boolean value) {
        if (this.IsArrayAccessible(array, x, y)) {
            array[y][x] = value;
        }
    }

    private boolean IsArrayAccessible(boolean[][] array, int x, int y) {
        int arraySize = array.length;
        return x >= 0 && x < arraySize && y >= 0 && y < arraySize;
    }

    private boolean IsArrayAccessible(float[][] array, int x, int y) {
        int arraySize = array.length;
        return x >= 0 && x <= arraySize && y >= 0 && y <= arraySize;
    }

    public boolean equals(Object other) {
        if (!this.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        JaxaTile otherTile = (JaxaTile)other;
        return this.lat == otherTile.lat && this.lon == otherTile.lon && this.heightDiffThreshold == otherTile.heightDiffThreshold;
    }

    @Override
    public void logBufferFlattened() {
        for (int y = 0; y < this.flattenedBuffer.length; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = 0; x < this.flattenedBuffer[y].length; ++x) {
                float value = this.flattenedBuffer[y][x];
                if (value != 0.0f) {
                    rowBuffy.append("1");
                    continue;
                }
                rowBuffy.append("0");
            }
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String toString() {
        return "JaxaTile[lon=" + this.lon + ", lat=" + this.lat + ", loaded=" + this.loaded + ", heightDiffThreshold=" + this.heightDiffThreshold + ", size=[" + this.rawBuffer.length + "][" + this.rawBuffer[0].length + "]]";
    }
}

